package org.immutables.fixture.couse;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NotYetGeneratedGenericsInDefaultInitializer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNotYetGeneratedGenericsInDefaultInitializer.builder()}.
 */
@Generated(from = "NotYetGeneratedGenericsInDefaultInitializer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableNotYetGeneratedGenericsInDefaultInitializer
    implements NotYetGeneratedGenericsInDefaultInitializer {
  private final Supplier<Stream<ImmutableToBeGenX<?, ?>>> eventSupplier;

  private ImmutableNotYetGeneratedGenericsInDefaultInitializer(ImmutableNotYetGeneratedGenericsInDefaultInitializer.Builder builder) {
    this.eventSupplier = builder.eventSupplier != null
        ? builder.eventSupplier
        : Objects.requireNonNull(NotYetGeneratedGenericsInDefaultInitializer.super.getEventSupplier(), "eventSupplier");
  }

  private ImmutableNotYetGeneratedGenericsInDefaultInitializer(Supplier<Stream<ImmutableToBeGenX<?, ?>>> eventSupplier) {
    this.eventSupplier = eventSupplier;
  }

  /**
   * @return The value of the {@code eventSupplier} attribute
   */
  @Override
  public Supplier<Stream<ImmutableToBeGenX<?, ?>>> getEventSupplier() {
    return eventSupplier;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NotYetGeneratedGenericsInDefaultInitializer#getEventSupplier() eventSupplier} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventSupplier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNotYetGeneratedGenericsInDefaultInitializer withEventSupplier(Supplier<Stream<ImmutableToBeGenX<?, ?>>> value) {
    if (this.eventSupplier == value) return this;
    Supplier<Stream<ImmutableToBeGenX<?, ?>>> newValue = Objects.requireNonNull(value, "eventSupplier");
    return new ImmutableNotYetGeneratedGenericsInDefaultInitializer(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNotYetGeneratedGenericsInDefaultInitializer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNotYetGeneratedGenericsInDefaultInitializer
        && equalTo(0, (ImmutableNotYetGeneratedGenericsInDefaultInitializer) another);
  }

  private boolean equalTo(int synthetic, ImmutableNotYetGeneratedGenericsInDefaultInitializer another) {
    return eventSupplier.equals(another.eventSupplier);
  }

  /**
   * Computes a hash code from attributes: {@code eventSupplier}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + eventSupplier.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NotYetGeneratedGenericsInDefaultInitializer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NotYetGeneratedGenericsInDefaultInitializer")
        .omitNullValues()
        .add("eventSupplier", eventSupplier)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NotYetGeneratedGenericsInDefaultInitializer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NotYetGeneratedGenericsInDefaultInitializer instance
   */
  public static ImmutableNotYetGeneratedGenericsInDefaultInitializer copyOf(NotYetGeneratedGenericsInDefaultInitializer instance) {
    if (instance instanceof ImmutableNotYetGeneratedGenericsInDefaultInitializer) {
      return (ImmutableNotYetGeneratedGenericsInDefaultInitializer) instance;
    }
    return ImmutableNotYetGeneratedGenericsInDefaultInitializer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNotYetGeneratedGenericsInDefaultInitializer ImmutableNotYetGeneratedGenericsInDefaultInitializer}.
   * <pre>
   * ImmutableNotYetGeneratedGenericsInDefaultInitializer.builder()
   *    .eventSupplier(function.Supplier&amp;lt;stream.Stream&amp;lt;ImmutableToBeGenX&amp;lt;?, ?&amp;gt;&amp;gt;&amp;gt;) // optional {@link NotYetGeneratedGenericsInDefaultInitializer#getEventSupplier() eventSupplier}
   *    .build();
   * </pre>
   * @return A new ImmutableNotYetGeneratedGenericsInDefaultInitializer builder
   */
  public static ImmutableNotYetGeneratedGenericsInDefaultInitializer.Builder builder() {
    return new ImmutableNotYetGeneratedGenericsInDefaultInitializer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNotYetGeneratedGenericsInDefaultInitializer ImmutableNotYetGeneratedGenericsInDefaultInitializer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NotYetGeneratedGenericsInDefaultInitializer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Supplier<Stream<ImmutableToBeGenX<?, ?>>> eventSupplier;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NotYetGeneratedGenericsInDefaultInitializer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NotYetGeneratedGenericsInDefaultInitializer instance) {
      Objects.requireNonNull(instance, "instance");
      eventSupplier(instance.getEventSupplier());
      return this;
    }

    /**
     * Initializes the value for the {@link NotYetGeneratedGenericsInDefaultInitializer#getEventSupplier() eventSupplier} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NotYetGeneratedGenericsInDefaultInitializer#getEventSupplier() eventSupplier}.</em>
     * @param eventSupplier The value for eventSupplier 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder eventSupplier(Supplier<Stream<ImmutableToBeGenX<?, ?>>> eventSupplier) {
      this.eventSupplier = Objects.requireNonNull(eventSupplier, "eventSupplier");
      return this;
    }

    /**
     * Builds a new {@link ImmutableNotYetGeneratedGenericsInDefaultInitializer ImmutableNotYetGeneratedGenericsInDefaultInitializer}.
     * @return An immutable instance of NotYetGeneratedGenericsInDefaultInitializer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNotYetGeneratedGenericsInDefaultInitializer build() {
      return new ImmutableNotYetGeneratedGenericsInDefaultInitializer(this);
    }
  }
}
