package org.immutables.fixture.couse.sub2;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.couse.B;
import org.immutables.fixture.couse.Trait;
import org.immutables.fixture.couse.sub.C;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractZ}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Z.builder()}.
 */
@Generated(from = "AbstractZ", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class Z implements AbstractZ {
  private final B b;
  private final C c;

  private Z(B b, C c) {
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public B b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public C c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractZ#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final Z withB(B value) {
    if (this.b == value) return this;
    B newValue = Objects.requireNonNull(value, "b");
    return new Z(newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractZ#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final Z withC(C value) {
    if (this.c == value) return this;
    C newValue = Objects.requireNonNull(value, "c");
    return new Z(this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Z} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Z
        && equalTo(0, (Z) another);
  }

  private boolean equalTo(int synthetic, Z another) {
    return b.equals(another.b)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Z} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Z")
        .omitNullValues()
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractZ} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Z instance
   */
  public static Z copyOf(AbstractZ instance) {
    if (instance instanceof Z) {
      return (Z) instance;
    }
    return Z.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Z Z}.
   * <pre>
   * Z.builder()
   *    .b(org.immutables.fixture.couse.B) // required {@link AbstractZ#b() b}
   *    .c(org.immutables.fixture.couse.sub.C) // required {@link AbstractZ#c() c}
   *    .build();
   * </pre>
   * @return A new Z builder
   */
  public static Z.Builder builder() {
    return new Z.Builder();
  }

  /**
   * Builds instances of type {@link Z Z}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractZ", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_B = 0x1L;
    private static final long INIT_BIT_C = 0x2L;
    private long initBits = 0x3L;

    private @Nullable B b;
    private @Nullable C c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.couse.sub2.AbstractZ} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractZ instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.couse.Trait} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Trait instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof AbstractZ) {
        AbstractZ instance = (AbstractZ) object;
        if ((bits & 0x1L) == 0) {
          b(instance.b());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          c(instance.c());
          bits |= 0x2L;
        }
      }
      if (object instanceof Trait) {
        Trait instance = (Trait) object;
        if ((bits & 0x1L) == 0) {
          b(instance.b());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          c(instance.c());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractZ#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(B b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractZ#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(C c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link Z Z}.
     * @return An immutable instance of Z
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Z build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Z(b, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build Z, some of required attributes are not set " + attributes;
    }
  }
}
