package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeepNullable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeepNullable.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDeepNullable.of()}.
 */
@Generated(from = "DeepNullable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDeepNullable implements DeepNullable {
  private final @Nullable ImmutableDeepChild child;
  private final @Nullable ImmutableDeepStepChild another;

  private ImmutableDeepNullable(
      @Nullable DeepChild child,
      @Nullable DeepStepChild another) {
    this.child = child == null ? null : ImmutableDeepChild.copyOf(child);
    this.another = another == null ? null : ImmutableDeepStepChild.copyOf(another);
  }

  private ImmutableDeepNullable(
      ImmutableDeepNullable original,
      @Nullable ImmutableDeepChild child,
      @Nullable ImmutableDeepStepChild another) {
    this.child = child;
    this.another = another;
  }

  /**
   * @return The value of the {@code child} attribute
   */
  @Override
  public @Nullable ImmutableDeepChild child() {
    return child;
  }

  /**
   * @return The value of the {@code another} attribute
   */
  @Override
  public @Nullable ImmutableDeepStepChild another() {
    return another;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeepNullable#child() child} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for child (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeepNullable withChild(@Nullable DeepChild value) {
    if (this.child == value) return this;
    @Nullable ImmutableDeepChild newValue = value == null ? null : ImmutableDeepChild.copyOf(value);
    return new ImmutableDeepNullable(this, newValue, this.another);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeepNullable#another() another} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for another (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeepNullable withAnother(@Nullable DeepStepChild value) {
    if (this.another == value) return this;
    @Nullable ImmutableDeepStepChild newValue = value == null ? null : ImmutableDeepStepChild.copyOf(value);
    return new ImmutableDeepNullable(this, this.child, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeepNullable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeepNullable
        && equalTo(0, (ImmutableDeepNullable) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeepNullable another) {
    return Objects.equals(child, another.child)
        && Objects.equals(this.another, another.another);
  }

  /**
   * Computes a hash code from attributes: {@code child}, {@code another}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(child);
    h += (h << 5) + Objects.hashCode(another);
    return h;
  }

  /**
   * Prints the immutable value {@code DeepNullable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeepNullable")
        .omitNullValues()
        .add("child", child)
        .add("another", another)
        .toString();
  }

  /**
   * Construct a new immutable {@code DeepNullable} instance.
   * @param child The value for the {@code child} attribute
   * @param another The value for the {@code another} attribute
   * @return An immutable DeepNullable instance
   */
  public static ImmutableDeepNullable of(@Nullable DeepChild child, @Nullable DeepStepChild another) {
    return new ImmutableDeepNullable(child, another);
  }

  /**
   * Creates an immutable copy of a {@link DeepNullable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeepNullable instance
   */
  public static ImmutableDeepNullable copyOf(DeepNullable instance) {
    if (instance instanceof ImmutableDeepNullable) {
      return (ImmutableDeepNullable) instance;
    }
    return ImmutableDeepNullable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeepNullable ImmutableDeepNullable}.
   * <pre>
   * ImmutableDeepNullable.builder()
   *    .child(org.immutables.fixture.deep.DeepChild | null) // nullable {@link DeepNullable#child() child}
   *    .another(org.immutables.fixture.deep.DeepStepChild | null) // nullable {@link DeepNullable#another() another}
   *    .build();
   * </pre>
   * @return A new ImmutableDeepNullable builder
   */
  public static ImmutableDeepNullable.Builder builder() {
    return new ImmutableDeepNullable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeepNullable ImmutableDeepNullable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeepNullable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable DeepChild child;
    private @Nullable DeepStepChild another;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeepNullable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeepNullable instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable DeepChild childValue = instance.child();
      if (childValue != null) {
        child(childValue);
      }
      @Nullable DeepStepChild anotherValue = instance.another();
      if (anotherValue != null) {
        another(anotherValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DeepNullable#child() child} attribute.
     * @param child The value for child (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder child(@Nullable DeepChild child) {
      this.child = child == null ? null : ImmutableDeepChild.copyOf(child);
      return this;
    }

    /**
     * Initializes the value for the {@link DeepNullable#another() another} attribute.
     * @param another The value for another (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder another(@Nullable DeepStepChild another) {
      this.another = another == null ? null : ImmutableDeepStepChild.copyOf(another);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeepNullable ImmutableDeepNullable}.
     * @return An immutable instance of DeepNullable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeepNullable build() {
      return new ImmutableDeepNullable(
          null,
          child == null ? null : ImmutableDeepChild.copyOf(child),
          another == null ? null : ImmutableDeepStepChild.copyOf(another));
    }
  }
}
