package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Canvas.Line}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLine.builder()}.
 */
@Generated(from = "Canvas.Line", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLine implements Canvas.Line {
  private final ImmutableList<Canvas.Point> points;
  private final ImmutableColor color;
  private final @Nullable Canvas.Color shadow;

  private ImmutableLine(
      ImmutableList<Canvas.Point> points,
      ImmutableColor color,
      @Nullable Canvas.Color shadow) {
    this.points = points;
    this.color = color;
    this.shadow = shadow;
  }

  /**
   * @return The value of the {@code points} attribute
   */
  @Override
  public ImmutableList<Canvas.Point> points() {
    return points;
  }

  /**
   * @return The value of the {@code color} attribute
   */
  @Override
  public ImmutableColor color() {
    return color;
  }

  /**
   * @return The value of the {@code shadow} attribute
   */
  @Override
  public Optional<Canvas.Color> shadow() {
    return Optional.ofNullable(shadow);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Canvas.Line#points() points}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLine withPoints(Canvas.Point... elements) {
    ImmutableList<Canvas.Point> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLine(newValue, this.color, this.shadow);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Canvas.Line#points() points}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of points elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLine withPoints(Iterable<? extends Canvas.Point> elements) {
    if (this.points == elements) return this;
    ImmutableList<Canvas.Point> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLine(newValue, this.color, this.shadow);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Canvas.Line#color() color} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for color
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLine withColor(Canvas.Color value) {
    if (this.color == value) return this;
    ImmutableColor newValue = ImmutableColor.copyOf(value);
    return new ImmutableLine(this.points, newValue, this.shadow);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Canvas.Line#shadow() shadow} attribute.
   * @param value The value for shadow
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLine withShadow(Canvas.Color value) {
    Canvas.Color newValue = Objects.requireNonNull(value, "shadow");
    if (this.shadow == newValue) return this;
    return new ImmutableLine(this.points, this.color, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Canvas.Line#shadow() shadow} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for shadow
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableLine withShadow(Optional<? extends Canvas.Color> optional) {
    @Nullable Canvas.Color value = optional.orElse(null);
    if (this.shadow == value) return this;
    return new ImmutableLine(this.points, this.color, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLine} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLine
        && equalTo(0, (ImmutableLine) another);
  }

  private boolean equalTo(int synthetic, ImmutableLine another) {
    return points.equals(another.points)
        && color.equals(another.color)
        && Objects.equals(shadow, another.shadow);
  }

  /**
   * Computes a hash code from attributes: {@code points}, {@code color}, {@code shadow}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + points.hashCode();
    h += (h << 5) + color.hashCode();
    h += (h << 5) + Objects.hashCode(shadow);
    return h;
  }

  /**
   * Prints the immutable value {@code Line} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Line")
        .omitNullValues()
        .add("points", points)
        .add("color", color)
        .add("shadow", shadow)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Canvas.Line} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Line instance
   */
  public static ImmutableLine copyOf(Canvas.Line instance) {
    if (instance instanceof ImmutableLine) {
      return (ImmutableLine) instance;
    }
    return ImmutableLine.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLine ImmutableLine}.
   * <pre>
   * ImmutableLine.builder()
   *    .addPoint|addAllPoints(org.immutables.fixture.deep.Canvas.Point) // {@link Canvas.Line#points() points} elements
   *    .color(org.immutables.fixture.deep.Canvas.Color) // required {@link Canvas.Line#color() color}
   *    .shadow(org.immutables.fixture.deep.Canvas.Color) // optional {@link Canvas.Line#shadow() shadow}
   *    .build();
   * </pre>
   * @return A new ImmutableLine builder
   */
  public static ImmutableLine.Builder builder() {
    return new ImmutableLine.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLine ImmutableLine}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Canvas.Line", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COLOR = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<Canvas.Point> points = ImmutableList.builder();
    private @Nullable Canvas.Color color;
    private @Nullable Canvas.Color shadow;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableLine} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableLine instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPoints(instance.points());
      if (instance.colorIsSet()) {
        color(instance.color());
      }
      Optional<Canvas.Color> shadowOptional = instance.shadow();
      if (shadowOptional.isPresent()) {
        shadow(shadowOptional);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Line} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Canvas.Line instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableLine) {
        return from((ModifiableLine) instance);
      }
      addAllPoints(instance.points());
      color(instance.color());
      Optional<Canvas.Color> shadowOptional = instance.shadow();
      if (shadowOptional.isPresent()) {
        shadow(shadowOptional);
      }
      return this;
    }

    /**
     * Adds one element to {@link Canvas.Line#points() points} list.
     * @param element A points element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPoint(Canvas.Point element) {
      element = ImmutablePoint.copyOf(element);
      this.points.add(element);
      return this;
    }

    /**
     * Constructs and adds an element for the {@link Canvas.Line#points() points} list.
     * @param x The value for {@code points.x} 
     * @param y The value for {@code points.y} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPoint(int x, int y) {
      return addPoint(ImmutablePoint.of(x, y));
    }

    /**
     * Adds elements to {@link Canvas.Line#points() points} list.
     * @param elements An array of points elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPoints(Canvas.Point... elements) {
      for (Canvas.Point element : elements) {
        element = ImmutablePoint.copyOf(element);
        this.points.add(Objects.requireNonNull(element, "points element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Canvas.Line#points() points} list.
     * @param elements An iterable of points elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder points(Iterable<? extends Canvas.Point> elements) {
      this.points = ImmutableList.builder();
      return addAllPoints(elements);
    }

    /**
     * Adds elements to {@link Canvas.Line#points() points} list.
     * @param elements An iterable of points elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPoints(Iterable<? extends Canvas.Point> elements) {
      for (Canvas.Point element : elements) {
        element = ImmutablePoint.copyOf(element);
        this.points.add(Objects.requireNonNull(element, "points element"));
      }
      return this;
    }

    /**
     * Constructs and initializes the value for the {@link Canvas.Line#color() color} attribute.
     * @param red The value for {@code color.red} 
     * @param green The value for {@code color.green} 
     * @param blue The value for {@code color.blue} 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder color(double red, double green, double blue) {
      return color(ImmutableColor.of(red, green, blue));
    }

    /**
     * Initializes the value for the {@link Canvas.Line#color() color} attribute.
     * @param color The value for color 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder color(Canvas.Color color) {
      this.color = ImmutableColor.copyOf(color);
      initBits &= ~INIT_BIT_COLOR;
      return this;
    }

    /**
     * Initializes the optional value {@link Canvas.Line#shadow() shadow} to shadow.
     * @param shadow The value for shadow
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder shadow(Canvas.Color shadow) {
      this.shadow = Objects.requireNonNull(shadow, "shadow");
      return this;
    }

    /**
     * Constructs and initializes the optional value for the {@link Canvas.Line#shadow() shadow} attribute.
     * @param red The value for {@code shadow.red} 
     * @param green The value for {@code shadow.green} 
     * @param blue The value for {@code shadow.blue} 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder shadow(double red, double green, double blue) {
      return shadow(ImmutableColor.of(red, green, blue));
    }

    /**
     * Initializes the optional value {@link Canvas.Line#shadow() shadow} to shadow.
     * @param shadow The value for shadow
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder shadow(Optional<? extends Canvas.Color> shadow) {
      this.shadow = shadow.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableLine ImmutableLine}.
     * @return An immutable instance of Line
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLine build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLine(points.build(), ImmutableColor.copyOf(color), shadow);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COLOR) != 0) attributes.add("color");
      return "Cannot build Line, some of required attributes are not set " + attributes;
    }
  }
}
