package org.immutables.fixture.encoding.defs;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.fixture.encoding.defs.MutableListEncoding",
  imports = {
  },
  typeParams = {"T"},
  elements = {
    @EncodingMetadata.Element(
      name = "impl",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "mutableListEncoding_from",
      tags = {"STATIC", "PRIVATE", "FROM", "SYNTH"},
      naming = "*_from",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {"value: java.util.List<T>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^value;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING", "SYNTH"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:mutableListEncoding_get().toString();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE", "SYNTH"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:mutableListEncoding_get().hashCode();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS", "SYNTH"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {"other: org.immutables.fixture.encoding.defs.MutableListEncoding<T>"},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@:mutableListEncoding_get().equals(@^other.@:mutableListEncoding_get())\n;}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "build",
      tags = {"BUILDER", "PRIVATE", "BUILD"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@list;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "mutableListEncoding_get",
      tags = {"EXPOSE", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@impl;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "mutableListEncoding_copy",
      tags = {"COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {"value: java.util.List<T>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^value;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "list",
      tags = {"BUILDER", "PRIVATE", "FIELD"},
      naming = "*_list",
      stdNaming = "NONE",
      type = "java.util.List<T>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "new java.util.ArrayList<>()",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "setValue",
      tags = {"BUILDER", "INIT"},
      naming = "set*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"obj: T"},
      doc = {},
      annotations = {},
      code = "{\n@@list.add(@^obj);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "set",
      tags = {"BUILDER", "INIT", "COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"list: java.util.List<T>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@list = @^list;\n}",
      thrown = {}
    )
  }
)
public @interface MutableListEncodingEnabled {}
