package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FromGenericInh.Baz}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBaz.builder()}.
 */
@Generated(from = "FromGenericInh.Baz", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBaz implements FromGenericInh.Baz {
  private final FromGenericInh.Bar foo;
  private final String barId;
  private final String bazId;

  private ImmutableBaz(
      FromGenericInh.Bar foo,
      String barId,
      String bazId) {
    this.foo = foo;
    this.barId = barId;
    this.bazId = bazId;
  }

  /**
   * @return The value of the {@code foo} attribute
   */
  @Override
  public FromGenericInh.Bar getFoo() {
    return foo;
  }

  /**
   * @return The value of the {@code barId} attribute
   */
  @Override
  public String getBarId() {
    return barId;
  }

  /**
   * @return The value of the {@code bazId} attribute
   */
  @Override
  public String getBazId() {
    return bazId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromGenericInh.Baz#getFoo() foo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for foo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBaz withFoo(FromGenericInh.Bar value) {
    if (this.foo == value) return this;
    FromGenericInh.Bar newValue = Objects.requireNonNull(value, "foo");
    return new ImmutableBaz(newValue, this.barId, this.bazId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromGenericInh.Baz#getBarId() barId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for barId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBaz withBarId(String value) {
    String newValue = Objects.requireNonNull(value, "barId");
    if (this.barId.equals(newValue)) return this;
    return new ImmutableBaz(this.foo, newValue, this.bazId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromGenericInh.Baz#getBazId() bazId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bazId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBaz withBazId(String value) {
    String newValue = Objects.requireNonNull(value, "bazId");
    if (this.bazId.equals(newValue)) return this;
    return new ImmutableBaz(this.foo, this.barId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBaz} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBaz
        && equalTo(0, (ImmutableBaz) another);
  }

  private boolean equalTo(int synthetic, ImmutableBaz another) {
    return foo.equals(another.foo)
        && barId.equals(another.barId)
        && bazId.equals(another.bazId);
  }

  /**
   * Computes a hash code from attributes: {@code foo}, {@code barId}, {@code bazId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + foo.hashCode();
    h += (h << 5) + barId.hashCode();
    h += (h << 5) + bazId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Baz} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Baz")
        .omitNullValues()
        .add("foo", foo)
        .add("barId", barId)
        .add("bazId", bazId)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FromGenericInh.Baz} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Baz instance
   */
  public static ImmutableBaz copyOf(FromGenericInh.Baz instance) {
    if (instance instanceof ImmutableBaz) {
      return (ImmutableBaz) instance;
    }
    return ImmutableBaz.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBaz ImmutableBaz}.
   * <pre>
   * ImmutableBaz.builder()
   *    .foo(org.immutables.fixture.generics.FromGenericInh.Bar) // required {@link FromGenericInh.Baz#getFoo() foo}
   *    .barId(String) // required {@link FromGenericInh.Baz#getBarId() barId}
   *    .bazId(String) // required {@link FromGenericInh.Baz#getBazId() bazId}
   *    .build();
   * </pre>
   * @return A new ImmutableBaz builder
   */
  public static ImmutableBaz.Builder builder() {
    return new ImmutableBaz.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBaz ImmutableBaz}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FromGenericInh.Baz", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FOO = 0x1L;
    private static final long INIT_BIT_BAR_ID = 0x2L;
    private static final long INIT_BIT_BAZ_ID = 0x4L;
    private long initBits = 0x7L;

    private @Nullable FromGenericInh.Bar foo;
    private @Nullable String barId;
    private @Nullable String bazId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.FromGenericInh.Baz} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FromGenericInh.Baz instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.FromGenericInh.Bar} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FromGenericInh.Bar instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof FromGenericInh.Baz) {
        FromGenericInh.Baz instance = (FromGenericInh.Baz) object;
        bazId(instance.getBazId());
        if ((bits & 0x1L) == 0) {
          barId(instance.getBarId());
          bits |= 0x1L;
        }
        foo(instance.getFoo());
      }
      if (object instanceof FromGenericInh.Bar) {
        FromGenericInh.Bar instance = (FromGenericInh.Bar) object;
        if ((bits & 0x1L) == 0) {
          barId(instance.getBarId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link FromGenericInh.Baz#getFoo() foo} attribute.
     * @param foo The value for foo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder foo(FromGenericInh.Bar foo) {
      this.foo = Objects.requireNonNull(foo, "foo");
      initBits &= ~INIT_BIT_FOO;
      return this;
    }

    /**
     * Initializes the value for the {@link FromGenericInh.Baz#getBarId() barId} attribute.
     * @param barId The value for barId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder barId(String barId) {
      this.barId = Objects.requireNonNull(barId, "barId");
      initBits &= ~INIT_BIT_BAR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FromGenericInh.Baz#getBazId() bazId} attribute.
     * @param bazId The value for bazId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bazId(String bazId) {
      this.bazId = Objects.requireNonNull(bazId, "bazId");
      initBits &= ~INIT_BIT_BAZ_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBaz ImmutableBaz}.
     * @return An immutable instance of Baz
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBaz build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBaz(foo, barId, bazId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FOO) != 0) attributes.add("foo");
      if ((initBits & INIT_BIT_BAR_ID) != 0) attributes.add("barId");
      if ((initBits & INIT_BIT_BAZ_ID) != 0) attributes.add("bazId");
      return "Cannot build Baz, some of required attributes are not set " + attributes;
    }
  }
}
