package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BlogEvent.AbstractBodyChanged}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BodyChanged.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code BodyChanged.of()}.
 */
@Generated(from = "BlogEvent.AbstractBodyChanged", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class BodyChanged implements BlogEvent.AbstractBodyChanged {
  private final String body;

  private BodyChanged(String body) {
    this.body = Objects.requireNonNull(body, "body");
  }

  private BodyChanged(BodyChanged original, String body) {
    this.body = body;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @JsonProperty("body")
  @Override
  public String getBody() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlogEvent.AbstractBodyChanged#getBody() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body
   * @return A modified copy of the {@code this} object
   */
  public final BodyChanged withBody(String value) {
    String newValue = Objects.requireNonNull(value, "body");
    if (this.body.equals(newValue)) return this;
    return new BodyChanged(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code BodyChanged} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof BodyChanged
        && equalTo(0, (BodyChanged) another);
  }

  private boolean equalTo(int synthetic, BodyChanged another) {
    return body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BodyChanged} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BodyChanged")
        .omitNullValues()
        .add("body", body)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "BlogEvent.AbstractBodyChanged", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlogEvent.AbstractBodyChanged {
    @Nullable String body;
    @JsonProperty("body")
    public void setBody(String body) {
      this.body = body;
    }
    @Override
    public String getBody() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BodyChanged fromJson(Json json) {
    BodyChanged.Builder builder = BodyChanged.builder();
    if (json.body != null) {
      builder.body(json.body);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code BodyChanged} instance.
   * @param body The value for the {@code body} attribute
   * @return An immutable BodyChanged instance
   */
  public static BodyChanged of(String body) {
    return new BodyChanged(body);
  }

  /**
   * Creates an immutable copy of a {@link BlogEvent.AbstractBodyChanged} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BodyChanged instance
   */
  public static BodyChanged copyOf(BlogEvent.AbstractBodyChanged instance) {
    if (instance instanceof BodyChanged) {
      return (BodyChanged) instance;
    }
    return BodyChanged.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link BodyChanged BodyChanged}.
   * <pre>
   * BodyChanged.builder()
   *    .body(String) // required {@link BlogEvent.AbstractBodyChanged#getBody() body}
   *    .build();
   * </pre>
   * @return A new BodyChanged builder
   */
  public static BodyChanged.Builder builder() {
    return new BodyChanged.Builder();
  }

  /**
   * Builds instances of type {@link BodyChanged BodyChanged}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BlogEvent.AbstractBodyChanged", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BODY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String body;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractBodyChanged} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BlogEvent.AbstractBodyChanged instance) {
      Objects.requireNonNull(instance, "instance");
      body(instance.getBody());
      return this;
    }

    /**
     * Initializes the value for the {@link BlogEvent.AbstractBodyChanged#getBody() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Builds a new {@link BodyChanged BodyChanged}.
     * @return An immutable instance of BodyChanged
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BodyChanged build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new BodyChanged(null, body);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      return "Cannot build BodyChanged, some of required attributes are not set " + attributes;
    }
  }
}
