package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CustomBuilderDeserialize}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableCustomBuilderDeserialize.Builder()}.
 */
@Generated(from = "CustomBuilderDeserialize", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCustomBuilderDeserialize
    extends CustomBuilderDeserialize {
  private final @Nullable Object value;
  private final int a;
  private final @Nullable String s;
  private final ImmutableList<Boolean> l;

  private ImmutableCustomBuilderDeserialize(
      @Nullable Object value,
      int a,
      @Nullable String s,
      ImmutableList<Boolean> l) {
    this.value = value;
    this.a = a;
    this.s = s;
    this.l = l;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @JsonTypeInfo(use = JsonTypeInfo.Id.NAME)
  @JsonSubTypes({@JsonSubTypes.Type(name = "I", value = Integer.class), @JsonSubTypes.Type(name = "O", value = Double.class)})
  @Override
  public @Nullable Object value() {
    return value;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @JsonProperty("a")
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @JsonProperty("s")
  @Override
  public @Nullable String s() {
    return s;
  }

  /**
   * @return The value of the {@code l} attribute
   */
  @JsonProperty("l")
  @Override
  public ImmutableList<Boolean> l() {
    return l;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CustomBuilderDeserialize#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomBuilderDeserialize withValue(@Nullable Object value) {
    if (this.value == value) return this;
    return new ImmutableCustomBuilderDeserialize(value, this.a, this.s, this.l);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CustomBuilderDeserialize#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomBuilderDeserialize withA(int value) {
    if (this.a == value) return this;
    return new ImmutableCustomBuilderDeserialize(this.value, value, this.s, this.l);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CustomBuilderDeserialize#s() s} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomBuilderDeserialize withS(@Nullable String value) {
    if (Objects.equals(this.s, value)) return this;
    return new ImmutableCustomBuilderDeserialize(this.value, this.a, value, this.l);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomBuilderDeserialize#l() l}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomBuilderDeserialize withL(boolean... elements) {
    ImmutableList<Boolean> newValue = ImmutableList.copyOf(Booleans.asList(elements));
    return new ImmutableCustomBuilderDeserialize(this.value, this.a, this.s, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CustomBuilderDeserialize#l() l}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of l elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomBuilderDeserialize withL(Iterable<Boolean> elements) {
    if (this.l == elements) return this;
    ImmutableList<Boolean> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCustomBuilderDeserialize(this.value, this.a, this.s, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCustomBuilderDeserialize} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCustomBuilderDeserialize
        && equalTo(0, (ImmutableCustomBuilderDeserialize) another);
  }

  private boolean equalTo(int synthetic, ImmutableCustomBuilderDeserialize another) {
    return Objects.equals(value, another.value)
        && a == another.a
        && Objects.equals(s, another.s)
        && l.equals(another.l);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code a}, {@code s}, {@code l}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + a;
    h += (h << 5) + Objects.hashCode(s);
    h += (h << 5) + l.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CustomBuilderDeserialize} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CustomBuilderDeserialize")
        .omitNullValues()
        .add("value", value)
        .add("a", a)
        .add("s", s)
        .add("l", l)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CustomBuilderDeserialize} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomBuilderDeserialize instance
   */
  public static ImmutableCustomBuilderDeserialize copyOf(CustomBuilderDeserialize instance) {
    if (instance instanceof ImmutableCustomBuilderDeserialize) {
      return (ImmutableCustomBuilderDeserialize) instance;
    }
    return new ImmutableCustomBuilderDeserialize.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCustomBuilderDeserialize ImmutableCustomBuilderDeserialize}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CustomBuilderDeserialize", generator = "Immutables")
  @NotThreadSafe
  @JsonIgnoreProperties(ignoreUnknown = true)
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Object value;
    private int a;
    private @Nullable String s;
    private ImmutableList.Builder<Boolean> l = ImmutableList.builder();

    /**
     * Creates a builder for {@link ImmutableCustomBuilderDeserialize ImmutableCustomBuilderDeserialize} instances.
     * <pre>
     * new ImmutableCustomBuilderDeserialize.Builder()
     *    .value(Object | null) // nullable {@link CustomBuilderDeserialize#value() value}
     *    .a(int) // required {@link CustomBuilderDeserialize#a() a}
     *    .s(String | null) // nullable {@link CustomBuilderDeserialize#s() s}
     *    .addL|addAllL(boolean) // {@link CustomBuilderDeserialize#l() l} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomBuilderDeserialize} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CustomBuilderDeserialize instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      a(instance.a());
      @Nullable String sValue = instance.s();
      if (sValue != null) {
        s(sValue);
      }
      addAllL(instance.l());
      return this;
    }

    /**
     * Initializes the value for the {@link CustomBuilderDeserialize#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({@JsonSubTypes.Type(name = "I", value = Integer.class), @JsonSubTypes.Type(name = "O", value = Double.class)})
    public final Builder value(@Nullable Object value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the value for the {@link CustomBuilderDeserialize#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("a")
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link CustomBuilderDeserialize#s() s} attribute.
     * @param s The value for s (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("s")
    public final Builder s(@Nullable String s) {
      this.s = s;
      return this;
    }

    /**
     * Adds one element to {@link CustomBuilderDeserialize#l() l} list.
     * @param element A l element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addL(boolean element) {
      this.l.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CustomBuilderDeserialize#l() l} list.
     * @param elements An array of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addL(boolean... elements) {
      this.l.addAll(Booleans.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CustomBuilderDeserialize#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("l")
    public final Builder l(Iterable<Boolean> elements) {
      this.l = ImmutableList.builder();
      return addAllL(elements);
    }

    /**
     * Adds elements to {@link CustomBuilderDeserialize#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllL(Iterable<Boolean> elements) {
      this.l.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCustomBuilderDeserialize ImmutableCustomBuilderDeserialize}.
     * @return An immutable instance of CustomBuilderDeserialize
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomBuilderDeserialize build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCustomBuilderDeserialize(value, a, s, l.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build CustomBuilderDeserialize, some of required attributes are not set " + attributes;
    }
  }
}
