package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultCollection.builder()}.
 */
@Generated(from = "DefaultCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDefaultCollection implements DefaultCollection {
  private final @Nullable ImmutableList<String> nullable;
  private final ImmutableList<String> defaults;
  private final @Nullable ImmutableList<Integer> defnullable;

  private ImmutableDefaultCollection(ImmutableDefaultCollection.Builder builder) {
    this.nullable = builder.nullable == null ? null : builder.nullable.build();
    if (builder.defaultsIsSet()) {
      initShim.defaults(builder.defaults.build());
    }
    if (builder.defnullableIsSet()) {
      initShim.defnullable(builder.defnullable == null ? null : builder.defnullable.build());
    }
    this.defaults = initShim.defaults();
    this.defnullable = initShim.defnullable();
    this.initShim = null;
  }

  private ImmutableDefaultCollection(
      @Nullable ImmutableList<String> nullable,
      ImmutableList<String> defaults,
      @Nullable ImmutableList<Integer> defnullable) {
    this.nullable = nullable;
    this.defaults = defaults;
    this.defnullable = defnullable;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DefaultCollection", generator = "Immutables")
  private final class InitShim {
    private byte defaultsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<String> defaults;

    ImmutableList<String> defaults() {
      if (defaultsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultsBuildStage == STAGE_UNINITIALIZED) {
        defaultsBuildStage = STAGE_INITIALIZING;
        this.defaults = ImmutableList.copyOf(defaultsInitialize());
        defaultsBuildStage = STAGE_INITIALIZED;
      }
      return this.defaults;
    }

    void defaults(ImmutableList<String> defaults) {
      this.defaults = defaults;
      defaultsBuildStage = STAGE_INITIALIZED;
    }

    private byte defnullableBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<Integer> defnullable;

    ImmutableList<Integer> defnullable() {
      if (defnullableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defnullableBuildStage == STAGE_UNINITIALIZED) {
        defnullableBuildStage = STAGE_INITIALIZING;
        this.defnullable = defnullableInitialize() == null ? null : ImmutableList.copyOf(defnullableInitialize());
        defnullableBuildStage = STAGE_INITIALIZED;
      }
      return this.defnullable;
    }

    void defnullable(ImmutableList<Integer> defnullable) {
      this.defnullable = defnullable;
      defnullableBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (defaultsBuildStage == STAGE_INITIALIZING) attributes.add("defaults");
      if (defnullableBuildStage == STAGE_INITIALIZING) attributes.add("defnullable");
      return "Cannot build DefaultCollection, attribute initializers form cycle " + attributes;
    }
  }

  private List<String> defaultsInitialize() {
    return DefaultCollection.super.defaults();
  }

  private @Nullable List<Integer> defnullableInitialize() {
    return DefaultCollection.super.defnullable();
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("nullable")
  @Override
  public @Nullable ImmutableList<String> nullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code defaults} attribute
   */
  @JsonProperty("defaults")
  @Override
  public ImmutableList<String> defaults() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defaults()
        : this.defaults;
  }

  /**
   * @return The value of the {@code defnullable} attribute
   */
  @JsonProperty("defnullable")
  @Override
  public @Nullable ImmutableList<Integer> defnullable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defnullable()
        : this.defnullable;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultCollection#nullable() nullable}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultCollection withNullable(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableDefaultCollection(null, this.defaults, this.defnullable);
    }
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableDefaultCollection(newValue, this.defaults, this.defnullable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultCollection#nullable() nullable}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nullable elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultCollection withNullable(@Nullable Iterable<String> elements) {
    if (this.nullable == elements) return this;
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableDefaultCollection(newValue, this.defaults, this.defnullable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultCollection#defaults() defaults}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultCollection withDefaults(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDefaultCollection(this.nullable, newValue, this.defnullable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultCollection#defaults() defaults}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of defaults elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultCollection withDefaults(Iterable<String> elements) {
    if (this.defaults == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableDefaultCollection(this.nullable, newValue, this.defnullable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultCollection#defnullable() defnullable}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultCollection withDefnullable(@Nullable int... elements) {
    if (elements == null) {
      return new ImmutableDefaultCollection(this.nullable, this.defaults, null);
    }
    @Nullable ImmutableList<Integer> newValue = Ints.asList(elements) == null ? null : ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableDefaultCollection(this.nullable, this.defaults, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultCollection#defnullable() defnullable}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of defnullable elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultCollection withDefnullable(@Nullable Iterable<Integer> elements) {
    if (this.defnullable == elements) return this;
    @Nullable ImmutableList<Integer> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableDefaultCollection(this.nullable, this.defaults, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultCollection
        && equalTo(0, (ImmutableDefaultCollection) another);
  }

  private boolean equalTo(int synthetic, ImmutableDefaultCollection another) {
    return Objects.equals(nullable, another.nullable)
        && defaults.equals(another.defaults)
        && Objects.equals(defnullable, another.defnullable);
  }

  /**
   * Computes a hash code from attributes: {@code nullable}, {@code defaults}, {@code defnullable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(nullable);
    h += (h << 5) + defaults.hashCode();
    h += (h << 5) + Objects.hashCode(defnullable);
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DefaultCollection")
        .omitNullValues()
        .add("nullable", nullable)
        .add("defaults", defaults)
        .add("defnullable", defnullable)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DefaultCollection", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DefaultCollection {
    @Nullable List<String> nullable = null;
    @Nullable List<String> defaults = ImmutableList.of();
    boolean defaultsIsSet;
    @Nullable List<Integer> defnullable = null;
    boolean defnullableIsSet;
    @JsonProperty("nullable")
    public void setNullable(@Nullable List<String> nullable) {
      this.nullable = nullable;
    }
    @JsonProperty("defaults")
    public void setDefaults(List<String> defaults) {
      this.defaults = defaults;
      this.defaultsIsSet = null != defaults;
    }
    @JsonProperty("defnullable")
    public void setDefnullable(@Nullable List<Integer> defnullable) {
      this.defnullable = defnullable;
      this.defnullableIsSet = true;
    }
    @Override
    public List<String> nullable() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> defaults() { throw new UnsupportedOperationException(); }
    @Override
    public List<Integer> defnullable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDefaultCollection fromJson(Json json) {
    ImmutableDefaultCollection.Builder builder = ImmutableDefaultCollection.builder();
    if (json.nullable != null) {
      builder.addAllNullable(json.nullable);
    }
    if (json.defaultsIsSet) {
      builder.addAllDefaults(json.defaults);
    }
    if (json.defnullableIsSet) {
      builder.addAllDefnullable(json.defnullable);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DefaultCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultCollection instance
   */
  public static ImmutableDefaultCollection copyOf(DefaultCollection instance) {
    if (instance instanceof ImmutableDefaultCollection) {
      return (ImmutableDefaultCollection) instance;
    }
    return ImmutableDefaultCollection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultCollection ImmutableDefaultCollection}.
   * <pre>
   * ImmutableDefaultCollection.builder()
   *    .nullable(List&amp;lt;String&amp;gt; | null) // nullable {@link DefaultCollection#nullable() nullable}
   *    .addDefaults|addAllDefaults(String) // {@link DefaultCollection#defaults() defaults} elements
   *    .defnullable(List&amp;lt;Integer&amp;gt; | null) // nullable {@link DefaultCollection#defnullable() defnullable}
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultCollection builder
   */
  public static ImmutableDefaultCollection.Builder builder() {
    return new ImmutableDefaultCollection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultCollection ImmutableDefaultCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultCollection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_DEFAULTS = 0x1L;
    private static final long OPT_BIT_DEFNULLABLE = 0x2L;
    private long optBits;

    private ImmutableList.Builder<String> nullable = null;
    private ImmutableList.Builder<String> defaults = ImmutableList.builder();
    private ImmutableList.Builder<Integer> defnullable = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultCollection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultCollection instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<String> nullableValue = instance.nullable();
      if (nullableValue != null) {
        addAllNullable(nullableValue);
      }
      addAllDefaults(instance.defaults());
      @Nullable List<Integer> defnullableValue = instance.defnullable();
      if (defnullableValue != null) {
        addAllDefnullable(defnullableValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link DefaultCollection#nullable() nullable} list.
     * @param element A nullable element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNullable(String element) {
      if (this.nullable == null) {
        this.nullable = ImmutableList.builder();
      }
      this.nullable.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DefaultCollection#nullable() nullable} list.
     * @param elements An array of nullable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNullable(String... elements) {
      if (this.nullable == null) {
        this.nullable = ImmutableList.builder();
      }
      this.nullable.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultCollection#nullable() nullable} list.
     * @param elements An iterable of nullable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("nullable")
    public final Builder nullable(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.nullable = null;
        return this;
      }
      this.nullable = ImmutableList.builder();
      return addAllNullable(elements);
    }

    /**
     * Adds elements to {@link DefaultCollection#nullable() nullable} list.
     * @param elements An iterable of nullable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNullable(Iterable<String> elements) {
      Objects.requireNonNull(elements, "nullable element");
      if (this.nullable == null) {
        this.nullable = ImmutableList.builder();
      }
      this.nullable.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link DefaultCollection#defaults() defaults} list.
     * @param element A defaults element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDefaults(String element) {
      this.defaults.add(element);
      optBits |= OPT_BIT_DEFAULTS;
      return this;
    }

    /**
     * Adds elements to {@link DefaultCollection#defaults() defaults} list.
     * @param elements An array of defaults elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDefaults(String... elements) {
      this.defaults.add(elements);
      optBits |= OPT_BIT_DEFAULTS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultCollection#defaults() defaults} list.
     * @param elements An iterable of defaults elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defaults")
    public final Builder defaults(Iterable<String> elements) {
      this.defaults = ImmutableList.builder();
      return addAllDefaults(elements);
    }

    /**
     * Adds elements to {@link DefaultCollection#defaults() defaults} list.
     * @param elements An iterable of defaults elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDefaults(Iterable<String> elements) {
      this.defaults.addAll(elements);
      optBits |= OPT_BIT_DEFAULTS;
      return this;
    }

    /**
     * Adds one element to {@link DefaultCollection#defnullable() defnullable} list.
     * @param element A defnullable element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDefnullable(int element) {
      if (this.defnullable == null) {
        this.defnullable = ImmutableList.builder();
      }
      this.defnullable.add(element);
      optBits |= OPT_BIT_DEFNULLABLE;
      return this;
    }

    /**
     * Adds elements to {@link DefaultCollection#defnullable() defnullable} list.
     * @param elements An array of defnullable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDefnullable(int... elements) {
      if (this.defnullable == null) {
        this.defnullable = ImmutableList.builder();
      }
      this.defnullable.addAll(Ints.asList(elements));
      optBits |= OPT_BIT_DEFNULLABLE;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultCollection#defnullable() defnullable} list.
     * @param elements An iterable of defnullable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defnullable")
    public final Builder defnullable(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.defnullable = null;
        optBits |= OPT_BIT_DEFNULLABLE;
        return this;
      }
      this.defnullable = ImmutableList.builder();
      return addAllDefnullable(elements);
    }

    /**
     * Adds elements to {@link DefaultCollection#defnullable() defnullable} list.
     * @param elements An iterable of defnullable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDefnullable(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "defnullable element");
      if (this.defnullable == null) {
        this.defnullable = ImmutableList.builder();
      }
      this.defnullable.addAll(elements);
      optBits |= OPT_BIT_DEFNULLABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultCollection ImmutableDefaultCollection}.
     * @return An immutable instance of DefaultCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultCollection build() {
      return new ImmutableDefaultCollection(this);
    }

    private boolean defaultsIsSet() {
      return (optBits & OPT_BIT_DEFAULTS) != 0;
    }

    private boolean defnullableIsSet() {
      return (optBits & OPT_BIT_DEFNULLABLE) != 0;
    }
  }
}
