package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Foo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFoo.builder()}.
 */
@Generated(from = "Foo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFoo extends Foo {
  private final boolean isBar;

  private ImmutableFoo(boolean isBar) {
    this.isBar = isBar;
  }

  /**
   * @return The value of the {@code isBar} attribute
   */
  @JsonProperty("bar")
  @Override
  public boolean isBar() {
    return isBar;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Foo#isBar() isBar} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isBar
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoo withIsBar(boolean value) {
    if (this.isBar == value) return this;
    return new ImmutableFoo(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFoo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFoo
        && equalTo(0, (ImmutableFoo) another);
  }

  private boolean equalTo(int synthetic, ImmutableFoo another) {
    return isBar == another.isBar;
  }

  /**
   * Computes a hash code from attributes: {@code isBar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(isBar);
    return h;
  }

  /**
   * Prints the immutable value {@code Foo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Foo")
        .omitNullValues()
        .add("isBar", isBar)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Foo", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Foo {
    boolean isBar;
    boolean isBarIsSet;
    @JsonProperty("bar")
    public void setIsBar(boolean isBar) {
      this.isBar = isBar;
      this.isBarIsSet = true;
    }
    @Override
    public boolean isBar() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFoo fromJson(Json json) {
    ImmutableFoo.Builder builder = ImmutableFoo.builder();
    if (json.isBarIsSet) {
      builder.isBar(json.isBar);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Foo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Foo instance
   */
  public static ImmutableFoo copyOf(Foo instance) {
    if (instance instanceof ImmutableFoo) {
      return (ImmutableFoo) instance;
    }
    return ImmutableFoo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFoo ImmutableFoo}.
   * <pre>
   * ImmutableFoo.builder()
   *    .isBar(boolean) // required {@link Foo#isBar() isBar}
   *    .build();
   * </pre>
   * @return A new ImmutableFoo builder
   */
  public static ImmutableFoo.Builder builder() {
    return new ImmutableFoo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFoo ImmutableFoo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Foo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IS_BAR = 0x1L;
    private long initBits = 0x1L;

    private boolean isBar;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Foo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Foo instance) {
      Objects.requireNonNull(instance, "instance");
      isBar(instance.isBar());
      return this;
    }

    /**
     * Initializes the value for the {@link Foo#isBar() isBar} attribute.
     * @param isBar The value for isBar 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bar")
    public final Builder isBar(boolean isBar) {
      this.isBar = isBar;
      initBits &= ~INIT_BIT_IS_BAR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFoo ImmutableFoo}.
     * @return An immutable instance of Foo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFoo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFoo(isBar);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IS_BAR) != 0) attributes.add("isBar");
      return "Cannot build Foo, some of required attributes are not set " + attributes;
    }
  }
}
