package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HashCodeAbstract}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHashCodeAbstract.builder()}.
 */
@Generated(from = "HashCodeAbstract", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHashCodeAbstract extends HashCodeAbstract {
  private final int someAttributeHaveToBeDefined;

  private ImmutableHashCodeAbstract(int someAttributeHaveToBeDefined) {
    this.someAttributeHaveToBeDefined = someAttributeHaveToBeDefined;
  }

  /**
   * @return The value of the {@code someAttributeHaveToBeDefined} attribute
   */
  @JsonProperty("someAttributeHaveToBeDefined")
  @Override
  public int someAttributeHaveToBeDefined() {
    return someAttributeHaveToBeDefined;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HashCodeAbstract#someAttributeHaveToBeDefined() someAttributeHaveToBeDefined} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for someAttributeHaveToBeDefined
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHashCodeAbstract withSomeAttributeHaveToBeDefined(int value) {
    if (this.someAttributeHaveToBeDefined == value) return this;
    return new ImmutableHashCodeAbstract(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHashCodeAbstract} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHashCodeAbstract
        && equalTo(0, (ImmutableHashCodeAbstract) another);
  }

  private boolean equalTo(int synthetic, ImmutableHashCodeAbstract another) {
    return someAttributeHaveToBeDefined == another.someAttributeHaveToBeDefined;
  }

  /**
   * Computes a hash code from attributes: {@code someAttributeHaveToBeDefined}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + someAttributeHaveToBeDefined;
    return h;
  }

  /**
   * Prints the immutable value {@code HashCodeAbstract} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HashCodeAbstract")
        .omitNullValues()
        .add("someAttributeHaveToBeDefined", someAttributeHaveToBeDefined)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "HashCodeAbstract", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends HashCodeAbstract {
    int someAttributeHaveToBeDefined;
    boolean someAttributeHaveToBeDefinedIsSet;
    @JsonProperty("someAttributeHaveToBeDefined")
    public void setSomeAttributeHaveToBeDefined(int someAttributeHaveToBeDefined) {
      this.someAttributeHaveToBeDefined = someAttributeHaveToBeDefined;
      this.someAttributeHaveToBeDefinedIsSet = true;
    }
    @Override
    public int hashCode() { throw new UnsupportedOperationException(); }
    @Override
    public boolean equals(Object obj) { throw new UnsupportedOperationException(); }
    @Override
    public int someAttributeHaveToBeDefined() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHashCodeAbstract fromJson(Json json) {
    ImmutableHashCodeAbstract.Builder builder = ImmutableHashCodeAbstract.builder();
    if (json.someAttributeHaveToBeDefinedIsSet) {
      builder.someAttributeHaveToBeDefined(json.someAttributeHaveToBeDefined);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link HashCodeAbstract} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HashCodeAbstract instance
   */
  public static ImmutableHashCodeAbstract copyOf(HashCodeAbstract instance) {
    if (instance instanceof ImmutableHashCodeAbstract) {
      return (ImmutableHashCodeAbstract) instance;
    }
    return ImmutableHashCodeAbstract.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHashCodeAbstract ImmutableHashCodeAbstract}.
   * <pre>
   * ImmutableHashCodeAbstract.builder()
   *    .someAttributeHaveToBeDefined(int) // required {@link HashCodeAbstract#someAttributeHaveToBeDefined() someAttributeHaveToBeDefined}
   *    .build();
   * </pre>
   * @return A new ImmutableHashCodeAbstract builder
   */
  public static ImmutableHashCodeAbstract.Builder builder() {
    return new ImmutableHashCodeAbstract.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHashCodeAbstract ImmutableHashCodeAbstract}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HashCodeAbstract", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOME_ATTRIBUTE_HAVE_TO_BE_DEFINED = 0x1L;
    private long initBits = 0x1L;

    private int someAttributeHaveToBeDefined;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HashCodeAbstract} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HashCodeAbstract instance) {
      Objects.requireNonNull(instance, "instance");
      someAttributeHaveToBeDefined(instance.someAttributeHaveToBeDefined());
      return this;
    }

    /**
     * Initializes the value for the {@link HashCodeAbstract#someAttributeHaveToBeDefined() someAttributeHaveToBeDefined} attribute.
     * @param someAttributeHaveToBeDefined The value for someAttributeHaveToBeDefined 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("someAttributeHaveToBeDefined")
    public final Builder someAttributeHaveToBeDefined(int someAttributeHaveToBeDefined) {
      this.someAttributeHaveToBeDefined = someAttributeHaveToBeDefined;
      initBits &= ~INIT_BIT_SOME_ATTRIBUTE_HAVE_TO_BE_DEFINED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHashCodeAbstract ImmutableHashCodeAbstract}.
     * @return An immutable instance of HashCodeAbstract
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHashCodeAbstract build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHashCodeAbstract(someAttributeHaveToBeDefined);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOME_ATTRIBUTE_HAVE_TO_BE_DEFINED) != 0) attributes.add("someAttributeHaveToBeDefined");
      return "Cannot build HashCodeAbstract, some of required attributes are not set " + attributes;
    }
  }
}
