package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.AdditionalJacksonAnnotation;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JacksonMappedWithExtraAnnotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJacksonMappedWithExtraAnnotation.builder()}.
 */
@Generated(from = "JacksonMappedWithExtraAnnotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJacksonMappedWithExtraAnnotation
    implements JacksonMappedWithExtraAnnotation {
  private final Long someLong;

  private ImmutableJacksonMappedWithExtraAnnotation(Long someLong) {
    this.someLong = someLong;
  }

  /**
   * @return The value of the {@code someLong} attribute
   */
  @AdditionalJacksonAnnotation("some_long")
  @JsonProperty("some_long_string")
  @JsonSerialize(using = ToStringSerializer.class)
  @Override
  public Long getSomeLong() {
    return someLong;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JacksonMappedWithExtraAnnotation#getSomeLong() someLong} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for someLong
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJacksonMappedWithExtraAnnotation withSomeLong(Long value) {
    Long newValue = Objects.requireNonNull(value, "someLong");
    if (this.someLong.equals(newValue)) return this;
    return new ImmutableJacksonMappedWithExtraAnnotation(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJacksonMappedWithExtraAnnotation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJacksonMappedWithExtraAnnotation
        && equalTo(0, (ImmutableJacksonMappedWithExtraAnnotation) another);
  }

  private boolean equalTo(int synthetic, ImmutableJacksonMappedWithExtraAnnotation another) {
    return someLong.equals(another.someLong);
  }

  /**
   * Computes a hash code from attributes: {@code someLong}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + someLong.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JacksonMappedWithExtraAnnotation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JacksonMappedWithExtraAnnotation")
        .omitNullValues()
        .add("someLong", someLong)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JacksonMappedWithExtraAnnotation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JacksonMappedWithExtraAnnotation {
    @Nullable Long someLong;
    @AdditionalJacksonAnnotation("some_long")
    @JsonProperty("some_long_string")
    @JsonSerialize(using = ToStringSerializer.class)
    public void setSomeLong(Long someLong) {
      this.someLong = someLong;
    }
    @Override
    public Long getSomeLong() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJacksonMappedWithExtraAnnotation fromJson(Json json) {
    ImmutableJacksonMappedWithExtraAnnotation.Builder builder = ImmutableJacksonMappedWithExtraAnnotation.builder();
    if (json.someLong != null) {
      builder.someLong(json.someLong);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JacksonMappedWithExtraAnnotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JacksonMappedWithExtraAnnotation instance
   */
  public static ImmutableJacksonMappedWithExtraAnnotation copyOf(JacksonMappedWithExtraAnnotation instance) {
    if (instance instanceof ImmutableJacksonMappedWithExtraAnnotation) {
      return (ImmutableJacksonMappedWithExtraAnnotation) instance;
    }
    return ImmutableJacksonMappedWithExtraAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJacksonMappedWithExtraAnnotation ImmutableJacksonMappedWithExtraAnnotation}.
   * <pre>
   * ImmutableJacksonMappedWithExtraAnnotation.builder()
   *    .someLong(Long) // required {@link JacksonMappedWithExtraAnnotation#getSomeLong() someLong}
   *    .build();
   * </pre>
   * @return A new ImmutableJacksonMappedWithExtraAnnotation builder
   */
  public static ImmutableJacksonMappedWithExtraAnnotation.Builder builder() {
    return new ImmutableJacksonMappedWithExtraAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJacksonMappedWithExtraAnnotation ImmutableJacksonMappedWithExtraAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JacksonMappedWithExtraAnnotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOME_LONG = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Long someLong;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JacksonMappedWithExtraAnnotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JacksonMappedWithExtraAnnotation instance) {
      Objects.requireNonNull(instance, "instance");
      someLong(instance.getSomeLong());
      return this;
    }

    /**
     * Initializes the value for the {@link JacksonMappedWithExtraAnnotation#getSomeLong() someLong} attribute.
     * @param someLong The value for someLong 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("some_long_string")
    @JsonSerialize(using = ToStringSerializer.class)
    public final Builder someLong(Long someLong) {
      this.someLong = Objects.requireNonNull(someLong, "someLong");
      initBits &= ~INIT_BIT_SOME_LONG;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJacksonMappedWithExtraAnnotation ImmutableJacksonMappedWithExtraAnnotation}.
     * @return An immutable instance of JacksonMappedWithExtraAnnotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJacksonMappedWithExtraAnnotation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJacksonMappedWithExtraAnnotation(someLong);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOME_LONG) != 0) attributes.add("someLong");
      return "Cannot build JacksonMappedWithExtraAnnotation, some of required attributes are not set " + attributes;
    }
  }
}
