package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JsonValueCreator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJsonValueCreator.builder()}.
 */
@Generated(from = "JsonValueCreator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJsonValueCreator implements JsonValueCreator {
  private final String value;

  private ImmutableJsonValueCreator(String value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @JsonValue
  @Override
  public String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JsonValueCreator#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJsonValueCreator withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableJsonValueCreator(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJsonValueCreator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJsonValueCreator
        && equalTo(0, (ImmutableJsonValueCreator) another);
  }

  private boolean equalTo(int synthetic, ImmutableJsonValueCreator another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JsonValueCreator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JsonValueCreator")
        .omitNullValues()
        .add("value", value)
        .toString();
  }

  /**
   * @param jsonValue to construct object from
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJsonValueCreator fromJson(String jsonValue) {
    ImmutableJsonValueCreator.Builder builder = ImmutableJsonValueCreator.builder();
    builder.value(jsonValue);
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JsonValueCreator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JsonValueCreator instance
   */
  public static ImmutableJsonValueCreator copyOf(JsonValueCreator instance) {
    if (instance instanceof ImmutableJsonValueCreator) {
      return (ImmutableJsonValueCreator) instance;
    }
    return ImmutableJsonValueCreator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJsonValueCreator ImmutableJsonValueCreator}.
   * <pre>
   * ImmutableJsonValueCreator.builder()
   *    .value(String) // required {@link JsonValueCreator#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableJsonValueCreator builder
   */
  public static ImmutableJsonValueCreator.Builder builder() {
    return new ImmutableJsonValueCreator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJsonValueCreator ImmutableJsonValueCreator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JsonValueCreator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JsonValueCreator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JsonValueCreator instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link JsonValueCreator#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJsonValueCreator ImmutableJsonValueCreator}.
     * @return An immutable instance of JsonValueCreator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJsonValueCreator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJsonValueCreator(value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build JsonValueCreator, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link JsonValueCreator.Singleton}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableJsonValueCreator.Singleton.of()}.
   */
  @Generated(from = "JsonValueCreator.Singleton", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Singleton implements JsonValueCreator.Singleton {
    private final double value;

    private Singleton() {
      this.value = JsonValueCreator.Singleton.super.value();
    }

    private Singleton(double value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("value")
    @JsonValue
    @Override
    public double value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link JsonValueCreator.Singleton#value() value} attribute.
     * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableJsonValueCreator.Singleton withValue(double value) {
      if (Double.doubleToLongBits(this.value) == Double.doubleToLongBits(value)) return this;
      return validate(new ImmutableJsonValueCreator.Singleton(value));
    }

    /**
     * This instance is equal to all instances of {@code Singleton} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableJsonValueCreator.Singleton
          && equalTo(0, (ImmutableJsonValueCreator.Singleton) another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonValueCreator.Singleton another) {
      return Double.doubleToLongBits(value) == Double.doubleToLongBits(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + Doubles.hashCode(value);
      return h;
    }

    /**
     * Prints the immutable value {@code Singleton} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Singleton")
          .omitNullValues()
          .add("value", value)
          .toString();
    }

    /**
     * @param jsonValue to construct object from
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableJsonValueCreator.Singleton fromJson(double jsonValue) {
      ImmutableJsonValueCreator.Singleton instance = ImmutableJsonValueCreator.Singleton.of();
      instance = instance.withValue(jsonValue);
      return instance;
    }

    private static final ImmutableJsonValueCreator.Singleton INSTANCE = validate(new ImmutableJsonValueCreator.Singleton());

    /**
     * Returns the default immutable singleton value of {@code Singleton}
     * @return An immutable instance of Singleton
     */
    public static ImmutableJsonValueCreator.Singleton of() {
      return INSTANCE;
    }

    private static ImmutableJsonValueCreator.Singleton validate(ImmutableJsonValueCreator.Singleton instance) {
      return instance;
    }
  }

  /**
   * Immutable implementation of {@link JsonValueCreator.Constructor}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableJsonValueCreator.Constructor.of()}.
   */
  @Generated(from = "JsonValueCreator.Constructor", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Constructor implements JsonValueCreator.Constructor {
    private final boolean value;

    private Constructor(boolean value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("value")
    @JsonValue
    @Override
    public boolean value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link JsonValueCreator.Constructor#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableJsonValueCreator.Constructor withValue(boolean value) {
      if (this.value == value) return this;
      return new ImmutableJsonValueCreator.Constructor(value);
    }

    /**
     * This instance is equal to all instances of {@code Constructor} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableJsonValueCreator.Constructor
          && equalTo(0, (ImmutableJsonValueCreator.Constructor) another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonValueCreator.Constructor another) {
      return value == another.value;
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + Booleans.hashCode(value);
      return h;
    }

    /**
     * Prints the immutable value {@code Constructor} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Constructor")
          .omitNullValues()
          .add("value", value)
          .toString();
    }

    /**
     * @param jsonValue to construct object from
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableJsonValueCreator.Constructor fromJson(boolean jsonValue) {
      ImmutableJsonValueCreator.Constructor instance = ImmutableJsonValueCreator.Constructor.of(jsonValue);
      return instance;
    }

    /**
     * Construct a new immutable {@code Constructor} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable Constructor instance
     */
    public static ImmutableJsonValueCreator.Constructor of(boolean value) {
      return new ImmutableJsonValueCreator.Constructor(value);
    }

    /**
     * Creates an immutable copy of a {@link JsonValueCreator.Constructor} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Constructor instance
     */
    public static ImmutableJsonValueCreator.Constructor copyOf(JsonValueCreator.Constructor instance) {
      if (instance instanceof ImmutableJsonValueCreator.Constructor) {
        return (ImmutableJsonValueCreator.Constructor) instance;
      }
      return ImmutableJsonValueCreator.Constructor.of(instance.value());
    }
  }
}
