package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LazyAttributesSafe}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLazyAttributesSafe.builder()}.
 */
@Generated(from = "LazyAttributesSafe", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLazyAttributesSafe extends LazyAttributesSafe {
  private final int a;
  private transient final String derived;
  private final int defaults;

  private ImmutableLazyAttributesSafe(ImmutableLazyAttributesSafe.Builder builder) {
    this.a = builder.a;
    if (builder.defaultsIsSet()) {
      initShim.defaults(builder.defaults);
    }
    this.derived = initShim.getDerived();
    this.defaults = initShim.getDefaults();
    this.initShim = null;
  }

  private ImmutableLazyAttributesSafe(int a, int defaults) {
    this.a = a;
    initShim.defaults(defaults);
    this.derived = initShim.getDerived();
    this.defaults = initShim.getDefaults();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "LazyAttributesSafe", generator = "Immutables")
  private final class InitShim {
    private byte derivedBuildStage = STAGE_UNINITIALIZED;
    private String derived;

    String getDerived() {
      if (derivedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (derivedBuildStage == STAGE_UNINITIALIZED) {
        derivedBuildStage = STAGE_INITIALIZING;
        this.derived = Objects.requireNonNull(ImmutableLazyAttributesSafe.super.getDerived(), "derived");
        derivedBuildStage = STAGE_INITIALIZED;
      }
      return this.derived;
    }

    private byte defaultsBuildStage = STAGE_UNINITIALIZED;
    private int defaults;

    int getDefaults() {
      if (defaultsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultsBuildStage == STAGE_UNINITIALIZED) {
        defaultsBuildStage = STAGE_INITIALIZING;
        this.defaults = ImmutableLazyAttributesSafe.super.getDefaults();
        defaultsBuildStage = STAGE_INITIALIZED;
      }
      return this.defaults;
    }

    void defaults(int defaults) {
      this.defaults = defaults;
      defaultsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (derivedBuildStage == STAGE_INITIALIZING) attributes.add("derived");
      if (defaultsBuildStage == STAGE_INITIALIZING) attributes.add("defaults");
      return "Cannot build LazyAttributesSafe, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @JsonProperty("a")
  @Override
  public int getA() {
    return a;
  }

  /**
   * @return The computed-at-construction value of the {@code derived} attribute
   */
  @JsonProperty("derived")
  @Override
  public String getDerived() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDerived()
        : this.derived;
  }

  /**
   * @return The value of the {@code defaults} attribute
   */
  @JsonProperty("defaults")
  @Override
  public int getDefaults() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDefaults()
        : this.defaults;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LazyAttributesSafe#getA() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLazyAttributesSafe withA(int value) {
    if (this.a == value) return this;
    return new ImmutableLazyAttributesSafe(value, this.defaults);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LazyAttributesSafe#getDefaults() defaults} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaults
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLazyAttributesSafe withDefaults(int value) {
    if (this.defaults == value) return this;
    return new ImmutableLazyAttributesSafe(this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLazyAttributesSafe} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLazyAttributesSafe
        && equalTo(0, (ImmutableLazyAttributesSafe) another);
  }

  private boolean equalTo(int synthetic, ImmutableLazyAttributesSafe another) {
    return a == another.a
        && derived.equals(another.derived)
        && defaults == another.defaults;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code derived}, {@code defaults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + derived.hashCode();
    h += (h << 5) + defaults;
    return h;
  }

  /**
   * Prints the immutable value {@code LazyAttributesSafe} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LazyAttributesSafe")
        .omitNullValues()
        .add("a", a)
        .add("derived", derived)
        .add("defaults", defaults)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LazyAttributesSafe", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends LazyAttributesSafe {
    int a;
    boolean aIsSet;
    int defaults;
    boolean defaultsIsSet;
    @JsonProperty("a")
    public void setA(int a) {
      this.a = a;
      this.aIsSet = true;
    }
    @JsonProperty("defaults")
    public void setDefaults(int defaults) {
      this.defaults = defaults;
      this.defaultsIsSet = true;
    }
    @Override
    public int getA() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    public String getDerived() { throw new UnsupportedOperationException(); }
    @Override
    public int getDefaults() { throw new UnsupportedOperationException(); }
    @Override
    public String getLazy() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLazyAttributesSafe fromJson(Json json) {
    ImmutableLazyAttributesSafe.Builder builder = ImmutableLazyAttributesSafe.builder();
    if (json.aIsSet) {
      builder.a(json.a);
    }
    if (json.defaultsIsSet) {
      builder.defaults(json.defaults);
    }
    return builder.build();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long LAZY_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String lazy;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link LazyAttributesSafe#getLazy() lazy} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code lazy} attribute
   */
  @Override
  public String getLazy() {
    if ((lazyInitBitmap & LAZY_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & LAZY_LAZY_INIT_BIT) == 0) {
          this.lazy = Objects.requireNonNull(super.getLazy(), "lazy");
          lazyInitBitmap |= LAZY_LAZY_INIT_BIT;
        }
      }
    }
    return lazy;
  }

  /**
   * Creates an immutable copy of a {@link LazyAttributesSafe} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LazyAttributesSafe instance
   */
  public static ImmutableLazyAttributesSafe copyOf(LazyAttributesSafe instance) {
    if (instance instanceof ImmutableLazyAttributesSafe) {
      return (ImmutableLazyAttributesSafe) instance;
    }
    return ImmutableLazyAttributesSafe.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLazyAttributesSafe ImmutableLazyAttributesSafe}.
   * <pre>
   * ImmutableLazyAttributesSafe.builder()
   *    .a(int) // required {@link LazyAttributesSafe#getA() a}
   *    .defaults(int) // optional {@link LazyAttributesSafe#getDefaults() defaults}
   *    .build();
   * </pre>
   * @return A new ImmutableLazyAttributesSafe builder
   */
  public static ImmutableLazyAttributesSafe.Builder builder() {
    return new ImmutableLazyAttributesSafe.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLazyAttributesSafe ImmutableLazyAttributesSafe}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LazyAttributesSafe", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long OPT_BIT_DEFAULTS = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private int a;
    private int defaults;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LazyAttributesSafe} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LazyAttributesSafe instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.getA());
      defaults(instance.getDefaults());
      return this;
    }

    /**
     * Initializes the value for the {@link LazyAttributesSafe#getA() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("a")
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link LazyAttributesSafe#getDefaults() defaults} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LazyAttributesSafe#getDefaults() defaults}.</em>
     * @param defaults The value for defaults 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defaults")
    public final Builder defaults(int defaults) {
      this.defaults = defaults;
      optBits |= OPT_BIT_DEFAULTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLazyAttributesSafe ImmutableLazyAttributesSafe}.
     * @return An immutable instance of LazyAttributesSafe
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLazyAttributesSafe build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLazyAttributesSafe(this);
    }

    private boolean defaultsIsSet() {
      return (optBits & OPT_BIT_DEFAULTS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build LazyAttributesSafe, some of required attributes are not set " + attributes;
    }
  }
}
