package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NamingStrategy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNamingStrategy.builder()}.
 */
@Generated(from = "NamingStrategy", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNamingStrategy implements NamingStrategy {
  private final int abraCadabra;
  private final boolean focusPocus;

  private ImmutableNamingStrategy(int abraCadabra, boolean focusPocus) {
    this.abraCadabra = abraCadabra;
    this.focusPocus = focusPocus;
  }

  /**
   * @return The value of the {@code abraCadabra} attribute
   */
  @JsonProperty
  @Override
  public int abraCadabra() {
    return abraCadabra;
  }

  /**
   * @return The value of the {@code focusPocus} attribute
   */
  @JsonProperty
  @Override
  public boolean focusPocus() {
    return focusPocus;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamingStrategy#abraCadabra() abraCadabra} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for abraCadabra
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamingStrategy withAbraCadabra(int value) {
    if (this.abraCadabra == value) return this;
    return new ImmutableNamingStrategy(value, this.focusPocus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamingStrategy#focusPocus() focusPocus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for focusPocus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamingStrategy withFocusPocus(boolean value) {
    if (this.focusPocus == value) return this;
    return new ImmutableNamingStrategy(this.abraCadabra, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNamingStrategy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNamingStrategy
        && equalTo(0, (ImmutableNamingStrategy) another);
  }

  private boolean equalTo(int synthetic, ImmutableNamingStrategy another) {
    return abraCadabra == another.abraCadabra
        && focusPocus == another.focusPocus;
  }

  /**
   * Computes a hash code from attributes: {@code abraCadabra}, {@code focusPocus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + abraCadabra;
    h += (h << 5) + Booleans.hashCode(focusPocus);
    return h;
  }

  /**
   * Prints the immutable value {@code NamingStrategy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NamingStrategy")
        .omitNullValues()
        .add("abraCadabra", abraCadabra)
        .add("focusPocus", focusPocus)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NamingStrategy", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements NamingStrategy {
    int abraCadabra;
    boolean abraCadabraIsSet;
    boolean focusPocus;
    boolean focusPocusIsSet;
    @JsonProperty
    public void setAbraCadabra(int abraCadabra) {
      this.abraCadabra = abraCadabra;
      this.abraCadabraIsSet = true;
    }
    @JsonProperty
    public void setFocusPocus(boolean focusPocus) {
      this.focusPocus = focusPocus;
      this.focusPocusIsSet = true;
    }
    @Override
    public int abraCadabra() { throw new UnsupportedOperationException(); }
    @Override
    public boolean focusPocus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNamingStrategy fromJson(Json json) {
    ImmutableNamingStrategy.Builder builder = ImmutableNamingStrategy.builder();
    if (json.abraCadabraIsSet) {
      builder.abraCadabra(json.abraCadabra);
    }
    if (json.focusPocusIsSet) {
      builder.focusPocus(json.focusPocus);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link NamingStrategy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NamingStrategy instance
   */
  public static ImmutableNamingStrategy copyOf(NamingStrategy instance) {
    if (instance instanceof ImmutableNamingStrategy) {
      return (ImmutableNamingStrategy) instance;
    }
    return ImmutableNamingStrategy.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNamingStrategy ImmutableNamingStrategy}.
   * <pre>
   * ImmutableNamingStrategy.builder()
   *    .abraCadabra(int) // required {@link NamingStrategy#abraCadabra() abraCadabra}
   *    .focusPocus(boolean) // required {@link NamingStrategy#focusPocus() focusPocus}
   *    .build();
   * </pre>
   * @return A new ImmutableNamingStrategy builder
   */
  public static ImmutableNamingStrategy.Builder builder() {
    return new ImmutableNamingStrategy.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNamingStrategy ImmutableNamingStrategy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NamingStrategy", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ABRA_CADABRA = 0x1L;
    private static final long INIT_BIT_FOCUS_POCUS = 0x2L;
    private long initBits = 0x3L;

    private int abraCadabra;
    private boolean focusPocus;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NamingStrategy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NamingStrategy instance) {
      Objects.requireNonNull(instance, "instance");
      abraCadabra(instance.abraCadabra());
      focusPocus(instance.focusPocus());
      return this;
    }

    /**
     * Initializes the value for the {@link NamingStrategy#abraCadabra() abraCadabra} attribute.
     * @param abraCadabra The value for abraCadabra 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder abraCadabra(int abraCadabra) {
      this.abraCadabra = abraCadabra;
      initBits &= ~INIT_BIT_ABRA_CADABRA;
      return this;
    }

    /**
     * Initializes the value for the {@link NamingStrategy#focusPocus() focusPocus} attribute.
     * @param focusPocus The value for focusPocus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder focusPocus(boolean focusPocus) {
      this.focusPocus = focusPocus;
      initBits &= ~INIT_BIT_FOCUS_POCUS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNamingStrategy ImmutableNamingStrategy}.
     * @return An immutable instance of NamingStrategy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNamingStrategy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNamingStrategy(abraCadabra, focusPocus);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ABRA_CADABRA) != 0) attributes.add("abraCadabra");
      if ((initBits & INIT_BIT_FOCUS_POCUS) != 0) attributes.add("focusPocus");
      return "Cannot build NamingStrategy, some of required attributes are not set " + attributes;
    }
  }
}
