package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Var;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoBuilderDeserialize}.
 * <p>
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableNoBuilderDeserialize.instance()}.
 */
@Generated(from = "NoBuilderDeserialize", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNoBuilderDeserialize extends NoBuilderDeserialize {
  private final ImmutableList<String> prop;

  private ImmutableNoBuilderDeserialize() {
    this.prop = ImmutableList.of();
  }

  private ImmutableNoBuilderDeserialize(ImmutableList<String> prop) {
    this.prop = prop;
  }

  /**
   * @return The value of the {@code prop} attribute
   */
  @JsonProperty("prop")
  @Override
  public ImmutableList<String> prop() {
    return prop;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoBuilderDeserialize#prop() prop}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoBuilderDeserialize withProp(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableNoBuilderDeserialize(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoBuilderDeserialize#prop() prop}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of prop elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoBuilderDeserialize withProp(Iterable<String> elements) {
    if (this.prop == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableNoBuilderDeserialize(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNoBuilderDeserialize} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNoBuilderDeserialize
        && equalTo(0, (ImmutableNoBuilderDeserialize) another);
  }

  private boolean equalTo(int synthetic, ImmutableNoBuilderDeserialize another) {
    return prop.equals(another.prop);
  }

  /**
   * Computes a hash code from attributes: {@code prop}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + prop.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NoBuilderDeserialize} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NoBuilderDeserialize")
        .omitNullValues()
        .add("prop", prop)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NoBuilderDeserialize", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends NoBuilderDeserialize {
    @Nullable List<String> prop = ImmutableList.of();
    @JsonProperty("prop")
    public void setProp(List<String> prop) {
      this.prop = prop;
    }
    @Override
    public List<String> prop() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNoBuilderDeserialize fromJson(Json json) {
    @Var ImmutableNoBuilderDeserialize instance = ImmutableNoBuilderDeserialize.instance();
    if (json.prop != null) {
      instance = instance.withProp(json.prop);
    }
    return instance;
  }

  private static final ImmutableNoBuilderDeserialize INSTANCE = validate(new ImmutableNoBuilderDeserialize());

  /**
   * Returns the default immutable singleton value of {@code NoBuilderDeserialize}
   * @return An immutable instance of NoBuilderDeserialize
   */
  public static ImmutableNoBuilderDeserialize instance() {
    return INSTANCE;
  }

  private static ImmutableNoBuilderDeserialize validate(ImmutableNoBuilderDeserialize instance) {
    return instance;
  }
}
