package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionIncludeNonEmptyWithConstructor}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableOptionIncludeNonEmptyWithConstructor.of()}.
 */
@Generated(from = "OptionIncludeNonEmptyWithConstructor", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableOptionIncludeNonEmptyWithConstructor
    extends OptionIncludeNonEmptyWithConstructor {
  private final Optional<String> relationships;

  private ImmutableOptionIncludeNonEmptyWithConstructor(Optional<String> relationships) {
    this.relationships = relationships;
  }

  private ImmutableOptionIncludeNonEmptyWithConstructor(
      ImmutableOptionIncludeNonEmptyWithConstructor original,
      Optional<String> relationships) {
    this.relationships = relationships;
  }

  /**
   * @return The value of the {@code relationships} attribute
   */
  @JsonProperty("relationships")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public Optional<String> getRelationships() {
    return relationships;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionIncludeNonEmptyWithConstructor#getRelationships() relationships} attribute.
   * @param value The value for relationships
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionIncludeNonEmptyWithConstructor withRelationships(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.relationships.equals(newValue)) return this;
    return new ImmutableOptionIncludeNonEmptyWithConstructor(this, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionIncludeNonEmptyWithConstructor#getRelationships() relationships} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for relationships
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionIncludeNonEmptyWithConstructor withRelationships(Optional<String> optional) {
    Optional<String> value = optional;
    if (this.relationships.equals(value)) return this;
    return new ImmutableOptionIncludeNonEmptyWithConstructor(this, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionIncludeNonEmptyWithConstructor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionIncludeNonEmptyWithConstructor
        && equalTo(0, (ImmutableOptionIncludeNonEmptyWithConstructor) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionIncludeNonEmptyWithConstructor another) {
    return relationships.equals(another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + relationships.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OptionIncludeNonEmptyWithConstructor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionIncludeNonEmptyWithConstructor")
        .omitNullValues()
        .add("relationships", relationships.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OptionIncludeNonEmptyWithConstructor", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends OptionIncludeNonEmptyWithConstructor {
    @Nullable Optional<String> relationships = Optional.absent();
    @JsonProperty("relationships")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setRelationships(Optional<String> relationships) {
      this.relationships = relationships;
    }
    @Override
    public Optional<String> getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOptionIncludeNonEmptyWithConstructor fromJson(Json json) {
    ImmutableOptionIncludeNonEmptyWithConstructor instance = ImmutableOptionIncludeNonEmptyWithConstructor.of(json.relationships);
    return instance;
  }

  /**
   * Construct a new immutable {@code OptionIncludeNonEmptyWithConstructor} instance.
   * @param relationships The value for the {@code relationships} attribute
   * @return An immutable OptionIncludeNonEmptyWithConstructor instance
   */
  public static ImmutableOptionIncludeNonEmptyWithConstructor of(Optional<String> relationships) {
    return new ImmutableOptionIncludeNonEmptyWithConstructor(relationships);
  }

  /**
   * Creates an immutable copy of a {@link OptionIncludeNonEmptyWithConstructor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionIncludeNonEmptyWithConstructor instance
   */
  public static ImmutableOptionIncludeNonEmptyWithConstructor copyOf(OptionIncludeNonEmptyWithConstructor instance) {
    if (instance instanceof ImmutableOptionIncludeNonEmptyWithConstructor) {
      return (ImmutableOptionIncludeNonEmptyWithConstructor) instance;
    }
    return ImmutableOptionIncludeNonEmptyWithConstructor.of(instance.getRelationships());
  }
}
