package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StagedEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStagedEntity.builder()}.
 */
@Generated(from = "StagedEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStagedEntity implements StagedEntity {
  private final String required;
  private final String optional;
  private final boolean optionalPrimitive;

  private ImmutableStagedEntity(ImmutableStagedEntity.Builder builder) {
    this.required = builder.required;
    if (builder.optionalIsSet()) {
      initShim.optional(builder.optional);
    }
    if (builder.optionalPrimitiveIsSet()) {
      initShim.optionalPrimitive(builder.optionalPrimitive);
    }
    this.optional = initShim.getOptional();
    this.optionalPrimitive = initShim.getOptionalPrimitive();
    this.initShim = null;
  }

  private ImmutableStagedEntity(String required, String optional, boolean optionalPrimitive) {
    this.required = required;
    this.optional = optional;
    this.optionalPrimitive = optionalPrimitive;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "StagedEntity", generator = "Immutables")
  private final class InitShim {
    private byte optionalBuildStage = STAGE_UNINITIALIZED;
    private String optional;

    String getOptional() {
      if (optionalBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (optionalBuildStage == STAGE_UNINITIALIZED) {
        optionalBuildStage = STAGE_INITIALIZING;
        this.optional = Objects.requireNonNull(getOptionalInitialize(), "optional");
        optionalBuildStage = STAGE_INITIALIZED;
      }
      return this.optional;
    }

    void optional(String optional) {
      this.optional = optional;
      optionalBuildStage = STAGE_INITIALIZED;
    }

    private byte optionalPrimitiveBuildStage = STAGE_UNINITIALIZED;
    private boolean optionalPrimitive;

    boolean getOptionalPrimitive() {
      if (optionalPrimitiveBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (optionalPrimitiveBuildStage == STAGE_UNINITIALIZED) {
        optionalPrimitiveBuildStage = STAGE_INITIALIZING;
        this.optionalPrimitive = getOptionalPrimitiveInitialize();
        optionalPrimitiveBuildStage = STAGE_INITIALIZED;
      }
      return this.optionalPrimitive;
    }

    void optionalPrimitive(boolean optionalPrimitive) {
      this.optionalPrimitive = optionalPrimitive;
      optionalPrimitiveBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (optionalBuildStage == STAGE_INITIALIZING) attributes.add("optional");
      if (optionalPrimitiveBuildStage == STAGE_INITIALIZING) attributes.add("optionalPrimitive");
      return "Cannot build StagedEntity, attribute initializers form cycle " + attributes;
    }
  }

  private String getOptionalInitialize() {
    return StagedEntity.super.getOptional();
  }

  private boolean getOptionalPrimitiveInitialize() {
    return StagedEntity.super.getOptionalPrimitive();
  }

  /**
   * @return The value of the {@code required} attribute
   */
  @JsonProperty("required")
  @Override
  public String getRequired() {
    return required;
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @JsonProperty("optional")
  @Override
  public String getOptional() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOptional()
        : this.optional;
  }

  /**
   * @return The value of the {@code optionalPrimitive} attribute
   */
  @JsonProperty("optionalPrimitive")
  @Override
  public boolean getOptionalPrimitive() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOptionalPrimitive()
        : this.optionalPrimitive;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StagedEntity#getRequired() required} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for required
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStagedEntity withRequired(String value) {
    String newValue = Objects.requireNonNull(value, "required");
    if (this.required.equals(newValue)) return this;
    return new ImmutableStagedEntity(newValue, this.optional, this.optionalPrimitive);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StagedEntity#getOptional() optional} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for optional
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStagedEntity withOptional(String value) {
    String newValue = Objects.requireNonNull(value, "optional");
    if (this.optional.equals(newValue)) return this;
    return new ImmutableStagedEntity(this.required, newValue, this.optionalPrimitive);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StagedEntity#getOptionalPrimitive() optionalPrimitive} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for optionalPrimitive
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStagedEntity withOptionalPrimitive(boolean value) {
    if (this.optionalPrimitive == value) return this;
    return new ImmutableStagedEntity(this.required, this.optional, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStagedEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStagedEntity
        && equalTo(0, (ImmutableStagedEntity) another);
  }

  private boolean equalTo(int synthetic, ImmutableStagedEntity another) {
    return required.equals(another.required)
        && optional.equals(another.optional)
        && optionalPrimitive == another.optionalPrimitive;
  }

  /**
   * Computes a hash code from attributes: {@code required}, {@code optional}, {@code optionalPrimitive}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + required.hashCode();
    h += (h << 5) + optional.hashCode();
    h += (h << 5) + Booleans.hashCode(optionalPrimitive);
    return h;
  }

  /**
   * Prints the immutable value {@code StagedEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StagedEntity")
        .omitNullValues()
        .add("required", required)
        .add("optional", optional)
        .add("optionalPrimitive", optionalPrimitive)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StagedEntity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StagedEntity {
    @Nullable String required;
    @Nullable String optional;
    boolean optionalIsSet;
    boolean optionalPrimitive;
    boolean optionalPrimitiveIsSet;
    @JsonProperty("required")
    public void setRequired(String required) {
      this.required = required;
    }
    @JsonProperty("optional")
    public void setOptional(String optional) {
      this.optional = optional;
      this.optionalIsSet = null != optional;
    }
    @JsonProperty("optionalPrimitive")
    public void setOptionalPrimitive(boolean optionalPrimitive) {
      this.optionalPrimitive = optionalPrimitive;
      this.optionalPrimitiveIsSet = true;
    }
    @Override
    public String getRequired() { throw new UnsupportedOperationException(); }
    @Override
    public String getOptional() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getOptionalPrimitive() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStagedEntity fromJson(Json json) {
    ImmutableStagedEntity.Builder builder = ((ImmutableStagedEntity.Builder) ImmutableStagedEntity.builder());
    if (json.required != null) {
      builder.required(json.required);
    }
    if (json.optionalIsSet) {
      builder.optional(json.optional);
    }
    if (json.optionalPrimitiveIsSet) {
      builder.optionalPrimitive(json.optionalPrimitive);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StagedEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StagedEntity instance
   */
  public static ImmutableStagedEntity copyOf(StagedEntity instance) {
    if (instance instanceof ImmutableStagedEntity) {
      return (ImmutableStagedEntity) instance;
    }
    return ((ImmutableStagedEntity.Builder) ImmutableStagedEntity.builder())
        .required(instance.getRequired())
        .optional(instance.getOptional())
        .optionalPrimitive(instance.getOptionalPrimitive())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStagedEntity ImmutableStagedEntity}.
   * <pre>
   * ImmutableStagedEntity.builder()
   *    .required(String) // required {@link StagedEntity#getRequired() required}
   *    .optional(String) // optional {@link StagedEntity#getOptional() optional}
   *    .optionalPrimitive(boolean) // optional {@link StagedEntity#getOptionalPrimitive() optionalPrimitive}
   *    .build();
   * </pre>
   * @return A new ImmutableStagedEntity builder
   */
  public static RequiredBuildStage builder() {
    return new ImmutableStagedEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStagedEntity ImmutableStagedEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StagedEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements RequiredBuildStage, BuildFinal {
    private static final long INIT_BIT_REQUIRED = 0x1L;
    private static final long OPT_BIT_OPTIONAL = 0x1L;
    private static final long OPT_BIT_OPTIONAL_PRIMITIVE = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String required;
    private @Nullable String optional;
    private boolean optionalPrimitive;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link StagedEntity#getRequired() required} attribute.
     * @param required The value for required 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("required")
    public final Builder required(String required) {
      checkNotIsSet(requiredIsSet(), "required");
      this.required = Objects.requireNonNull(required, "required");
      initBits &= ~INIT_BIT_REQUIRED;
      return this;
    }

    /**
     * Initializes the value for the {@link StagedEntity#getOptional() optional} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StagedEntity#getOptional() optional}.</em>
     * @param optional The value for optional 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("optional")
    public final Builder optional(String optional) {
      checkNotIsSet(optionalIsSet(), "optional");
      this.optional = Objects.requireNonNull(optional, "optional");
      optBits |= OPT_BIT_OPTIONAL;
      return this;
    }

    /**
     * Initializes the value for the {@link StagedEntity#getOptionalPrimitive() optionalPrimitive} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StagedEntity#getOptionalPrimitive() optionalPrimitive}.</em>
     * @param optionalPrimitive The value for optionalPrimitive 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("optionalPrimitive")
    public final Builder optionalPrimitive(boolean optionalPrimitive) {
      checkNotIsSet(optionalPrimitiveIsSet(), "optionalPrimitive");
      this.optionalPrimitive = optionalPrimitive;
      optBits |= OPT_BIT_OPTIONAL_PRIMITIVE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStagedEntity ImmutableStagedEntity}.
     * @return An immutable instance of StagedEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStagedEntity build() {
      checkRequiredAttributes();
      return new ImmutableStagedEntity(this);
    }

    private boolean optionalIsSet() {
      return (optBits & OPT_BIT_OPTIONAL) != 0;
    }

    private boolean optionalPrimitiveIsSet() {
      return (optBits & OPT_BIT_OPTIONAL_PRIMITIVE) != 0;
    }

    private boolean requiredIsSet() {
      return (initBits & INIT_BIT_REQUIRED) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of StagedEntity is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!requiredIsSet()) attributes.add("required");
      return "Cannot build StagedEntity, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "StagedEntity", generator = "Immutables")
  public interface RequiredBuildStage {
    /**
     * Initializes the value for the {@link StagedEntity#getRequired() required} attribute.
     * @param required The value for required 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal required(String required);
  }

  @Generated(from = "StagedEntity", generator = "Immutables")
  public interface BuildFinal {

    /**
     * Initializes the value for the {@link StagedEntity#getOptional() optional} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StagedEntity#getOptional() optional}.</em>
     * @param optional The value for optional 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal optional(String optional);

    /**
     * Initializes the value for the {@link StagedEntity#getOptionalPrimitive() optionalPrimitive} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StagedEntity#getOptionalPrimitive() optionalPrimitive}.</em>
     * @param optionalPrimitive The value for optionalPrimitive 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal optionalPrimitive(boolean optionalPrimitive);

    /**
     * Builds a new {@link ImmutableStagedEntity ImmutableStagedEntity}.
     * @return An immutable instance of StagedEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ImmutableStagedEntity build();
  }
}
