package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BlogEvent.AbstractPostPublished}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PostPublished.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code PostPublished.of()}.
 */
@Generated(from = "BlogEvent.AbstractPostPublished", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class PostPublished implements BlogEvent.AbstractPostPublished {
  private final String postId;

  private PostPublished(String postId) {
    this.postId = Objects.requireNonNull(postId, "postId");
  }

  private PostPublished(PostPublished original, String postId) {
    this.postId = postId;
  }

  /**
   * @return The value of the {@code postId} attribute
   */
  @JsonProperty("postId")
  @Override
  public String getPostId() {
    return postId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlogEvent.AbstractPostPublished#getPostId() postId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for postId
   * @return A modified copy of the {@code this} object
   */
  public final PostPublished withPostId(String value) {
    String newValue = Objects.requireNonNull(value, "postId");
    if (this.postId.equals(newValue)) return this;
    return new PostPublished(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code PostPublished} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PostPublished
        && equalTo(0, (PostPublished) another);
  }

  private boolean equalTo(int synthetic, PostPublished another) {
    return postId.equals(another.postId);
  }

  /**
   * Computes a hash code from attributes: {@code postId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + postId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PostPublished} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PostPublished")
        .omitNullValues()
        .add("postId", postId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "BlogEvent.AbstractPostPublished", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlogEvent.AbstractPostPublished {
    @Nullable String postId;
    @JsonProperty("postId")
    public void setPostId(String postId) {
      this.postId = postId;
    }
    @Override
    public String getPostId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PostPublished fromJson(Json json) {
    PostPublished.Builder builder = PostPublished.builder();
    if (json.postId != null) {
      builder.postId(json.postId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code PostPublished} instance.
   * @param postId The value for the {@code postId} attribute
   * @return An immutable PostPublished instance
   */
  public static PostPublished of(String postId) {
    return new PostPublished(postId);
  }

  /**
   * Creates an immutable copy of a {@link BlogEvent.AbstractPostPublished} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PostPublished instance
   */
  public static PostPublished copyOf(BlogEvent.AbstractPostPublished instance) {
    if (instance instanceof PostPublished) {
      return (PostPublished) instance;
    }
    return PostPublished.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link PostPublished PostPublished}.
   * <pre>
   * PostPublished.builder()
   *    .postId(String) // required {@link BlogEvent.AbstractPostPublished#getPostId() postId}
   *    .build();
   * </pre>
   * @return A new PostPublished builder
   */
  public static PostPublished.Builder builder() {
    return new PostPublished.Builder();
  }

  /**
   * Builds instances of type {@link PostPublished PostPublished}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BlogEvent.AbstractPostPublished", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_POST_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String postId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractPostPublished} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BlogEvent.AbstractPostPublished instance) {
      Objects.requireNonNull(instance, "instance");
      postId(instance.getPostId());
      return this;
    }

    /**
     * Initializes the value for the {@link BlogEvent.AbstractPostPublished#getPostId() postId} attribute.
     * @param postId The value for postId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder postId(String postId) {
      this.postId = Objects.requireNonNull(postId, "postId");
      initBits &= ~INIT_BIT_POST_ID;
      return this;
    }

    /**
     * Builds a new {@link PostPublished PostPublished}.
     * @return An immutable instance of PostPublished
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PostPublished build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PostPublished(null, postId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_POST_ID) != 0) attributes.add("postId");
      return "Cannot build PostPublished, some of required attributes are not set " + attributes;
    }
  }
}
