package org.immutables.fixture.jackson.poly2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _PayloadOne}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PayloadOne.builder()}.
 */
@Generated(from = "_PayloadOne", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class PayloadOne extends org.immutables.fixture.jackson.poly2._PayloadOne {
  private final String propertyOne;
  private final String propertyTwo;

  private PayloadOne(PayloadOne.Builder builder) {
    this.propertyOne = builder.propertyOne;
    this.propertyTwo = builder.propertyTwo;
  }

  /**
   * Some property
   */
  @JsonProperty("propertyOne")
  @Override
  public String getPropertyOne() {
    return propertyOne;
  }

  /**
   * Another property
   */
  @JsonProperty("propertyTwo")
  @Override
  public String getPropertyTwo() {
    return propertyTwo;
  }

  /**
   * This instance is equal to all instances of {@code PayloadOne} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PayloadOne
        && equalTo(0, (PayloadOne) another);
  }

  private boolean equalTo(int synthetic, PayloadOne another) {
    return propertyOne.equals(another.propertyOne)
        && propertyTwo.equals(another.propertyTwo);
  }

  /**
   * Computes a hash code from attributes: {@code propertyOne}, {@code propertyTwo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + propertyOne.hashCode();
    h += (h << 5) + propertyTwo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PayloadOne} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PayloadOne")
        .omitNullValues()
        .add("propertyOne", propertyOne)
        .add("propertyTwo", propertyTwo)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_PayloadOne", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.immutables.fixture.jackson.poly2._PayloadOne {
    @Nullable String propertyOne;
    @Nullable String propertyTwo;
    @JsonProperty("propertyOne")
    public void setPropertyOne(String propertyOne) {
      this.propertyOne = propertyOne;
    }
    @JsonProperty("propertyTwo")
    public void setPropertyTwo(String propertyTwo) {
      this.propertyTwo = propertyTwo;
    }
    @Override
    public String getPropertyOne() { throw new UnsupportedOperationException(); }
    @Override
    public String getPropertyTwo() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PayloadOne fromJson(Json json) {
    PayloadOne.Builder builder = PayloadOne.builder();
    if (json.propertyOne != null) {
      builder.propertyOne(json.propertyOne);
    }
    if (json.propertyTwo != null) {
      builder.propertyTwo(json.propertyTwo);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link PayloadOne PayloadOne}.
   * <pre>
   * PayloadOne.builder()
   *    .propertyOne(String) // required {@link PayloadOne#getPropertyOne() propertyOne}
   *    .propertyTwo(String) // required {@link PayloadOne#getPropertyTwo() propertyTwo}
   *    .build();
   * </pre>
   * @return A new PayloadOne builder
   */
  public static PayloadOne.Builder builder() {
    return new PayloadOne.Builder();
  }

  /**
   * Builds instances of type {@link PayloadOne PayloadOne}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_PayloadOne", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROPERTY_ONE = 0x1L;
    private static final long INIT_BIT_PROPERTY_TWO = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String propertyOne;
    private @Nullable String propertyTwo;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PayloadOne} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PayloadOne instance) {
      return from((_PayloadOne) instance);
    }

    /**
     * Copy abstract value type {@code _PayloadOne} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(_PayloadOne instance) {
      Objects.requireNonNull(instance, "instance");
      propertyOne(instance.getPropertyOne());
      propertyTwo(instance.getPropertyTwo());
      return this;
    }

    /**
     * Initializes the value for the {@link PayloadOne#getPropertyOne() propertyOne} attribute.
     * @param propertyOne The value for propertyOne 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("propertyOne")
    public final Builder propertyOne(String propertyOne) {
      this.propertyOne = Objects.requireNonNull(propertyOne, "propertyOne");
      initBits &= ~INIT_BIT_PROPERTY_ONE;
      return this;
    }

    /**
     * Initializes the value for the {@link PayloadOne#getPropertyTwo() propertyTwo} attribute.
     * @param propertyTwo The value for propertyTwo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("propertyTwo")
    public final Builder propertyTwo(String propertyTwo) {
      this.propertyTwo = Objects.requireNonNull(propertyTwo, "propertyTwo");
      initBits &= ~INIT_BIT_PROPERTY_TWO;
      return this;
    }

    /**
     * Builds a new {@link PayloadOne PayloadOne}.
     * @return An immutable instance of PayloadOne
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PayloadOne build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PayloadOne(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROPERTY_ONE) != 0) attributes.add("propertyOne");
      if ((initBits & INIT_BIT_PROPERTY_TWO) != 0) attributes.add("propertyTwo");
      return "Cannot build PayloadOne, some of required attributes are not set " + attributes;
    }
  }
}
