package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code BbzBuilder} collects parameters and invokes the static factory method:
 * {@code org.immutables.fixture.jdkonly.JdkOptionalBuilderFactory.bbz(..)}.
 * Call the {@link #build()} method to get a result of type {@code int}.
 * <p><em>{@code BbzBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "JdkOptionalBuilderFactory.bbz", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class BbzBuilder {
  private Optional<String> b = Optional.empty();
  private OptionalInt c = OptionalInt.empty();

  /**
   * Creates a {@code BbzBuilder} factory builder.
   * <pre>
   * new BbzBuilder()
   *    .b(String) // optional {@code b}
   *    .c(int) // optional {@code c}
   *    .build();
   * </pre>
   * @param b {@code b} parameter
   * @param c {@code c} parameter
   */
  public BbzBuilder(Optional<String> b, OptionalInt c) {
    b(b);
    c(c);
  }

  /**
   * Initializes the optional value {@code b} to b.
   * @param b The value for b
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  private final BbzBuilder b(Optional<String> b) {
    this.b = (Optional<String>) Objects.requireNonNull(b, "b");
    return this;
  }

  /**
   * Initializes the optional value {@code c} to c.
   * @param c The value for c
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  private final BbzBuilder c(OptionalInt c) {
    this.c = (OptionalInt) Objects.requireNonNull(c, "c");
    return this;
  }

  /**
   * Invokes {@code org.immutables.fixture.jdkonly.JdkOptionalBuilderFactory.bbz(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code int}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public int build() {
    return JdkOptionalBuilderFactory.bbz(b, c);
  }
}
