package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EmptyEnumMapAndSet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEmptyEnumMapAndSet.builder()}.
 */
@Generated(from = "EmptyEnumMapAndSet", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEmptyEnumMapAndSet extends EmptyEnumMapAndSet {
  private final Map<EmptyEnumMapAndSet.Generations, String> genNames;
  private final Set<EmptyEnumMapAndSet.Generations> gens;

  private ImmutableEmptyEnumMapAndSet(ImmutableEmptyEnumMapAndSet.Builder builder) {
    if (builder.genNamesIsSet()) {
      initShim.genNames(createUnmodifiableEnumMap(false, false, builder.genNames));
    }
    if (builder.gensIsSet()) {
      initShim.gens(createUnmodifiableEnumSet(builder.gens));
    }
    this.genNames = initShim.genNames();
    this.gens = initShim.gens();
    this.initShim = null;
  }

  private ImmutableEmptyEnumMapAndSet(
      Map<EmptyEnumMapAndSet.Generations, String> genNames,
      Set<EmptyEnumMapAndSet.Generations> gens) {
    this.genNames = genNames;
    this.gens = gens;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "EmptyEnumMapAndSet", generator = "Immutables")
  private final class InitShim {
    private byte genNamesBuildStage = STAGE_UNINITIALIZED;
    private Map<EmptyEnumMapAndSet.Generations, String> genNames;

    Map<EmptyEnumMapAndSet.Generations, String> genNames() {
      if (genNamesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (genNamesBuildStage == STAGE_UNINITIALIZED) {
        genNamesBuildStage = STAGE_INITIALIZING;
        this.genNames = createUnmodifiableEnumMap(true, false, ImmutableEmptyEnumMapAndSet.super.genNames());
        genNamesBuildStage = STAGE_INITIALIZED;
      }
      return this.genNames;
    }

    void genNames(Map<EmptyEnumMapAndSet.Generations, String> genNames) {
      this.genNames = genNames;
      genNamesBuildStage = STAGE_INITIALIZED;
    }

    private byte gensBuildStage = STAGE_UNINITIALIZED;
    private Set<EmptyEnumMapAndSet.Generations> gens;

    Set<EmptyEnumMapAndSet.Generations> gens() {
      if (gensBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (gensBuildStage == STAGE_UNINITIALIZED) {
        gensBuildStage = STAGE_INITIALIZING;
        this.gens = createUnmodifiableEnumSet(ImmutableEmptyEnumMapAndSet.super.gens());
        gensBuildStage = STAGE_INITIALIZED;
      }
      return this.gens;
    }

    void gens(Set<EmptyEnumMapAndSet.Generations> gens) {
      this.gens = gens;
      gensBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (genNamesBuildStage == STAGE_INITIALIZING) attributes.add("genNames");
      if (gensBuildStage == STAGE_INITIALIZING) attributes.add("gens");
      return "Cannot build EmptyEnumMapAndSet, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code genNames} attribute
   */
  @Override
  public Map<EmptyEnumMapAndSet.Generations, String> genNames() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.genNames()
        : this.genNames;
  }

  /**
   * @return The value of the {@code gens} attribute
   */
  @Override
  public Set<EmptyEnumMapAndSet.Generations> gens() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.gens()
        : this.gens;
  }

  /**
   * Copy the current immutable object by replacing the {@link EmptyEnumMapAndSet#genNames() genNames} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the genNames map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEmptyEnumMapAndSet withGenNames(Map<EmptyEnumMapAndSet.Generations, ? extends String> entries) {
    if (this.genNames == entries) return this;
    Map<EmptyEnumMapAndSet.Generations, String> newValue = createUnmodifiableEnumMap(true, false, entries);
    return new ImmutableEmptyEnumMapAndSet(newValue, this.gens);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmptyEnumMapAndSet#gens() gens}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEmptyEnumMapAndSet withGens(EmptyEnumMapAndSet.Generations... elements) {
    Set<EmptyEnumMapAndSet.Generations> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableEmptyEnumMapAndSet(this.genNames, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmptyEnumMapAndSet#gens() gens}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of gens elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEmptyEnumMapAndSet withGens(Iterable<EmptyEnumMapAndSet.Generations> elements) {
    if (this.gens == elements) return this;
    Set<EmptyEnumMapAndSet.Generations> newValue = createUnmodifiableEnumSet(elements);
    return new ImmutableEmptyEnumMapAndSet(this.genNames, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEmptyEnumMapAndSet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEmptyEnumMapAndSet
        && equalTo(0, (ImmutableEmptyEnumMapAndSet) another);
  }

  private boolean equalTo(int synthetic, ImmutableEmptyEnumMapAndSet another) {
    return genNames.equals(another.genNames)
        && gens.equals(another.gens);
  }

  /**
   * Computes a hash code from attributes: {@code genNames}, {@code gens}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + genNames.hashCode();
    h += (h << 5) + gens.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EmptyEnumMapAndSet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EmptyEnumMapAndSet{"
        + "genNames=" + genNames
        + ", gens=" + gens
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EmptyEnumMapAndSet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EmptyEnumMapAndSet instance
   */
  public static ImmutableEmptyEnumMapAndSet copyOf(EmptyEnumMapAndSet instance) {
    if (instance instanceof ImmutableEmptyEnumMapAndSet) {
      return (ImmutableEmptyEnumMapAndSet) instance;
    }
    return ImmutableEmptyEnumMapAndSet.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEmptyEnumMapAndSet ImmutableEmptyEnumMapAndSet}.
   * <pre>
   * ImmutableEmptyEnumMapAndSet.builder()
   *    .putGenNames|putAllGenNames(org.immutables.fixture.jdkonly.EmptyEnumMapAndSet.Generations =&gt; String) // {@link EmptyEnumMapAndSet#genNames() genNames} mappings
   *    .addGens|addAllGens(org.immutables.fixture.jdkonly.EmptyEnumMapAndSet.Generations) // {@link EmptyEnumMapAndSet#gens() gens} elements
   *    .build();
   * </pre>
   * @return A new ImmutableEmptyEnumMapAndSet builder
   */
  public static ImmutableEmptyEnumMapAndSet.Builder builder() {
    return new ImmutableEmptyEnumMapAndSet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEmptyEnumMapAndSet ImmutableEmptyEnumMapAndSet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EmptyEnumMapAndSet", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_GEN_NAMES = 0x1L;
    private static final long OPT_BIT_GENS = 0x2L;
    private long optBits;

    private EnumMap<EmptyEnumMapAndSet.Generations, String> genNames = new EnumMap<EmptyEnumMapAndSet.Generations, String>(EmptyEnumMapAndSet.Generations.class);
    private EnumSet<EmptyEnumMapAndSet.Generations> gens = EnumSet.noneOf(EmptyEnumMapAndSet.Generations.class);

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EmptyEnumMapAndSet} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(EmptyEnumMapAndSet instance) {
      Objects.requireNonNull(instance, "instance");
      putAllGenNames(instance.genNames());
      addAllGens(instance.gens());
      return this;
    }

    /**
     * Put one entry to the {@link EmptyEnumMapAndSet#genNames() genNames} map.
     * @param key The key in the genNames map
     * @param value The associated value in the genNames map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putGenNames(EmptyEnumMapAndSet.Generations key, String value) {
      this.genNames.put(
          Objects.requireNonNull(key, "genNames key"),
          value == null ? Objects.requireNonNull(value, "genNames value for key: " + key) : value);
      optBits |= OPT_BIT_GEN_NAMES;
      return this;
    }

    /**
     * Put one entry to the {@link EmptyEnumMapAndSet#genNames() genNames} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putGenNames(Map.Entry<EmptyEnumMapAndSet.Generations, ? extends String> entry) {
      EmptyEnumMapAndSet.Generations k = entry.getKey();
      String v = entry.getValue();
      this.genNames.put(
          Objects.requireNonNull(k, "genNames key"),
          v == null ? Objects.requireNonNull(v, "genNames value for key: " + k) : v);
      optBits |= OPT_BIT_GEN_NAMES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EmptyEnumMapAndSet#genNames() genNames} map. Nulls are not permitted
     * @param entries The entries that will be added to the genNames map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder genNames(Map<EmptyEnumMapAndSet.Generations, ? extends String> entries) {
      this.genNames.clear();
      optBits |= OPT_BIT_GEN_NAMES;
      return putAllGenNames(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EmptyEnumMapAndSet#genNames() genNames} map. Nulls are not permitted
     * @param entries The entries that will be added to the genNames map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllGenNames(Map<EmptyEnumMapAndSet.Generations, ? extends String> entries) {
      for (Map.Entry<EmptyEnumMapAndSet.Generations, ? extends String> e : entries.entrySet()) {
        EmptyEnumMapAndSet.Generations k = e.getKey();
        String v = e.getValue();
        this.genNames.put(
            Objects.requireNonNull(k, "genNames key"),
            v == null ? Objects.requireNonNull(v, "genNames value for key: " + k) : v);
      }
      optBits |= OPT_BIT_GEN_NAMES;
      return this;
    }

    /**
     * Adds one element to {@link EmptyEnumMapAndSet#gens() gens} set.
     * @param element A gens element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGens(EmptyEnumMapAndSet.Generations element) {
      this.gens.add(Objects.requireNonNull(element, "gens element"));
      optBits |= OPT_BIT_GENS;
      return this;
    }

    /**
     * Adds elements to {@link EmptyEnumMapAndSet#gens() gens} set.
     * @param elements An array of gens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGens(EmptyEnumMapAndSet.Generations... elements) {
      for (EmptyEnumMapAndSet.Generations element : elements) {
        this.gens.add(Objects.requireNonNull(element, "gens element"));
      }
      optBits |= OPT_BIT_GENS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EmptyEnumMapAndSet#gens() gens} set.
     * @param elements An iterable of gens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gens(Iterable<EmptyEnumMapAndSet.Generations> elements) {
      this.gens.clear();
      return addAllGens(elements);
    }

    /**
     * Adds elements to {@link EmptyEnumMapAndSet#gens() gens} set.
     * @param elements An iterable of gens elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGens(Iterable<EmptyEnumMapAndSet.Generations> elements) {
      for (EmptyEnumMapAndSet.Generations element : elements) {
        this.gens.add(Objects.requireNonNull(element, "gens element"));
      }
      optBits |= OPT_BIT_GENS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEmptyEnumMapAndSet ImmutableEmptyEnumMapAndSet}.
     * @return An immutable instance of EmptyEnumMapAndSet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEmptyEnumMapAndSet build() {
      return new ImmutableEmptyEnumMapAndSet(this);
    }

    private boolean genNamesIsSet() {
      return (optBits & OPT_BIT_GEN_NAMES) != 0;
    }

    private boolean gensIsSet() {
      return (optBits & OPT_BIT_GENS) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  @SuppressWarnings("unchecked")
  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }

  private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
    if (map.isEmpty()) return Collections.emptyMap();
    EnumMap<K, V> enumMap = new EnumMap<>(map);
    if (checkNulls || skipNulls) {
      Iterator<? extends V> it = map.values().iterator();
      while(it.hasNext()) {
        V v = it.next();
        if (checkNulls) {
          Objects.requireNonNull(v, "value");
        } else if (skipNulls) {
          if (v == null) it.remove();
        }
      }
    }
    return Collections.unmodifiableMap(enumMap);
  }
}
