package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.Var;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JdkOptionals}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableJdkOptionals.of()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableJdkOptionals.of()}.
 */
@Generated(from = "JdkOptionals", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJdkOptionals
    implements JdkOptionals, Serializable {
  private final @Nullable String v2;
  private final @Nullable Integer i1;
  private final @Nullable Long l1;
  private final @Nullable Double d1;
  private transient final int hashCode;

  private ImmutableJdkOptionals() {
    this.v2 = null;
    this.i1 = null;
    this.l1 = null;
    this.d1 = null;
    this.hashCode = computeHashCode();
  }

  private ImmutableJdkOptionals(
      Optional<String> v2,
      OptionalInt i1,
      OptionalLong l1,
      OptionalDouble d1) {
    this.v2 = v2.orElse(null);
    this.i1 = i1.isPresent() ? i1.getAsInt() : null;
    this.l1 = l1.isPresent() ? l1.getAsLong() : null;
    this.d1 = d1.isPresent() ? d1.getAsDouble() : null;
    this.hashCode = computeHashCode();
  }

  private ImmutableJdkOptionals(
      ImmutableJdkOptionals original,
      @Nullable String v2,
      @Nullable Integer i1,
      @Nullable Long l1,
      @Nullable Double d1) {
    this.v2 = v2;
    this.i1 = i1;
    this.l1 = l1;
    this.d1 = d1;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code v2} attribute
   */
  @Override
  public Optional<String> v2() {
    return Optional.ofNullable(v2);
  }

  /**
   * @return The value of the {@code i1} attribute
   */
  @Override
  public OptionalInt i1() {
    return i1 != null
        ? OptionalInt.of(i1)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code l1} attribute
   */
  @Override
  public OptionalLong l1() {
    return l1 != null
        ? OptionalLong.of(l1)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code d1} attribute
   */
  @Override
  public OptionalDouble d1() {
    return d1 != null
        ? OptionalDouble.of(d1)
        : OptionalDouble.empty();
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionals#v2() v2} attribute.
   * @param value The value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withV2(String value) {
    String newValue = Objects.requireNonNull(value, "v2");
    if (Objects.equals(this.v2, newValue)) return this;
    return validate(new ImmutableJdkOptionals(this, newValue, this.i1, this.l1, this.d1));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionals#v2() v2} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withV2(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.v2, value)) return this;
    return validate(new ImmutableJdkOptionals(this, value, this.i1, this.l1, this.d1));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionals#i1() i1} attribute.
   * @param value The value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withI1(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.i1, newValue)) return this;
    return validate(new ImmutableJdkOptionals(this, this.v2, newValue, this.l1, this.d1));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionals#i1() i1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withI1(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.i1, value)) return this;
    return validate(new ImmutableJdkOptionals(this, this.v2, value, this.l1, this.d1));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionals#l1() l1} attribute.
   * @param value The value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withL1(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.l1, newValue)) return this;
    return validate(new ImmutableJdkOptionals(this, this.v2, this.i1, newValue, this.d1));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionals#l1() l1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withL1(OptionalLong optional) {
    @Nullable Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.l1, value)) return this;
    return validate(new ImmutableJdkOptionals(this, this.v2, this.i1, value, this.d1));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionals#d1() d1} attribute.
   * @param value The value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withD1(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.d1, newValue)) return this;
    return validate(new ImmutableJdkOptionals(this, this.v2, this.i1, this.l1, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionals#d1() d1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionals withD1(OptionalDouble optional) {
    @Nullable Double value = optional.isPresent() ? optional.getAsDouble() : null;
    if (Objects.equals(this.d1, value)) return this;
    return validate(new ImmutableJdkOptionals(this, this.v2, this.i1, this.l1, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkOptionals} that have equal attribute values.
   * As instances of the {@code ImmutableJdkOptionals} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(int synthetic, ImmutableJdkOptionals another) {
    if (hashCode != another.hashCode) return false;
    return Objects.equals(v2, another.v2)
        && Objects.equals(i1, another.i1)
        && Objects.equals(l1, another.l1)
        && Objects.equals(d1, another.d1);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code v2}, {@code i1}, {@code l1}, {@code d1}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(v2);
    h += (h << 5) + Objects.hashCode(i1);
    h += (h << 5) + Objects.hashCode(l1);
    h += (h << 5) + Objects.hashCode(d1);
    return h;
  }

  /**
   * Prints the immutable value {@code JdkOptionals} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("JdkOptionals{");
    if (v2 != null) {
      builder.append("v2=").append(v2);
    }
    if (i1 != null) {
      if (builder.length() > 13) builder.append(", ");
      builder.append("i1=").append(i1);
    }
    if (l1 != null) {
      if (builder.length() > 13) builder.append(", ");
      builder.append("l1=").append(l1);
    }
    if (d1 != null) {
      if (builder.length() > 13) builder.append(", ");
      builder.append("d1=").append(d1);
    }
    return builder.append("}").toString();
  }

  @Generated(from = "JdkOptionals", generator = "Immutables")
  private static class InternProxy {
    final ImmutableJdkOptionals instance;

    InternProxy(ImmutableJdkOptionals instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(0, ((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final class InternerHolder {
    static final ConcurrentHashMap<InternProxy, ImmutableJdkOptionals> INTERNER =
        new ConcurrentHashMap<InternProxy, ImmutableJdkOptionals>();
  }

  private static final ImmutableJdkOptionals INSTANCE = validate(new ImmutableJdkOptionals());

  /**
   * Returns the default immutable singleton value of {@code JdkOptionals}
   * @return An immutable instance of JdkOptionals
   */
  public static ImmutableJdkOptionals of() {
    return INSTANCE;
  }

  /**
   * Construct a new immutable {@code JdkOptionals} instance.
   * @param v2 The value for the {@code v2} attribute
   * @param i1 The value for the {@code i1} attribute
   * @param l1 The value for the {@code l1} attribute
   * @param d1 The value for the {@code d1} attribute
   * @return An immutable JdkOptionals instance
   */
  public static ImmutableJdkOptionals of(Optional<String> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1) {
    return validate(new ImmutableJdkOptionals(v2, i1, l1, d1));
  }

  private static ImmutableJdkOptionals validate(ImmutableJdkOptionals instance) {
    @Nullable ImmutableJdkOptionals interned = InternerHolder.INTERNER.putIfAbsent(new InternProxy(instance), instance);
    return interned != null ? interned : instance;
  }

  /**
   * Creates an immutable copy of a {@link JdkOptionals} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkOptionals instance
   */
  public static ImmutableJdkOptionals copyOf(JdkOptionals instance) {
    if (instance instanceof ImmutableJdkOptionals) {
      return (ImmutableJdkOptionals) instance;
    }
    return ImmutableJdkOptionals.of(instance.v2(), instance.i1(), instance.l1(), instance.d1());
  }

  /**
   * The serialized form captures the structural content of the value object,
   * providing the ability to reconstruct values with the capability to migrate
   * data. Uses optional, nullable, and provides flexible handling of
   * collection attributes.
   */
  @Generated(from = "JdkOptionals", generator = "Immutables")
  private static class SerialForm implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String[] names;
    private final Object[] values;
    SerialForm(ImmutableJdkOptionals instance) {
      List<String> names = new ArrayList<>(4);
      List<Object> values = new ArrayList<>(4);
      if (instance.v2().isPresent()) {
        names.add("v2");
        values.add(instance.v2().get());
      }
      if (instance.i1().isPresent()) {
        names.add("i1");
        values.add(instance.i1().getAsInt());
      }
      if (instance.l1().isPresent()) {
        names.add("l1");
        values.add(instance.l1().getAsLong());
      }
      if (instance.d1().isPresent()) {
        names.add("d1");
        values.add(instance.d1().getAsDouble());
      }
      this.names = names.toArray(new String[names.size()]);
      this.values = values.toArray();
    }

    Object readResolve() {
      Optional<String> v2Value = Optional.empty();
      OptionalInt i1Value = OptionalInt.empty();
      OptionalLong l1Value = OptionalLong.empty();
      OptionalDouble d1Value = OptionalDouble.empty();

      for (int i = 0; i < names.length; i++) {
        String name = names[i];
        if ("v2".equals(name)) {
          if (values[i] != null) {
            v2Value = Optional.of((String) values[i]);
          }
          continue;
        }
        if ("i1".equals(name)) {
          if (values[i] != null) {
            i1Value = OptionalInt.of((Integer) values[i]);
          }
          continue;
        }
        if ("l1".equals(name)) {
          if (values[i] != null) {
            l1Value = OptionalLong.of((Long) values[i]);
          }
          continue;
        }
        if ("d1".equals(name)) {
          if (values[i] != null) {
            d1Value = OptionalDouble.of((Double) values[i]);
          }
          continue;
        }
      }
      ImmutableJdkOptionals instance = ImmutableJdkOptionals.of(v2Value, i1Value, l1Value, d1Value);
      return instance;
    }

    private static Object toSingle(String attribute, Object value) {
      if (value instanceof Object[]) {
        Object[] elements = (Object[]) value;
        if (elements.length == 1) {
          return elements[0];
        }
        throw new IllegalStateException("Cannot extract scalar value for attribute '"
            + attribute + "' from array of length " + elements.length);
      }
      return value;
    }
  }

  private Object writeReplace() {
    return new SerialForm(this);
  }
}
