package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoLocalVariablesOverlapping}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNoLocalVariablesOverlapping.builder()}.
 */
@Generated(from = "NoLocalVariablesOverlapping", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNoLocalVariablesOverlapping
    extends NoLocalVariablesOverlapping {
  private final Map<String, String> entry;
  private final Map<String, String> k;
  private final Map<String, String> v;
  private final List<String> elements;

  private ImmutableNoLocalVariablesOverlapping(
      Map<String, String> entry,
      Map<String, String> k,
      Map<String, String> v,
      List<String> elements) {
    this.entry = entry;
    this.k = k;
    this.v = v;
    this.elements = elements;
  }

  /**
   * @return The value of the {@code entry} attribute
   */
  @Override
  public Map<String, String> getEntry() {
    return entry;
  }

  /**
   * @return The value of the {@code k} attribute
   */
  @Override
  public Map<String, String> getK() {
    return k;
  }

  /**
   * @return The value of the {@code v} attribute
   */
  @Override
  public Map<String, String> getV() {
    return v;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @Override
  public List<String> getElements() {
    return elements;
  }

  /**
   * Copy the current immutable object by replacing the {@link NoLocalVariablesOverlapping#getEntry() entry} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the entry map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoLocalVariablesOverlapping withEntry(Map<String, ? extends String> entries) {
    if (this.entry == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableNoLocalVariablesOverlapping(newValue, this.k, this.v, this.elements);
  }

  /**
   * Copy the current immutable object by replacing the {@link NoLocalVariablesOverlapping#getK() k} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the k map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoLocalVariablesOverlapping withK(Map<String, ? extends String> entries) {
    if (this.k == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableNoLocalVariablesOverlapping(this.entry, newValue, this.v, this.elements);
  }

  /**
   * Copy the current immutable object by replacing the {@link NoLocalVariablesOverlapping#getV() v} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the v map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoLocalVariablesOverlapping withV(Map<String, ? extends String> entries) {
    if (this.v == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableNoLocalVariablesOverlapping(this.entry, this.k, newValue, this.elements);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoLocalVariablesOverlapping#getElements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoLocalVariablesOverlapping withElements(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableNoLocalVariablesOverlapping(this.entry, this.k, this.v, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoLocalVariablesOverlapping#getElements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoLocalVariablesOverlapping withElements(Iterable<String> elements) {
    if (this.elements == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableNoLocalVariablesOverlapping(this.entry, this.k, this.v, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNoLocalVariablesOverlapping} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNoLocalVariablesOverlapping
        && equalTo(0, (ImmutableNoLocalVariablesOverlapping) another);
  }

  private boolean equalTo(int synthetic, ImmutableNoLocalVariablesOverlapping another) {
    return entry.equals(another.entry)
        && k.equals(another.k)
        && v.equals(another.v)
        && elements.equals(another.elements);
  }

  /**
   * Computes a hash code from attributes: {@code entry}, {@code k}, {@code v}, {@code elements}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + entry.hashCode();
    h += (h << 5) + k.hashCode();
    h += (h << 5) + v.hashCode();
    h += (h << 5) + elements.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NoLocalVariablesOverlapping} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NoLocalVariablesOverlapping{"
        + "entry=" + entry
        + ", k=" + k
        + ", v=" + v
        + ", elements=" + elements
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link NoLocalVariablesOverlapping} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NoLocalVariablesOverlapping instance
   */
  public static ImmutableNoLocalVariablesOverlapping copyOf(NoLocalVariablesOverlapping instance) {
    if (instance instanceof ImmutableNoLocalVariablesOverlapping) {
      return (ImmutableNoLocalVariablesOverlapping) instance;
    }
    return ImmutableNoLocalVariablesOverlapping.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNoLocalVariablesOverlapping ImmutableNoLocalVariablesOverlapping}.
   * <pre>
   * ImmutableNoLocalVariablesOverlapping.builder()
   *    .putEntry|putAllEntry(String =&gt; String) // {@link NoLocalVariablesOverlapping#getEntry() entry} mappings
   *    .putK|putAllK(String =&gt; String) // {@link NoLocalVariablesOverlapping#getK() k} mappings
   *    .putV|putAllV(String =&gt; String) // {@link NoLocalVariablesOverlapping#getV() v} mappings
   *    .addElements|addAllElements(String) // {@link NoLocalVariablesOverlapping#getElements() elements} elements
   *    .build();
   * </pre>
   * @return A new ImmutableNoLocalVariablesOverlapping builder
   */
  public static ImmutableNoLocalVariablesOverlapping.Builder builder() {
    return new ImmutableNoLocalVariablesOverlapping.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNoLocalVariablesOverlapping ImmutableNoLocalVariablesOverlapping}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NoLocalVariablesOverlapping", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, String> entry = new LinkedHashMap<String, String>();
    private Map<String, String> k = new LinkedHashMap<String, String>();
    private Map<String, String> v = new LinkedHashMap<String, String>();
    private List<String> elements = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NoLocalVariablesOverlapping} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoLocalVariablesOverlapping instance) {
      Objects.requireNonNull(instance, "instance");
      putAllEntry(instance.getEntry());
      putAllK(instance.getK());
      putAllV(instance.getV());
      addAllElements(instance.getElements());
      return this;
    }

    /**
     * Put one entry to the {@link NoLocalVariablesOverlapping#getEntry() entry} map.
     * @param key The key in the entry map
     * @param value The associated value in the entry map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putEntry(String key, String value) {
      this.entry.put(
          Objects.requireNonNull(key, "entry key"),
          value == null ? Objects.requireNonNull(value, "entry value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link NoLocalVariablesOverlapping#getEntry() entry} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putEntry(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.entry.put(
          Objects.requireNonNull(k, "entry key"),
          v == null ? Objects.requireNonNull(v, "entry value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NoLocalVariablesOverlapping#getEntry() entry} map. Nulls are not permitted
     * @param entries The entries that will be added to the entry map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entry(Map<String, ? extends String> entries) {
      this.entry.clear();
      return putAllEntry(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NoLocalVariablesOverlapping#getEntry() entry} map. Nulls are not permitted
     * @param entries The entries that will be added to the entry map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllEntry(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.entry.put(
            Objects.requireNonNull(k, "entry key"),
            v == null ? Objects.requireNonNull(v, "entry value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link NoLocalVariablesOverlapping#getK() k} map.
     * @param key The key in the k map
     * @param value The associated value in the k map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putK(String key, String value) {
      this.k.put(
          Objects.requireNonNull(key, "k key"),
          value == null ? Objects.requireNonNull(value, "k value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link NoLocalVariablesOverlapping#getK() k} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putK(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.k.put(
          Objects.requireNonNull(k, "k key"),
          v == null ? Objects.requireNonNull(v, "k value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NoLocalVariablesOverlapping#getK() k} map. Nulls are not permitted
     * @param entries The entries that will be added to the k map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder k(Map<String, ? extends String> entries) {
      this.k.clear();
      return putAllK(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NoLocalVariablesOverlapping#getK() k} map. Nulls are not permitted
     * @param entries The entries that will be added to the k map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllK(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.k.put(
            Objects.requireNonNull(k, "k key"),
            v == null ? Objects.requireNonNull(v, "k value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link NoLocalVariablesOverlapping#getV() v} map.
     * @param key The key in the v map
     * @param value The associated value in the v map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putV(String key, String value) {
      this.v.put(
          Objects.requireNonNull(key, "v key"),
          value == null ? Objects.requireNonNull(value, "v value for key: " + key) : value);
      return this;
    }

    /**
     * Put one entry to the {@link NoLocalVariablesOverlapping#getV() v} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putV(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.v.put(
          Objects.requireNonNull(k, "v key"),
          v == null ? Objects.requireNonNull(v, "v value for key: " + k) : v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NoLocalVariablesOverlapping#getV() v} map. Nulls are not permitted
     * @param entries The entries that will be added to the v map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v(Map<String, ? extends String> entries) {
      this.v.clear();
      return putAllV(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NoLocalVariablesOverlapping#getV() v} map. Nulls are not permitted
     * @param entries The entries that will be added to the v map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllV(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.v.put(
            Objects.requireNonNull(k, "v key"),
            v == null ? Objects.requireNonNull(v, "v value for key: " + k) : v);
      }
      return this;
    }

    /**
     * Adds one element to {@link NoLocalVariablesOverlapping#getElements() elements} list.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(String element) {
      this.elements.add(Objects.requireNonNull(element, "elements element"));
      return this;
    }

    /**
     * Adds elements to {@link NoLocalVariablesOverlapping#getElements() elements} list.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(String... elements) {
      for (String element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NoLocalVariablesOverlapping#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder elements(Iterable<String> elements) {
      this.elements.clear();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link NoLocalVariablesOverlapping#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllElements(Iterable<String> elements) {
      for (String element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableNoLocalVariablesOverlapping ImmutableNoLocalVariablesOverlapping}.
     * @return An immutable instance of NoLocalVariablesOverlapping
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNoLocalVariablesOverlapping build() {
      return new ImmutableNoLocalVariablesOverlapping(
          createUnmodifiableMap(false, false, entry),
          createUnmodifiableMap(false, false, k),
          createUnmodifiableMap(false, false, v),
          createUnmodifiableList(true, elements));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
