package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ToImmutableCopyFalse.A}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableA.builder()}.
 */
@Generated(from = "ToImmutableCopyFalse.A", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableA implements ToImmutableCopyFalse.A {

  private ImmutableA(ImmutableA.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableA} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableA
        && equalTo(0, (ImmutableA) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableA another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 54852939;
  }

  /**
   * Prints the immutable value {@code A}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "A{}";
  }

  /**
   * Creates a builder for {@link ImmutableA ImmutableA}.
   * <pre>
   * ImmutableA.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableA builder
   */
  public static ImmutableA.Builder builder() {
    return new ImmutableA.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableA ImmutableA}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ToImmutableCopyFalse.A", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableA} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableA instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code A} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToImmutableCopyFalse.A instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableA) {
        return from((ModifiableA) instance);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableA ImmutableA}.
     * @return An immutable instance of A
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableA build() {
      return new ImmutableA(this);
    }
  }
}
