package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericMods}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenericMods.builder()}.
 */
@Generated(from = "GenericMods", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGenericMods<T> implements GenericMods<T> {
  private final int a;
  private final T b;
  private final int c;

  private ImmutableGenericMods(int a, T b, int c) {
    this.a = a;
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public T b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public int c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericMods#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericMods<T> withA(int value) {
    if (this.a == value) return this;
    return new ImmutableGenericMods<>(value, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericMods#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericMods<T> withB(T value) {
    if (this.b == value) return this;
    T newValue = Objects.requireNonNull(value, "b");
    return new ImmutableGenericMods<>(this.a, newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericMods#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericMods<T> withC(int value) {
    if (this.c == value) return this;
    return new ImmutableGenericMods<>(this.a, this.b, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenericMods} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenericMods<?>
        && equalTo(0, (ImmutableGenericMods<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableGenericMods<?> another) {
    return a == another.a
        && b.equals(another.b)
        && c == another.c;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c;
    return h;
  }

  /**
   * Prints the immutable value {@code GenericMods} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GenericMods")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GenericMods} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable GenericMods instance
   */
  public static <T> ImmutableGenericMods<T> copyOf(GenericMods<T> instance) {
    if (instance instanceof ImmutableGenericMods<?>) {
      return (ImmutableGenericMods<T>) instance;
    }
    return ImmutableGenericMods.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGenericMods ImmutableGenericMods}.
   * <pre>
   * ImmutableGenericMods.&amp;lt;T&amp;gt;builder()
   *    .a(int) // required {@link GenericMods#a() a}
   *    .b(T) // required {@link GenericMods#b() b}
   *    .c(int) // required {@link GenericMods#c() c}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableGenericMods builder
   */
  public static <T> ImmutableGenericMods.Builder<T> builder() {
    return new ImmutableGenericMods.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGenericMods ImmutableGenericMods}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericMods", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private long initBits = 0x7L;

    private int a;
    private @Nullable T b;
    private int c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableGenericMods} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ModifiableGenericMods<T> instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.aIsSet()) {
        a(instance.a());
      }
      if (instance.bIsSet()) {
        b(instance.b());
      }
      if (instance.cIsSet()) {
        c(instance.c());
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.modifiable.Supertype} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Supertype instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.modifiable.GenericMods} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericMods<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      if (object instanceof ModifiableGenericMods<?>) {
        from((ModifiableGenericMods<T>) object);
        return;
      }
      @Var long bits = 0;
      if (object instanceof Supertype) {
        Supertype instance = (Supertype) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          c(instance.c());
          bits |= 0x2L;
        }
      }
      if (object instanceof GenericMods<?>) {
        GenericMods<T> instance = (GenericMods<T>) object;
        if ((bits & 0x1L) == 0) {
          a(instance.a());
          bits |= 0x1L;
        }
        b(instance.b());
        if ((bits & 0x2L) == 0) {
          c(instance.c());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GenericMods#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericMods#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> b(T b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericMods#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> c(int c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenericMods ImmutableGenericMods}.
     * @return An immutable instance of GenericMods
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenericMods<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGenericMods<>(a, b, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build GenericMods, some of required attributes are not set " + attributes;
    }
  }
}
