package org.immutables.fixture.modifiable;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HavingEqualsHashCode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHavingEqualsHashCode.builder()}.
 */
@Generated(from = "HavingEqualsHashCode", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHavingEqualsHashCode
    extends HavingEqualsHashCode {

  private ImmutableHavingEqualsHashCode(ImmutableHavingEqualsHashCode.Builder builder) {
  }

  private boolean equalTo(int synthetic, ImmutableHavingEqualsHashCode another) {
    return super.equals(another);
  }

  /**
   * Prints the immutable value {@code HavingEqualsHashCode}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HavingEqualsHashCode{}";
  }

  @Generated(from = "HavingEqualsHashCode", generator = "Immutables")
  private static class InternProxy {
    final ImmutableHavingEqualsHashCode instance;

    InternProxy(ImmutableHavingEqualsHashCode instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(0, ((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final class InternerHolder {
    static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();
  }

  private static ImmutableHavingEqualsHashCode validate(ImmutableHavingEqualsHashCode instance) {
    return InternerHolder.INTERNER.intern(new InternProxy(instance)).instance;
  }

  /**
   * Creates an immutable copy of a {@link HavingEqualsHashCode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HavingEqualsHashCode instance
   */
  public static ImmutableHavingEqualsHashCode copyOf(HavingEqualsHashCode instance) {
    if (instance instanceof ImmutableHavingEqualsHashCode) {
      return (ImmutableHavingEqualsHashCode) instance;
    }
    return ImmutableHavingEqualsHashCode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHavingEqualsHashCode ImmutableHavingEqualsHashCode}.
   * <pre>
   * ImmutableHavingEqualsHashCode.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableHavingEqualsHashCode builder
   */
  public static ImmutableHavingEqualsHashCode.Builder builder() {
    return new ImmutableHavingEqualsHashCode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHavingEqualsHashCode ImmutableHavingEqualsHashCode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HavingEqualsHashCode", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableHavingEqualsHashCode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableHavingEqualsHashCode instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code HavingEqualsHashCode} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HavingEqualsHashCode instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableHavingEqualsHashCode) {
        return from((ModifiableHavingEqualsHashCode) instance);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableHavingEqualsHashCode ImmutableHavingEqualsHashCode}.
     * @return An immutable instance of HavingEqualsHashCode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHavingEqualsHashCode build() {
      return ImmutableHavingEqualsHashCode.validate(new ImmutableHavingEqualsHashCode(this));
    }
  }
}
