package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableListMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableListMap.builder()}.
 */
@Generated(from = "NullableListMap", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullableListMap implements NullableListMap {
  private final @Nullable Object object;
  private final @Nullable ImmutableList<Object> objects;
  private final @Nullable ImmutableMap<String, String> map;

  private ImmutableNullableListMap(
      @Nullable Object object,
      @Nullable ImmutableList<Object> objects,
      @Nullable ImmutableMap<String, String> map) {
    this.object = object;
    this.objects = objects;
    this.map = map;
  }

  /**
   * @return The value of the {@code object} attribute
   */
  @Override
  public @Nullable Object getObject() {
    return object;
  }

  /**
   * @return The value of the {@code objects} attribute
   */
  @Override
  public @Nullable ImmutableList<Object> getObjects() {
    return objects;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public @Nullable ImmutableMap<String, String> getMap() {
    return map;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullableListMap#getObject() object} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for object (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullableListMap withObject(@Nullable Object value) {
    if (this.object == value) return this;
    return new ImmutableNullableListMap(value, this.objects, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableListMap#getObjects() objects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableListMap withObjects(@Nullable Object... elements) {
    if (elements == null) {
      return new ImmutableNullableListMap(this.object, null, this.map);
    }
    @Nullable ImmutableList<Object> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableListMap(this.object, newValue, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableListMap#getObjects() objects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objects elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableListMap withObjects(@Nullable Iterable<? extends Object> elements) {
    if (this.objects == elements) return this;
    @Nullable ImmutableList<Object> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableListMap(this.object, newValue, this.map);
  }

  /**
   * Copy the current immutable object by replacing the {@link NullableListMap#getMap() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableListMap withMap(@Nullable Map<String, ? extends String> entries) {
    if (this.map == entries) return this;
    @Nullable ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return new ImmutableNullableListMap(this.object, this.objects, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableListMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableListMap
        && equalTo(0, (ImmutableNullableListMap) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableListMap another) {
    return Objects.equals(object, another.object)
        && Objects.equals(objects, another.objects)
        && Objects.equals(map, another.map);
  }

  /**
   * Computes a hash code from attributes: {@code object}, {@code objects}, {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(object);
    h += (h << 5) + Objects.hashCode(objects);
    h += (h << 5) + Objects.hashCode(map);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableListMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableListMap")
        .omitNullValues()
        .add("object", object)
        .add("objects", objects)
        .add("map", map)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NullableListMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableListMap instance
   */
  public static ImmutableNullableListMap copyOf(NullableListMap instance) {
    if (instance instanceof ImmutableNullableListMap) {
      return (ImmutableNullableListMap) instance;
    }
    return ImmutableNullableListMap.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableListMap ImmutableNullableListMap}.
   * <pre>
   * ImmutableNullableListMap.builder()
   *    .object(Object | null) // nullable {@link NullableListMap#getObject() object}
   *    .objects(List&amp;lt;Object&amp;gt; | null) // nullable {@link NullableListMap#getObjects() objects}
   *    .map(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link NullableListMap#getMap() map}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableListMap builder
   */
  public static ImmutableNullableListMap.Builder builder() {
    return new ImmutableNullableListMap.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableListMap ImmutableNullableListMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableListMap", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Object object;
    private ImmutableList.Builder<Object> objects = null;
    private ImmutableMap.Builder<String, String> map = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableNullableListMap} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableNullableListMap instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Object objectValue = instance.getObject();
      if (objectValue != null) {
        object(objectValue);
      }
      @Nullable List<Object> objectsValue = instance.getObjects();
      if (objectsValue != null) {
        addAllObjects(objectsValue);
      }
      @Nullable Map<String, String> mapValue = instance.getMap();
      if (mapValue != null) {
        putAllMap(mapValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableListMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableListMap instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableNullableListMap) {
        return from((ModifiableNullableListMap) instance);
      }
      @Nullable Object objectValue = instance.getObject();
      if (objectValue != null) {
        object(objectValue);
      }
      @Nullable List<Object> objectsValue = instance.getObjects();
      if (objectsValue != null) {
        addAllObjects(objectsValue);
      }
      @Nullable Map<String, String> mapValue = instance.getMap();
      if (mapValue != null) {
        putAllMap(mapValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableListMap#getObject() object} attribute.
     * @param object The value for object (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder object(@Nullable Object object) {
      this.object = object;
      return this;
    }

    /**
     * Adds one element to {@link NullableListMap#getObjects() objects} list.
     * @param element A objects element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjects(Object element) {
      if (this.objects == null) {
        this.objects = ImmutableList.builder();
      }
      this.objects.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NullableListMap#getObjects() objects} list.
     * @param elements An array of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjects(Object... elements) {
      if (this.objects == null) {
        this.objects = ImmutableList.builder();
      }
      this.objects.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NullableListMap#getObjects() objects} list.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder objects(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.objects = null;
        return this;
      }
      this.objects = ImmutableList.builder();
      return addAllObjects(elements);
    }

    /**
     * Adds elements to {@link NullableListMap#getObjects() objects} list.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjects(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "objects element");
      if (this.objects == null) {
        this.objects = ImmutableList.builder();
      }
      this.objects.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link NullableListMap#getMap() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, String value) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NullableListMap#getMap() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends String> entry) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NullableListMap#getMap() map} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder map(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.map = null;
        return this;
      }
      this.map = ImmutableMap.builder();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NullableListMap#getMap() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends String> entries) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableListMap ImmutableNullableListMap}.
     * @return An immutable instance of NullableListMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableListMap build() {
      return new ImmutableNullableListMap(object, objects == null ? null : objects.build(), map == null ? null : map.build());
    }
  }
}
