package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VoidSetters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVoidSetters.builder()}.
 */
@Generated(from = "VoidSetters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableVoidSetters implements VoidSetters {
  private final int aa;
  private final String bb;
  private final ImmutableList<Double> cc;

  private ImmutableVoidSetters(int aa, String bb, ImmutableList<Double> cc) {
    this.aa = aa;
    this.bb = bb;
    this.cc = cc;
  }

  /**
   * @return The value of the {@code aa} attribute
   */
  @Override
  public int getAa() {
    return aa;
  }

  /**
   * @return The value of the {@code bb} attribute
   */
  @Override
  public String getBb() {
    return bb;
  }

  /**
   * @return The value of the {@code cc} attribute
   */
  @Override
  public ImmutableList<Double> getCc() {
    return cc;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoidSetters#getAa() aa} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aa
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVoidSetters withAa(int value) {
    if (this.aa == value) return this;
    return new ImmutableVoidSetters(value, this.bb, this.cc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoidSetters#getBb() bb} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bb
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVoidSetters withBb(String value) {
    String newValue = Objects.requireNonNull(value, "bb");
    if (this.bb.equals(newValue)) return this;
    return new ImmutableVoidSetters(this.aa, newValue, this.cc);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VoidSetters#getCc() cc}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVoidSetters withCc(double... elements) {
    ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
    return new ImmutableVoidSetters(this.aa, this.bb, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VoidSetters#getCc() cc}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of cc elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVoidSetters withCc(Iterable<Double> elements) {
    if (this.cc == elements) return this;
    ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
    return new ImmutableVoidSetters(this.aa, this.bb, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVoidSetters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVoidSetters
        && equalTo(0, (ImmutableVoidSetters) another);
  }

  private boolean equalTo(int synthetic, ImmutableVoidSetters another) {
    return aa == another.aa
        && bb.equals(another.bb)
        && cc.equals(another.cc);
  }

  /**
   * Computes a hash code from attributes: {@code aa}, {@code bb}, {@code cc}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + aa;
    h += (h << 5) + bb.hashCode();
    h += (h << 5) + cc.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VoidSetters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("VoidSetters")
        .omitNullValues()
        .add("aa", aa)
        .add("bb", bb)
        .add("cc", cc)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link VoidSetters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VoidSetters instance
   */
  public static ImmutableVoidSetters copyOf(VoidSetters instance) {
    if (instance instanceof ImmutableVoidSetters) {
      return (ImmutableVoidSetters) instance;
    }
    return ImmutableVoidSetters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVoidSetters ImmutableVoidSetters}.
   * <pre>
   * ImmutableVoidSetters.builder()
   *    .aa(int) // required {@link VoidSetters#getAa() aa}
   *    .bb(String) // required {@link VoidSetters#getBb() bb}
   *    .addCc|addAllCc(double) // {@link VoidSetters#getCc() cc} elements
   *    .build();
   * </pre>
   * @return A new ImmutableVoidSetters builder
   */
  public static ImmutableVoidSetters.Builder builder() {
    return new ImmutableVoidSetters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVoidSetters ImmutableVoidSetters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VoidSetters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_AA = 0x1L;
    private static final long INIT_BIT_BB = 0x2L;
    private long initBits = 0x3L;

    private int aa;
    private @Nullable String bb;
    private ImmutableList.Builder<Double> cc = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableVoidSetters} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableVoidSetters instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.aaIsSet()) {
        aa(instance.getAa());
      }
      if (instance.bbIsSet()) {
        bb(instance.getBb());
      }
      addAllCc(instance.getCc());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code VoidSetters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(VoidSetters instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableVoidSetters) {
        return from((ModifiableVoidSetters) instance);
      }
      aa(instance.getAa());
      bb(instance.getBb());
      addAllCc(instance.getCc());
      return this;
    }

    /**
     * Initializes the value for the {@link VoidSetters#getAa() aa} attribute.
     * @param aa The value for aa 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder aa(int aa) {
      this.aa = aa;
      initBits &= ~INIT_BIT_AA;
      return this;
    }

    /**
     * Initializes the value for the {@link VoidSetters#getBb() bb} attribute.
     * @param bb The value for bb 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bb(String bb) {
      this.bb = Objects.requireNonNull(bb, "bb");
      initBits &= ~INIT_BIT_BB;
      return this;
    }

    /**
     * Adds one element to {@link VoidSetters#getCc() cc} list.
     * @param element A cc element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCc(double element) {
      this.cc.add(element);
      return this;
    }

    /**
     * Adds elements to {@link VoidSetters#getCc() cc} list.
     * @param elements An array of cc elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCc(double... elements) {
      this.cc.addAll(Doubles.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link VoidSetters#getCc() cc} list.
     * @param elements An iterable of cc elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cc(Iterable<Double> elements) {
      this.cc = ImmutableList.builder();
      return addAllCc(elements);
    }

    /**
     * Adds elements to {@link VoidSetters#getCc() cc} list.
     * @param elements An iterable of cc elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCc(Iterable<Double> elements) {
      this.cc.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableVoidSetters ImmutableVoidSetters}.
     * @return An immutable instance of VoidSetters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVoidSetters build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVoidSetters(aa, bb, cc.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AA) != 0) attributes.add("aa");
      if ((initBits & INIT_BIT_BB) != 0) attributes.add("bb");
      return "Cannot build VoidSetters, some of required attributes are not set " + attributes;
    }
  }
}
