package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Floats;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WithModifiableInterface}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWithModifiableInterface.builder()}.
 */
@Generated(from = "WithModifiableInterface", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableWithModifiableInterface
    extends WithModifiableInterface {
  private final ImmutableList<Float> prices;
  private final ImmutableList<Float> pricesWithSalesTax;

  private ImmutableWithModifiableInterface(
      ImmutableList<Float> prices,
      ImmutableList<Float> pricesWithSalesTax) {
    this.prices = prices;
    this.pricesWithSalesTax = pricesWithSalesTax;
  }

  /**
   * @return The value of the {@code prices} attribute
   */
  @Override
  public ImmutableList<Float> getPrices() {
    return prices;
  }

  /**
   * @return The value of the {@code pricesWithSalesTax} attribute
   */
  @Override
  ImmutableList<Float> getPricesWithSalesTax() {
    return pricesWithSalesTax;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithModifiableInterface#getPrices() prices}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithModifiableInterface withPrices(float... elements) {
    ImmutableList<Float> newValue = ImmutableList.copyOf(Floats.asList(elements));
    return new ImmutableWithModifiableInterface(newValue, this.pricesWithSalesTax);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithModifiableInterface#getPrices() prices}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of prices elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithModifiableInterface withPrices(Iterable<Float> elements) {
    if (this.prices == elements) return this;
    ImmutableList<Float> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWithModifiableInterface(newValue, this.pricesWithSalesTax);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithModifiableInterface#getPricesWithSalesTax() pricesWithSalesTax}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithModifiableInterface withPricesWithSalesTax(float... elements) {
    ImmutableList<Float> newValue = ImmutableList.copyOf(Floats.asList(elements));
    return new ImmutableWithModifiableInterface(this.prices, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WithModifiableInterface#getPricesWithSalesTax() pricesWithSalesTax}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pricesWithSalesTax elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithModifiableInterface withPricesWithSalesTax(Iterable<Float> elements) {
    if (this.pricesWithSalesTax == elements) return this;
    ImmutableList<Float> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWithModifiableInterface(this.prices, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWithModifiableInterface} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWithModifiableInterface
        && equalTo(0, (ImmutableWithModifiableInterface) another);
  }

  private boolean equalTo(int synthetic, ImmutableWithModifiableInterface another) {
    return prices.equals(another.prices)
        && pricesWithSalesTax.equals(another.pricesWithSalesTax);
  }

  /**
   * Computes a hash code from attributes: {@code prices}, {@code pricesWithSalesTax}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + prices.hashCode();
    h += (h << 5) + pricesWithSalesTax.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WithModifiableInterface} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WithModifiableInterface")
        .omitNullValues()
        .add("prices", prices)
        .add("pricesWithSalesTax", pricesWithSalesTax)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link WithModifiableInterface} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WithModifiableInterface instance
   */
  public static ImmutableWithModifiableInterface copyOf(WithModifiableInterface instance) {
    if (instance instanceof ImmutableWithModifiableInterface) {
      return (ImmutableWithModifiableInterface) instance;
    }
    return ImmutableWithModifiableInterface.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWithModifiableInterface ImmutableWithModifiableInterface}.
   * <pre>
   * ImmutableWithModifiableInterface.builder()
   *    .addPrices|addAllPrices(float) // {@link WithModifiableInterface#getPrices() prices} elements
   *    .addPricesWithSalesTax|addAllPricesWithSalesTax(float) // {@link WithModifiableInterface#getPricesWithSalesTax() pricesWithSalesTax} elements
   *    .build();
   * </pre>
   * @return A new ImmutableWithModifiableInterface builder
   */
  public static ImmutableWithModifiableInterface.Builder builder() {
    return new ImmutableWithModifiableInterface.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWithModifiableInterface ImmutableWithModifiableInterface}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WithModifiableInterface", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Float> prices = ImmutableList.builder();
    private ImmutableList.Builder<Float> pricesWithSalesTax = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableWithModifiableInterface} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableWithModifiableInterface instance) {
      Objects.requireNonNull(instance, "instance");
      addAllPrices(instance.getPrices());
      addAllPricesWithSalesTax(instance.getPricesWithSalesTax());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code WithModifiableInterface} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WithModifiableInterface instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableWithModifiableInterface) {
        return from((ModifiableWithModifiableInterface) instance);
      }
      addAllPrices(instance.getPrices());
      addAllPricesWithSalesTax(instance.getPricesWithSalesTax());
      return this;
    }

    /**
     * Adds one element to {@link WithModifiableInterface#getPrices() prices} list.
     * @param element A prices element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPrices(float element) {
      this.prices.add(element);
      return this;
    }

    /**
     * Adds elements to {@link WithModifiableInterface#getPrices() prices} list.
     * @param elements An array of prices elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPrices(float... elements) {
      this.prices.addAll(Floats.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WithModifiableInterface#getPrices() prices} list.
     * @param elements An iterable of prices elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder prices(Iterable<Float> elements) {
      this.prices = ImmutableList.builder();
      return addAllPrices(elements);
    }

    /**
     * Adds elements to {@link WithModifiableInterface#getPrices() prices} list.
     * @param elements An iterable of prices elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPrices(Iterable<Float> elements) {
      this.prices.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link WithModifiableInterface#getPricesWithSalesTax() pricesWithSalesTax} list.
     * @param element A pricesWithSalesTax element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPricesWithSalesTax(float element) {
      this.pricesWithSalesTax.add(element);
      return this;
    }

    /**
     * Adds elements to {@link WithModifiableInterface#getPricesWithSalesTax() pricesWithSalesTax} list.
     * @param elements An array of pricesWithSalesTax elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPricesWithSalesTax(float... elements) {
      this.pricesWithSalesTax.addAll(Floats.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WithModifiableInterface#getPricesWithSalesTax() pricesWithSalesTax} list.
     * @param elements An iterable of pricesWithSalesTax elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pricesWithSalesTax(Iterable<Float> elements) {
      this.pricesWithSalesTax = ImmutableList.builder();
      return addAllPricesWithSalesTax(elements);
    }

    /**
     * Adds elements to {@link WithModifiableInterface#getPricesWithSalesTax() pricesWithSalesTax} list.
     * @param elements An iterable of pricesWithSalesTax elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPricesWithSalesTax(Iterable<Float> elements) {
      this.pricesWithSalesTax.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableWithModifiableInterface ImmutableWithModifiableInterface}.
     * @return An immutable instance of WithModifiableInterface
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWithModifiableInterface build() {
      return new ImmutableWithModifiableInterface(prices.build(), pricesWithSalesTax.build());
    }
  }
}
