package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link ToImmutableCopyFalse.C C} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableC is not thread-safe</em>
 * @see ImmutableC
 */
@Generated(from = "ToImmutableCopyFalse.C", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "ToImmutableCopyFalse.C"})
@NotThreadSafe
public final class ModifiableC implements ToImmutableCopyFalse.C {
  private static final long INIT_BIT_C = 0x1L;
  private long initBits = 0x1L;

  private int c;

  private ModifiableC() {}

  /**
   * Construct a modifiable instance of {@code C}.
   * @param c The value for the {@link ToImmutableCopyFalse.C#c() c} attribute 
   * @return A new modifiable instance
   */
  public static ModifiableC create(int c) {
    return new ModifiableC()
        .setC(c);
  }

  /**
   * Construct a modifiable instance of {@code C}.
   * @return A new modifiable instance
   */
  public static ModifiableC create() {
    return new ModifiableC();
  }

  /**
   * @return value of {@code c} attribute
   */
  @Override
  public final int c() {
    if (!cIsSet()) {
      checkRequiredAttributes();
    }
    return c;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableC clear() {
    initBits = 0x1L;
    c = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ToImmutableCopyFalse.C} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableC from(ToImmutableCopyFalse.C instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableC) {
      from((ModifiableC) instance);
      return this;
    }
    setC(instance.c());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ToImmutableCopyFalse.C} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableC from(ModifiableC instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.cIsSet()) {
      setC(instance.c());
    }
    return this;
  }

  /**
   * Assigns a value to the {@link ToImmutableCopyFalse.C#c() c} attribute.
   * @param c The value for c
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableC setC(int c) {
    this.c = c;
    initBits &= ~INIT_BIT_C;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link ToImmutableCopyFalse.C#c() c} is set.
   * @return {@code true} if set
   */
  public final boolean cIsSet() {
    return (initBits & INIT_BIT_C) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableC unsetC() {
    initBits |= INIT_BIT_C;
    c = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!cIsSet()) attributes.add("c");
    return "C is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableC ImmutableC}.
   * @return An immutable instance of C
   */
  public final ImmutableC toImmutable() {
    checkRequiredAttributes();
    return ImmutableC.of(c());
  }

  /**
   * This instance is equal to all instances of {@code ModifiableC} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableC)) return false;
    ModifiableC other = (ModifiableC) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableC another) {
    return c == another.c;
  }

  /**
   * Computes a hash code from attributes: {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + c;
    return h;
  }

  /**
   * Generates a string representation of this {@code C}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableC")
        .add("c", cIsSet() ? c() : "?")
        .toString();
  }
}
