package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Companion.Extra Extra} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableExtra is not thread-safe</em>
 */
@Generated(from = "Companion.Extra", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Companion.Extra"})
@NotThreadSafe
public final class ModifiableExtra implements Companion.Extra {
  private final HashMultiset<String> bag = HashMultiset.create();
  private final ArrayListMultimap<Integer, String> index = ArrayListMultimap.create();
  private final ArrayListMultimap<Integer, String> indexList = ArrayListMultimap.create();
  private final HashMultimap<Integer, String> indexSet = HashMultimap.create();
  private final HashBiMap<Integer, String> biMap = HashBiMap.create();

  private ModifiableExtra() {}

  /**
   * Construct a modifiable instance of {@code Extra}.
   * @param bag The value for the {@code bag} attribute 
   * @param index The value for the {@code index} attribute 
   * @param indexList The value for the {@code indexList} attribute 
   * @param indexSet The value for the {@code indexSet} attribute 
   * @param biMap The value for the {@code biMap} attribute 
   * @return A new modifiable instance
   */
  public static ModifiableExtra create(Iterable<String> bag,
    Multimap<Integer, ? extends String> index,
    Multimap<Integer, ? extends String> indexList,
    Multimap<Integer, ? extends String> indexSet,
    Map<Integer, ? extends String> biMap) {
    return new ModifiableExtra()
        .addAllBag(bag)
        .putAllIndex(index)
        .putAllIndexList(indexList)
        .putAllIndexSet(indexSet)
        .putAllBiMap(biMap);
  }

  /**
   * Construct a modifiable instance of {@code Extra}.
   * @return A new modifiable instance
   */
  public static ModifiableExtra create() {
    return new ModifiableExtra();
  }

  /**
   * @return modifiable multiset {@code bag}
   */
  @Override
  public final Multiset<String> bag() {
    return bag;
  }

  /**
   * @return value of {@code index} attribute
   */
  @Override
  public final Multimap<Integer, String> index() {
    return index;
  }

  /**
   * @return value of {@code indexList} attribute
   */
  @Override
  public final ListMultimap<Integer, String> indexList() {
    return indexList;
  }

  /**
   * @return value of {@code indexSet} attribute
   */
  @Override
  public final SetMultimap<Integer, String> indexSet() {
    return indexSet;
  }

  /**
   * @return value of {@code biMap} attribute
   */
  @Override
  public final BiMap<Integer, String> biMap() {
    return biMap;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra clear() {
    bag.clear();
    index.clear();
    indexList.clear();
    indexSet.clear();
    biMap.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.Extra} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableExtra from(Companion.Extra instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableExtra) {
      from((ModifiableExtra) instance);
      return this;
    }
    addAllBag(instance.bag());
    putAllIndex(instance.index());
    putAllIndexList(instance.indexList());
    putAllIndexSet(instance.indexSet());
    putAllBiMap(instance.biMap());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.Extra} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableExtra from(ModifiableExtra instance) {
    Objects.requireNonNull(instance, "instance");
    addAllBag(instance.bag());
    putAllIndex(instance.index());
    putAllIndexList(instance.indexList());
    putAllIndexSet(instance.indexSet());
    putAllBiMap(instance.biMap());
    return this;
  }

  /**
   * Adds one element to {@code bag} multiset.
   * @param element The bag element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra addBag(String element) {
    Objects.requireNonNull(element, "bag element");
    this.bag.add(element);
    return this;
  }

  /**
   * Adds elements to {@code bag} multiset.
   * @param elements An array of bag elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableExtra addBag(String... elements) {
    for (String e : elements) {
      addBag(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@code bag} multiset.
   * @param elements An iterable of bag elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra setBag(Iterable<String> elements) {
    this.bag.clear();
    addAllBag(elements);
    return this;
  }

  /**
   * Adds elements to {@code bag} multiset.
   * @param elements An iterable of bag elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra addAllBag(Iterable<String> elements) {
    for (String e : elements) {
      addBag(e);
    }
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@code index} true. Nulls are not permitted
   * @param key The key for index
   * @param values The values for index
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableExtra putIndex(int key, String... values) {
    putAllIndex(key, Arrays.asList(values));
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@code index} true. Nulls are not permitted
   * @param key The key for index
   * @param values The values for index
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putAllIndex(int key, Iterable<String> values) {
    for (String v : values) {
      this.index.put(
          Objects.requireNonNull(key, "index key"),
          Objects.requireNonNull(v, "index value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@code index} map.
   * @param key The key in index map
   * @param value The associated value in the index map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putIndex(int key, String value) {
    this.index.put(
        key,
        Objects.requireNonNull(value, "index value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@code index} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the index map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra setIndex(Multimap<Integer, ? extends String> entries) {
    this.index.clear();
    for (Map.Entry<Integer, ? extends String> e : entries.entries()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.index.put(
          Objects.requireNonNull(k, "index key"),
          Objects.requireNonNull(v, "index value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@code index} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to index map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putAllIndex(Multimap<Integer, ? extends String> entries) {
    for (Map.Entry<Integer, ? extends String> e : entries.entries()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.index.put(
          Objects.requireNonNull(k, "index key"),
          Objects.requireNonNull(v, "index value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@code indexList} true. Nulls are not permitted
   * @param key The key for indexList
   * @param values The values for indexList
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableExtra putIndexList(int key, String... values) {
    putAllIndexList(key, Arrays.asList(values));
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@code indexList} true. Nulls are not permitted
   * @param key The key for indexList
   * @param values The values for indexList
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putAllIndexList(int key, Iterable<String> values) {
    for (String v : values) {
      this.indexList.put(
          Objects.requireNonNull(key, "indexList key"),
          Objects.requireNonNull(v, "indexList value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@code indexList} map.
   * @param key The key in indexList map
   * @param value The associated value in the indexList map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putIndexList(int key, String value) {
    this.indexList.put(
        key,
        Objects.requireNonNull(value, "indexList value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@code indexList} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the indexList map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra setIndexList(Multimap<Integer, ? extends String> entries) {
    this.indexList.clear();
    for (Map.Entry<Integer, ? extends String> e : entries.entries()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.indexList.put(
          Objects.requireNonNull(k, "indexList key"),
          Objects.requireNonNull(v, "indexList value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@code indexList} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to indexList map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putAllIndexList(Multimap<Integer, ? extends String> entries) {
    for (Map.Entry<Integer, ? extends String> e : entries.entries()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.indexList.put(
          Objects.requireNonNull(k, "indexList key"),
          Objects.requireNonNull(v, "indexList value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@code indexSet} true. Nulls are not permitted
   * @param key The key for indexSet
   * @param values The values for indexSet
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableExtra putIndexSet(int key, String... values) {
    putAllIndexSet(key, Arrays.asList(values));
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@code indexSet} true. Nulls are not permitted
   * @param key The key for indexSet
   * @param values The values for indexSet
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putAllIndexSet(int key, Iterable<String> values) {
    for (String v : values) {
      this.indexSet.put(
          Objects.requireNonNull(key, "indexSet key"),
          Objects.requireNonNull(v, "indexSet value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@code indexSet} map.
   * @param key The key in indexSet map
   * @param value The associated value in the indexSet map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putIndexSet(int key, String value) {
    this.indexSet.put(
        key,
        Objects.requireNonNull(value, "indexSet value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@code indexSet} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the indexSet map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra setIndexSet(Multimap<Integer, ? extends String> entries) {
    this.indexSet.clear();
    for (Map.Entry<Integer, ? extends String> e : entries.entries()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.indexSet.put(
          Objects.requireNonNull(k, "indexSet key"),
          Objects.requireNonNull(v, "indexSet value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@code indexSet} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to indexSet map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putAllIndexSet(Multimap<Integer, ? extends String> entries) {
    for (Map.Entry<Integer, ? extends String> e : entries.entries()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.indexSet.put(
          Objects.requireNonNull(k, "indexSet key"),
          Objects.requireNonNull(v, "indexSet value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@code biMap} map.
   * @param key The key in biMap map
   * @param value The associated value in the biMap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putBiMap(int key, String value) {
    this.biMap.put(
        key,
        Objects.requireNonNull(value, "biMap value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@code biMap} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the biMap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra setBiMap(Map<Integer, ? extends String> entries) {
    this.biMap.clear();
    for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.biMap.put(
          Objects.requireNonNull(k, "biMap key"),
          Objects.requireNonNull(v, "biMap value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@code biMap} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to biMap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableExtra putAllBiMap(Map<Integer, ? extends String> entries) {
    for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.biMap.put(
          Objects.requireNonNull(k, "biMap key"),
          Objects.requireNonNull(v, "biMap value"));
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * This instance is equal to all instances of {@code ModifiableExtra} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableExtra)) return false;
    ModifiableExtra other = (ModifiableExtra) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableExtra another) {
    return bag.equals(another.bag)
        && index.equals(another.index)
        && indexList.equals(another.indexList)
        && indexSet.equals(another.indexSet)
        && biMap.equals(another.biMap);
  }

  /**
   * Computes a hash code from attributes: {@code bag}, {@code index}, {@code indexList}, {@code indexSet}, {@code biMap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + bag.hashCode();
    h += (h << 5) + index.hashCode();
    h += (h << 5) + indexList.hashCode();
    h += (h << 5) + indexSet.hashCode();
    h += (h << 5) + biMap.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Extra}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableExtra")
        .add("bag", bag())
        .add("index", index())
        .add("indexList", indexList())
        .add("indexSet", indexSet())
        .add("biMap", biMap())
        .toString();
  }
}
