package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link FromTypesModifiables.FromType FromType} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableFromType is not thread-safe</em>
 * @see ImmutableFromType
 */
@Generated(from = "FromTypesModifiables.FromType", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "FromTypesModifiables.FromType"})
@NotThreadSafe
public final class ModifiableFromType
    implements FromTypesModifiables.FromType {
  private static final long INIT_BIT_A = 0x1L;
  private long initBits = 0x1L;

  private int a;

  private ModifiableFromType() {}

  /**
   * Construct a modifiable instance of {@code FromType}.
   * @return A new modifiable instance
   */
  public static ModifiableFromType create() {
    return new ModifiableFromType();
  }

  /**
   * @return value of {@code a} attribute
   */
  @Override
  public final int a() {
    if (!aIsSet()) {
      checkRequiredAttributes();
    }
    return a;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFromType clear() {
    initBits = 0x1L;
    a = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FromTypesModifiables.FromType} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFromType mergeFrom(FromTypesModifiables.FromType instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableFromType) {
      mergeFrom((ModifiableFromType) instance);
      return this;
    }
    setA(instance.a());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FromTypesModifiables.FromType} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFromType mergeFrom(ModifiableFromType instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.aIsSet()) {
      setA(instance.a());
    }
    return this;
  }

  /**
   * Assigns a value to the {@link FromTypesModifiables.FromType#a() a} attribute.
   * @param a The value for a
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFromType setA(int a) {
    this.a = a;
    initBits &= ~INIT_BIT_A;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link FromTypesModifiables.FromType#a() a} is set.
   * @return {@code true} if set
   */
  public final boolean aIsSet() {
    return (initBits & INIT_BIT_A) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableFromType unsetA() {
    initBits |= INIT_BIT_A;
    a = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aIsSet()) attributes.add("a");
    return "FromType is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableFromType ImmutableFromType}.
   * @return An immutable instance of FromType
   */
  public final ImmutableFromType toImmutable() {
    checkRequiredAttributes();
    return ImmutableFromType.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableFromType} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableFromType)) return false;
    ModifiableFromType other = (ModifiableFromType) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableFromType another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Generates a string representation of this {@code FromType}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableFromType")
        .add("a", aIsSet() ? a() : "?")
        .toString();
  }
}
