package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link GenericHolder GenericHolder} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableGenericHolder is not thread-safe</em>
 * @param <T> generic parameter T
 * @see ImmutableGenericHolder
 */
@Generated(from = "GenericHolder", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "GenericHolder"})
@NotThreadSafe
public final class ModifiableGenericHolder<T> implements GenericHolder<T> {
  private static final long INIT_BIT_MANDATORY = 0x1L;
  private long initBits = 0x1L;

  private T mandatory;
  private @Nullable T optional;

  private ModifiableGenericHolder() {}

  /**
   * Construct a modifiable instance of {@code GenericHolder}.
   * @param <T> generic parameter T
   * @return A new modifiable instance
   */
  public static <T> ModifiableGenericHolder<T> create() {
    return new ModifiableGenericHolder<>();
  }

  /**
   * @return value of {@code mandatory} attribute
   */
  @Override
  public final T mandatory() {
    if (!mandatoryIsSet()) {
      checkRequiredAttributes();
    }
    return mandatory;
  }

  /**
   * @return value of {@code optional} attribute, may be {@code null}
   */
  @Override
  public final @Nullable T optional() {
    return optional;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericHolder<T> clear() {
    initBits = 0x1L;
    mandatory = null;
    optional = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link GenericHolder} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableGenericHolder<T> from(GenericHolder<T> instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableGenericHolder<?>) {
      from((ModifiableGenericHolder<T>) instance);
      return this;
    }
    setMandatory(instance.mandatory());
    @Nullable T optionalValue = instance.optional();
    if (optionalValue != null) {
      setOptional(optionalValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link GenericHolder} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableGenericHolder<T> from(ModifiableGenericHolder<T> instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.mandatoryIsSet()) {
      setMandatory(instance.mandatory());
    }
    @Nullable T optionalValue = instance.optional();
    if (optionalValue != null) {
      setOptional(optionalValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link GenericHolder#mandatory() mandatory} attribute.
   * @param mandatory The value for mandatory
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericHolder<T> setMandatory(T mandatory) {
    this.mandatory = Objects.requireNonNull(mandatory, "mandatory");
    initBits &= ~INIT_BIT_MANDATORY;
    return this;
  }

  /**
   * Assigns a value to the {@link GenericHolder#optional() optional} attribute.
   * @param optional The value for optional, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericHolder<T> setOptional(@Nullable T optional) {
    this.optional = optional;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link GenericHolder#mandatory() mandatory} is set.
   * @return {@code true} if set
   */
  public final boolean mandatoryIsSet() {
    return (initBits & INIT_BIT_MANDATORY) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableGenericHolder<T> unsetMandatory() {
    initBits |= INIT_BIT_MANDATORY;
    mandatory = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!mandatoryIsSet()) attributes.add("mandatory");
    return "GenericHolder is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableGenericHolder ImmutableGenericHolder}.
   * @return An immutable instance of GenericHolder
   */
  public final ImmutableGenericHolder<T> toImmutable() {
    checkRequiredAttributes();
    return ImmutableGenericHolder.<T>copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableGenericHolder<?>} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableGenericHolder<?>)) return false;
    ModifiableGenericHolder<?> other = (ModifiableGenericHolder<?>) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableGenericHolder<?> another) {
    return mandatory.equals(another.mandatory)
        && Objects.equals(optional, another.optional);
  }

  /**
   * Computes a hash code from attributes: {@code mandatory}, {@code optional}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + mandatory.hashCode();
    h += (h << 5) + Objects.hashCode(optional);
    return h;
  }

  /**
   * Generates a string representation of this {@code GenericHolder}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableGenericHolder")
        .add("mandatory", mandatoryIsSet() ? mandatory() : "?")
        .add("optional", optional())
        .toString();
  }
}
