package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link VoidSetters VoidSetters} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableVoidSetters is not thread-safe</em>
 * @see ImmutableVoidSetters
 */
@Generated(from = "VoidSetters", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "VoidSetters"})
@NotThreadSafe
public class ModifiableVoidSetters implements VoidSetters {
  private static final long INIT_BIT_AA = 0x1L;
  private static final long INIT_BIT_BB = 0x2L;
  private long initBits = 0x3L;

  private int aa;
  private String bb;
  private List<Double> cc = new ArrayList<Double>();

  /**
   * @return value of {@code aa} attribute
   */
  @Override
  public int getAa() {
    if (!aaIsSet()) {
      checkRequiredAttributes();
    }
    return aa;
  }

  /**
   * @return value of {@code bb} attribute
   */
  @Override
  public String getBb() {
    if (!bbIsSet()) {
      checkRequiredAttributes();
    }
    return bb;
  }

  /**
   * @return modifiable list {@code cc}
   */
  @Override
  public List<Double> getCc() {
    return cc;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    initBits = 0x3L;
    aa = 0;
    bb = null;
    cc.clear();
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link VoidSetters} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVoidSetters from(VoidSetters instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableVoidSetters) {
      from((ModifiableVoidSetters) instance);
      return this;
    }
    setAa(instance.getAa());
    setBb(instance.getBb());
    addAllCc(instance.getCc());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link VoidSetters} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableVoidSetters from(ModifiableVoidSetters instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.aaIsSet()) {
      setAa(instance.getAa());
    }
    if (instance.bbIsSet()) {
      setBb(instance.getBb());
    }
    addAllCc(instance.getCc());
    return this;
  }

  /**
   * Assigns a value to the {@link VoidSetters#getAa() aa} attribute.
   * @param aa The value for aa
   */
  public void setAa(int aa) {
    this.aa = aa;
    initBits &= ~INIT_BIT_AA;
    return;
  }

  /**
   * Assigns a value to the {@link VoidSetters#getBb() bb} attribute.
   * @param bb The value for bb
   */
  public void setBb(String bb) {
    this.bb = Objects.requireNonNull(bb, "bb");
    initBits &= ~INIT_BIT_BB;
    return;
  }

  /**
   * Adds one element to {@link VoidSetters#getCc() cc} list.
   * @param element The cc element
   */
  public void addCc(double element) {
    this.cc.add(element);
    return;
  }

  /**
   * Adds elements to {@link VoidSetters#getCc() cc} list.
   * @param elements An array of cc elements
   */
  public final void addCc(double... elements) {
    for (double e : elements) {
      addCc(Objects.requireNonNull(e, "cc element"));
    }
    return;
  }

  /**
   * Sets or replaces all elements for {@link VoidSetters#getCc() cc} list.
   * @param elements An iterable of cc elements
   */
  public void setCc(List<Double> elements) {
    this.cc = Objects.requireNonNull(elements, "elements");
    return;
  }

  /**
   * Adds elements to {@link VoidSetters#getCc() cc} list.
   * @param elements An iterable of cc elements
   */
  public void addAllCc(Iterable<Double> elements) {
    for (double e : elements) {
      addCc(e);
    }
    return;
  }

  /**
   * Returns {@code true} if the required attribute {@link VoidSetters#getAa() aa} is set.
   * @return {@code true} if set
   */
  public final boolean aaIsSet() {
    return (initBits & INIT_BIT_AA) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link VoidSetters#getBb() bb} is set.
   * @return {@code true} if set
   */
  public final boolean bbIsSet() {
    return (initBits & INIT_BIT_BB) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetAa() {
    initBits |= INIT_BIT_AA;
    aa = 0;
    return;
  }

  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetBb() {
    initBits |= INIT_BIT_BB;
    bb = null;
    return;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aaIsSet()) attributes.add("aa");
    if (!bbIsSet()) attributes.add("bb");
    return "VoidSetters is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableVoidSetters ImmutableVoidSetters}.
   * @return An immutable instance of VoidSetters
   */
  public final ImmutableVoidSetters toImmutable() {
    checkRequiredAttributes();
    return ImmutableVoidSetters.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableVoidSetters} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableVoidSetters)) return false;
    ModifiableVoidSetters other = (ModifiableVoidSetters) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableVoidSetters another) {
    return aa == another.aa
        && bb.equals(another.bb)
        && cc.equals(another.cc);
  }

  /**
   * Computes a hash code from attributes: {@code aa}, {@code bb}, {@code cc}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + aa;
    h += (h << 5) + bb.hashCode();
    h += (h << 5) + cc.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code VoidSetters}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableVoidSetters")
        .add("aa", aaIsSet() ? getAa() : "?")
        .add("bb", bbIsSet() ? getBb() : "?")
        .add("cc", getCc())
        .toString();
  }
}
