package org.immutables.fixture.nested;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code NonGrouped}.
 * @see ImmutableAbra
 * @see ImmutableBuagra
 * @see ImmutableCadabra
 * @see ImmutableDabra
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.nested", generator = "Gsons")
public final class GsonAdaptersNonGrouped implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (AbraTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new AbraTypeAdapter(gson);
    }
    if (BuagraTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new BuagraTypeAdapter(gson);
    }
    if (CadabraTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new CadabraTypeAdapter(gson);
    }
    if (DabraTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new DabraTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersNonGrouped(Abra, Buagra, Cadabra, Dabra)";
  }

  @org.immutables.value.Generated(from = "NonGrouped.Abra", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class AbraTypeAdapter extends TypeAdapter<NonGrouped.Abra> {

    AbraTypeAdapter(Gson gson) {}

    static boolean adapts(TypeToken<?> type) {
      return NonGrouped.Abra.class == type.getRawType()
          || ImmutableAbra.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, NonGrouped.Abra value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeAbra(out, value);
      }
    }

    @Override
    public NonGrouped.Abra read(JsonReader in) throws IOException {
      return readAbra(in);
    }

    private void writeAbra(JsonWriter out, NonGrouped.Abra instance)
        throws IOException {
      out.beginObject();
      out.endObject();
    }

    private static NonGrouped.Abra readAbra(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableAbra.Builder builder = ImmutableAbra.builder();
      in.skipValue();
      return builder.build();
    }
  }

  @org.immutables.value.Generated(from = "NonGrouped.Buagra", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class BuagraTypeAdapter extends TypeAdapter<NonGrouped.Buagra> {

    BuagraTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return NonGrouped.Buagra.class == type.getRawType()
          || ImmutableBuagra.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, NonGrouped.Buagra value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeBuagra(out, value);
      }
    }

    @Override
    public NonGrouped.Buagra read(JsonReader in) throws IOException {
      return readBuagra(in);
    }

    private void writeBuagra(JsonWriter out, NonGrouped.Buagra instance)
        throws IOException {
      @Nullable String buagraValue = instance.buagra();
      if (buagraValue != null) {
        out.value(buagraValue);
      } else {
        out.nullValue();
      }
    }

    private  NonGrouped.Buagra readBuagra(JsonReader in)
        throws IOException {
      return ImmutableBuagra.of(readParameterBuagra(in));
    }

    private  @Nullable String readParameterBuagra(JsonReader in)
        throws IOException {
      JsonToken t = in.peek();
      if (t == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      String value = in.nextString();
      return value;
    }
  }

  @org.immutables.value.Generated(from = "NonGrouped.Cadabra", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class CadabraTypeAdapter extends TypeAdapter<NonGrouped.Cadabra> {

    CadabraTypeAdapter(Gson gson) {}

    static boolean adapts(TypeToken<?> type) {
      return NonGrouped.Cadabra.class == type.getRawType()
          || ImmutableCadabra.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, NonGrouped.Cadabra value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeCadabra(out, value);
      }
    }

    @Override
    public NonGrouped.Cadabra read(JsonReader in) throws IOException {
      return readCadabra(in);
    }

    private void writeCadabra(JsonWriter out, NonGrouped.Cadabra instance)
        throws IOException {
      out.beginObject();
      out.endObject();
    }

    private NonGrouped.Cadabra readCadabra(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      in.skipValue();
      return ImmutableCadabra.of();
    }
  }

  @org.immutables.value.Generated(from = "NonGrouped.Dabra", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class DabraTypeAdapter extends TypeAdapter<NonGrouped.Dabra> {

    DabraTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return NonGrouped.Dabra.class == type.getRawType()
          || ImmutableDabra.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, NonGrouped.Dabra value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeDabra(out, value);
      }
    }

    @Override
    public NonGrouped.Dabra read(JsonReader in) throws IOException {
      return readDabra(in);
    }

    private void writeDabra(JsonWriter out, NonGrouped.Dabra instance)
        throws IOException {
      out.value(instance.dabra());
    }

    private static NonGrouped.Dabra readDabra(JsonReader in)
        throws IOException {
      return ImmutableDabra.of(readParameterDabra(in));
    }

    private static int readParameterDabra(JsonReader in)
        throws IOException {
      return in.nextInt();
    }
  }
}
