package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableGroupedClasses} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link GroupedClasses}.
 * @see ImmutableGroupedClasses.NestedOne
 */
@Generated(from = "GroupedClasses", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableGroupedClasses {
  private ImmutableGroupedClasses() {}

  /**
   * Immutable implementation of {@link GroupedClasses.NestedOne}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableGroupedClasses.NestedOne.builder()}.
   */
  @Generated(from = "GroupedClasses.NestedOne", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class NestedOne implements GroupedClasses.NestedOne {
    private final Optional<GroupedClasses.Other> other;

    private NestedOne(Optional<GroupedClasses.Other> other) {
      this.other = other;
    }

    /**
     * @return The value of the {@code other} attribute
     */
    @Override
    public Optional<GroupedClasses.Other> other() {
      return other;
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GroupedClasses.NestedOne#other() other} attribute.
     * @param value The value for other
     * @return A modified copy of {@code this} object
     */
    public final ImmutableGroupedClasses.NestedOne withOther(GroupedClasses.Other value) {
      Optional<GroupedClasses.Other> newValue = Optional.of(value);
      if (this.other.isPresent() && this.other.get() == value) return this;
      return new ImmutableGroupedClasses.NestedOne(newValue);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link GroupedClasses.NestedOne#other() other} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for other
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableGroupedClasses.NestedOne withOther(Optional<? extends GroupedClasses.Other> optional) {
      Optional<GroupedClasses.Other> value = (Optional<GroupedClasses.Other>) optional;
      if (!this.other.isPresent() && !value.isPresent()) return this;
      if (this.other.isPresent() && value.isPresent() && this.other.get() == value.get()) return this;
      return new ImmutableGroupedClasses.NestedOne(value);
    }

    /**
     * This instance is equal to all instances of {@code NestedOne} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableGroupedClasses.NestedOne
          && equalTo(0, (ImmutableGroupedClasses.NestedOne) another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupedClasses.NestedOne another) {
      return other.equals(another.other);
    }

    /**
     * Computes a hash code from attributes: {@code other}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + other.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code NestedOne} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("NestedOne")
          .omitNullValues()
          .add("other", other.orNull())
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link GroupedClasses.NestedOne} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable NestedOne instance
     */
    public static ImmutableGroupedClasses.NestedOne copyOf(GroupedClasses.NestedOne instance) {
      if (instance instanceof ImmutableGroupedClasses.NestedOne) {
        return (ImmutableGroupedClasses.NestedOne) instance;
      }
      return ImmutableGroupedClasses.NestedOne.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableGroupedClasses.NestedOne NestedOne}.
     * <pre>
     * ImmutableGroupedClasses.NestedOne.builder()
     *    .other(org.immutables.fixture.nested.GroupedClasses.Other) // optional {@link GroupedClasses.NestedOne#other() other}
     *    .build();
     * </pre>
     * @return A new NestedOne builder
     */
    public static ImmutableGroupedClasses.NestedOne.Builder builder() {
      return new ImmutableGroupedClasses.NestedOne.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableGroupedClasses.NestedOne NestedOne}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "GroupedClasses.NestedOne", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private Optional<GroupedClasses.Other> other = Optional.absent();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code NestedOne} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(GroupedClasses.NestedOne instance) {
        Objects.requireNonNull(instance, "instance");
        Optional<GroupedClasses.Other> otherOptional = instance.other();
        if (otherOptional.isPresent()) {
          other(otherOptional);
        }
        return this;
      }

      /**
       * Initializes the optional value {@link GroupedClasses.NestedOne#other() other} to other.
       * @param other The value for other
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder other(GroupedClasses.Other other) {
        this.other = Optional.of(other);
        return this;
      }

      /**
       * Initializes the optional value {@link GroupedClasses.NestedOne#other() other} to other.
       * @param other The value for other
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      @CanIgnoreReturnValue 
      public final Builder other(Optional<? extends GroupedClasses.Other> other) {
        this.other = (Optional<GroupedClasses.Other>) other;
        return this;
      }

      /**
       * Builds a new {@link ImmutableGroupedClasses.NestedOne NestedOne}.
       * @return An immutable instance of NestedOne
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableGroupedClasses.NestedOne build() {
        return new ImmutableGroupedClasses.NestedOne(other);
      }
    }
  }
}
