package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableInheritEnclosing} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link InheritEnclosing}.
 * @see ImmutableInheritEnclosing.Impl
 * @see ImmutableInheritEnclosing.Impl2
 * @see ImmutableInheritEnclosing.Impl3
 * @see ImmutableInheritEnclosing.Impl4
 */
@Generated(from = "InheritEnclosing", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableInheritEnclosing {
  private ImmutableInheritEnclosing() {}

  /**
   * Immutable implementation of {@link InheritEnclosing.Impl}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInheritEnclosing.Impl.builder()}.
   */
  @Generated(from = "InheritEnclosing.Impl", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Impl implements InheritEnclosing.Impl {
    private final int value;

    private Impl(int value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public int value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link InheritEnclosing.Impl#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableInheritEnclosing.Impl withValue(int value) {
      if (this.value == value) return this;
      return new ImmutableInheritEnclosing.Impl(value);
    }

    /**
     * This instance is equal to all instances of {@code Impl} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInheritEnclosing.Impl
          && equalTo(0, (ImmutableInheritEnclosing.Impl) another);
    }

    private boolean equalTo(int synthetic, ImmutableInheritEnclosing.Impl another) {
      return value == another.value;
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + value;
      return h;
    }

    /**
     * Prints the immutable value {@code Impl} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Impl")
          .omitNullValues()
          .add("value", value)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link InheritEnclosing.Impl} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Impl instance
     */
    public static ImmutableInheritEnclosing.Impl copyOf(InheritEnclosing.Impl instance) {
      if (instance instanceof ImmutableInheritEnclosing.Impl) {
        return (ImmutableInheritEnclosing.Impl) instance;
      }
      return ImmutableInheritEnclosing.Impl.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInheritEnclosing.Impl Impl}.
     * <pre>
     * ImmutableInheritEnclosing.Impl.builder()
     *    .value(int) // required {@link InheritEnclosing.Impl#value() value}
     *    .build();
     * </pre>
     * @return A new Impl builder
     */
    public static ImmutableInheritEnclosing.Impl.Builder builder() {
      return new ImmutableInheritEnclosing.Impl.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInheritEnclosing.Impl Impl}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "InheritEnclosing.Impl", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_VALUE = 0x1L;
      private long initBits = 0x1L;

      private int value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Impl} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(InheritEnclosing.Impl instance) {
        Objects.requireNonNull(instance, "instance");
        value(instance.value());
        return this;
      }

      /**
       * Initializes the value for the {@link InheritEnclosing.Impl#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(int value) {
        this.value = value;
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableInheritEnclosing.Impl Impl}.
       * @return An immutable instance of Impl
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInheritEnclosing.Impl build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableInheritEnclosing.Impl(value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build Impl, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link InheritEnclosing.Impl2}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInheritEnclosing.Impl2.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableInheritEnclosing.Impl2.of()}.
   */
  @Generated(from = "InheritEnclosing.Impl2", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Impl2 implements InheritEnclosing.Impl2 {
    private final int value;

    private Impl2(int value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public int value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link InheritEnclosing.Impl2#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableInheritEnclosing.Impl2 withValue(int value) {
      if (this.value == value) return this;
      return new ImmutableInheritEnclosing.Impl2(value);
    }

    /**
     * This instance is equal to all instances of {@code Impl2} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInheritEnclosing.Impl2
          && equalTo(0, (ImmutableInheritEnclosing.Impl2) another);
    }

    private boolean equalTo(int synthetic, ImmutableInheritEnclosing.Impl2 another) {
      return value == another.value;
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + value;
      return h;
    }

    /**
     * Prints the immutable value {@code Impl2} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Impl2")
          .omitNullValues()
          .add("value", value)
          .toString();
    }

    /**
     * Construct a new immutable {@code Impl2} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable Impl2 instance
     */
    public static ImmutableInheritEnclosing.Impl2 of(int value) {
      return new ImmutableInheritEnclosing.Impl2(value);
    }

    /**
     * Creates an immutable copy of a {@link InheritEnclosing.Impl2} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Impl2 instance
     */
    public static ImmutableInheritEnclosing.Impl2 copyOf(InheritEnclosing.Impl2 instance) {
      if (instance instanceof ImmutableInheritEnclosing.Impl2) {
        return (ImmutableInheritEnclosing.Impl2) instance;
      }
      return ImmutableInheritEnclosing.Impl2.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInheritEnclosing.Impl2 Impl2}.
     * <pre>
     * ImmutableInheritEnclosing.Impl2.builder()
     *    .value(int) // required {@link InheritEnclosing.Impl2#value() value}
     *    .build();
     * </pre>
     * @return A new Impl2 builder
     */
    public static ImmutableInheritEnclosing.Impl2.Builder builder() {
      return new ImmutableInheritEnclosing.Impl2.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInheritEnclosing.Impl2 Impl2}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "InheritEnclosing.Impl2", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_VALUE = 0x1L;
      private long initBits = 0x1L;

      private int value;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Impl2} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(InheritEnclosing.Impl2 instance) {
        Objects.requireNonNull(instance, "instance");
        value(instance.value());
        return this;
      }

      /**
       * Initializes the value for the {@link InheritEnclosing.Impl2#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(int value) {
        this.value = value;
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableInheritEnclosing.Impl2 Impl2}.
       * @return An immutable instance of Impl2
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInheritEnclosing.Impl2 build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableInheritEnclosing.Impl2(value);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build Impl2, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link InheritEnclosing.Impl3}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInheritEnclosing.Impl3.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableInheritEnclosing.Impl3.of()}.
   */
  @Generated(from = "InheritEnclosing.Impl3", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Impl3 implements InheritEnclosing.Impl3 {
    private final int value;
    private final ImmutableList<Boolean> bools;

    private Impl3(int value, Iterable<Boolean> bools) {
      this.value = value;
      this.bools = ImmutableList.copyOf(bools);
    }

    private Impl3(
        ImmutableInheritEnclosing.Impl3 original,
        int value,
        ImmutableList<Boolean> bools) {
      this.value = value;
      this.bools = bools;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public int value() {
      return value;
    }

    /**
     * @return The value of the {@code bools} attribute
     */
    @Override
    public ImmutableList<Boolean> bools() {
      return bools;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link InheritEnclosing.Impl3#value() value} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableInheritEnclosing.Impl3 withValue(int value) {
      if (this.value == value) return this;
      return new ImmutableInheritEnclosing.Impl3(this, value, this.bools);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link InheritEnclosing.Impl3#bools() bools}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInheritEnclosing.Impl3 withBools(boolean... elements) {
      ImmutableList<Boolean> newValue = ImmutableList.copyOf(Booleans.asList(elements));
      return new ImmutableInheritEnclosing.Impl3(this, this.value, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link InheritEnclosing.Impl3#bools() bools}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of bools elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableInheritEnclosing.Impl3 withBools(Iterable<Boolean> elements) {
      if (this.bools == elements) return this;
      ImmutableList<Boolean> newValue = ImmutableList.copyOf(elements);
      return new ImmutableInheritEnclosing.Impl3(this, this.value, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Impl3} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInheritEnclosing.Impl3
          && equalTo(0, (ImmutableInheritEnclosing.Impl3) another);
    }

    private boolean equalTo(int synthetic, ImmutableInheritEnclosing.Impl3 another) {
      return value == another.value
          && bools.equals(another.bools);
    }

    /**
     * Computes a hash code from attributes: {@code value}, {@code bools}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + value;
      h += (h << 5) + bools.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Impl3} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Impl3")
          .omitNullValues()
          .add("value", value)
          .add("bools", bools)
          .toString();
    }

    /**
     * Construct a new immutable {@code Impl3} instance.
     * @param value The value for the {@code value} attribute
     * @param bools The value for the {@code bools} attribute
     * @return An immutable Impl3 instance
     */
    public static ImmutableInheritEnclosing.Impl3 of(int value, List<Boolean> bools) {
      return of(value, (Iterable<Boolean>) bools);
    }

    /**
     * Construct a new immutable {@code Impl3} instance.
     * @param value The value for the {@code value} attribute
     * @param bools The value for the {@code bools} attribute
     * @return An immutable Impl3 instance
     */
    public static ImmutableInheritEnclosing.Impl3 of(int value, Iterable<Boolean> bools) {
      return new ImmutableInheritEnclosing.Impl3(value, bools);
    }

    /**
     * Creates an immutable copy of a {@link InheritEnclosing.Impl3} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Impl3 instance
     */
    public static ImmutableInheritEnclosing.Impl3 copyOf(InheritEnclosing.Impl3 instance) {
      if (instance instanceof ImmutableInheritEnclosing.Impl3) {
        return (ImmutableInheritEnclosing.Impl3) instance;
      }
      return ImmutableInheritEnclosing.Impl3.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInheritEnclosing.Impl3 Impl3}.
     * <pre>
     * ImmutableInheritEnclosing.Impl3.builder()
     *    .value(int) // required {@link InheritEnclosing.Impl3#value() value}
     *    .addBools|addAllBools(boolean) // {@link InheritEnclosing.Impl3#bools() bools} elements
     *    .build();
     * </pre>
     * @return A new Impl3 builder
     */
    public static ImmutableInheritEnclosing.Impl3.Builder builder() {
      return new ImmutableInheritEnclosing.Impl3.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInheritEnclosing.Impl3 Impl3}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "InheritEnclosing.Impl3", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_VALUE = 0x1L;
      private long initBits = 0x1L;

      private int value;
      private ImmutableList.Builder<Boolean> bools = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Impl3} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(InheritEnclosing.Impl3 instance) {
        Objects.requireNonNull(instance, "instance");
        value(instance.value());
        addAllBools(instance.bools());
        return this;
      }

      /**
       * Initializes the value for the {@link InheritEnclosing.Impl3#value() value} attribute.
       * @param value The value for value 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder value(int value) {
        this.value = value;
        initBits &= ~INIT_BIT_VALUE;
        return this;
      }

      /**
       * Adds one element to {@link InheritEnclosing.Impl3#bools() bools} list.
       * @param element A bools element
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder addBools(boolean element) {
        this.bools.add(element);
        return this;
      }

      /**
       * Adds elements to {@link InheritEnclosing.Impl3#bools() bools} list.
       * @param elements An array of bools elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder addBools(boolean... elements) {
        this.bools.addAll(Booleans.asList(elements));
        return this;
      }


      /**
       * Sets or replaces all elements for {@link InheritEnclosing.Impl3#bools() bools} list.
       * @param elements An iterable of bools elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder bools(Iterable<Boolean> elements) {
        this.bools = ImmutableList.builder();
        return addAllBools(elements);
      }

      /**
       * Adds elements to {@link InheritEnclosing.Impl3#bools() bools} list.
       * @param elements An iterable of bools elements
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder addAllBools(Iterable<Boolean> elements) {
        this.bools.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableInheritEnclosing.Impl3 Impl3}.
       * @return An immutable instance of Impl3
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInheritEnclosing.Impl3 build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableInheritEnclosing.Impl3(null, value, bools.build());
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
        return "Cannot build Impl3, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link InheritEnclosing.Impl4}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInheritEnclosing.Impl4.builder()}.
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableInheritEnclosing.Impl4.of()}.
   */
  @Generated(from = "InheritEnclosing.Impl4", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Impl4 implements InheritEnclosing.Impl4 {

    private Impl4() {}

    /**
     * This instance is equal to all instances of {@code Impl4} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInheritEnclosing.Impl4
          && equalTo(0, (ImmutableInheritEnclosing.Impl4) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, ImmutableInheritEnclosing.Impl4 another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 597453237;
    }

    /**
     * Prints the immutable value {@code Impl4}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Impl4{}";
    }

    private static final ImmutableInheritEnclosing.Impl4 INSTANCE = validate(new ImmutableInheritEnclosing.Impl4());

    /**
     * Returns the default immutable singleton value of {@code Impl4}
     * @return An immutable instance of Impl4
     */
    public static ImmutableInheritEnclosing.Impl4 of() {
      return INSTANCE;
    }

    private static ImmutableInheritEnclosing.Impl4 validate(ImmutableInheritEnclosing.Impl4 instance) {
      return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    /**
     * Creates an immutable copy of a {@link InheritEnclosing.Impl4} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Impl4 instance
     */
    public static ImmutableInheritEnclosing.Impl4 copyOf(InheritEnclosing.Impl4 instance) {
      if (instance instanceof ImmutableInheritEnclosing.Impl4) {
        return (ImmutableInheritEnclosing.Impl4) instance;
      }
      return ImmutableInheritEnclosing.Impl4.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInheritEnclosing.Impl4 Impl4}.
     * <pre>
     * ImmutableInheritEnclosing.Impl4.builder()
     *    .build();
     * </pre>
     * @return A new Impl4 builder
     */
    public static ImmutableInheritEnclosing.Impl4.Builder builder() {
      return new ImmutableInheritEnclosing.Impl4.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInheritEnclosing.Impl4 Impl4}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "InheritEnclosing.Impl4", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Impl4} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(InheritEnclosing.Impl4 instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableInheritEnclosing.Impl4 Impl4}.
       * @return An immutable instance of Impl4
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInheritEnclosing.Impl4 build() {
        return ImmutableInheritEnclosing.Impl4.of();
      }
    }
  }
}
