package org.immutables.fixture.nested;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InnerNested}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInnerNested.builder()}.
 */
@Generated(from = "InnerNested", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInnerNested implements InnerNested {

  private ImmutableInnerNested(ImmutableInnerNested.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInnerNested} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInnerNested
        && equalTo(0, (ImmutableInnerNested) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableInnerNested another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1938187725;
  }

  /**
   * Prints the immutable value {@code InnerNested}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InnerNested{}";
  }

  /**
   * Creates an immutable copy of a {@link InnerNested} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InnerNested instance
   */
  public static ImmutableInnerNested copyOf(InnerNested instance) {
    if (instance instanceof ImmutableInnerNested) {
      return (ImmutableInnerNested) instance;
    }
    return ImmutableInnerNested.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInnerNested ImmutableInnerNested}.
   * <pre>
   * ImmutableInnerNested.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableInnerNested builder
   */
  public static ImmutableInnerNested.Builder builder() {
    return new ImmutableInnerNested.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInnerNested ImmutableInnerNested}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InnerNested", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InnerNested} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InnerNested instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableInnerNested ImmutableInnerNested}.
     * @return An immutable instance of InnerNested
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInnerNested build() {
      return new ImmutableInnerNested(this);
    }
  }

  /**
   * Immutable implementation of {@link InnerNested.Inner}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInnerNested.Inner.builder()}.
   */
  @Generated(from = "InnerNested.Inner", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Inner extends InnerNested.Inner {

    private Inner(ImmutableInnerNested.Inner.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code Inner} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInnerNested.Inner
          && equalTo(0, (ImmutableInnerNested.Inner) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, ImmutableInnerNested.Inner another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 1402615317;
    }

    /**
     * Prints the immutable value {@code Inner}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Inner{}";
    }

    /**
     * Creates an immutable copy of a {@link InnerNested.Inner} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Inner instance
     */
    public static ImmutableInnerNested.Inner copyOf(InnerNested.Inner instance) {
      if (instance instanceof ImmutableInnerNested.Inner) {
        return (ImmutableInnerNested.Inner) instance;
      }
      return ImmutableInnerNested.Inner.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInnerNested.Inner Inner}.
     * <pre>
     * ImmutableInnerNested.Inner.builder()
     *    .build();
     * </pre>
     * @return A new Inner builder
     */
    public static ImmutableInnerNested.Inner.Builder builder() {
      return new ImmutableInnerNested.Inner.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInnerNested.Inner Inner}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "InnerNested.Inner", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Inner} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(InnerNested.Inner instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableInnerNested.Inner Inner}.
       * @return An immutable instance of Inner
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInnerNested.Inner build() {
        return new ImmutableInnerNested.Inner(this);
      }
    }
  }

  /**
   * Immutable implementation of {@link InnerNested.Nested}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableInnerNested.Nested.builder()}.
   */
  @Generated(from = "InnerNested.Nested", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Nested implements InnerNested.Nested {

    private Nested(ImmutableInnerNested.Nested.Builder builder) {
    }

    /**
     * This instance is equal to all instances of {@code Nested} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableInnerNested.Nested
          && equalTo(0, (ImmutableInnerNested.Nested) another);
    }

    @SuppressWarnings("MethodCanBeStatic")
    private boolean equalTo(int synthetic, ImmutableInnerNested.Nested another) {
      return true;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 666398070;
    }

    /**
     * Prints the immutable value {@code Nested}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Nested{}";
    }

    /**
     * Creates an immutable copy of a {@link InnerNested.Nested} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Nested instance
     */
    public static ImmutableInnerNested.Nested copyOf(InnerNested.Nested instance) {
      if (instance instanceof ImmutableInnerNested.Nested) {
        return (ImmutableInnerNested.Nested) instance;
      }
      return ImmutableInnerNested.Nested.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableInnerNested.Nested Nested}.
     * <pre>
     * ImmutableInnerNested.Nested.builder()
     *    .build();
     * </pre>
     * @return A new Nested builder
     */
    public static ImmutableInnerNested.Nested.Builder builder() {
      return new ImmutableInnerNested.Nested.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableInnerNested.Nested Nested}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "InnerNested.Nested", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Nested} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(InnerNested.Nested instance) {
        Objects.requireNonNull(instance, "instance");
        return this;
      }

      /**
       * Builds a new {@link ImmutableInnerNested.Nested Nested}.
       * @return An immutable instance of Nested
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableInnerNested.Nested build() {
        return new ImmutableInnerNested.Nested(this);
      }
    }
  }
}
