package org.immutables.fixture.nullable;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code NullableAttributes}.
 * @see ImmutableNullableAttributes
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.nullable", generator = "Gsons")
public final class GsonAdaptersNullableAttributes implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (NullableAttributesTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new NullableAttributesTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersNullableAttributes(NullableAttributes)";
  }

  @org.immutables.value.Generated(from = "NullableAttributes", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class NullableAttributesTypeAdapter extends TypeAdapter<NullableAttributes> {
    public final Integer integerTypeSample = null;
    public final Integer setTypeSample = null;
    public final Integer arrayTypeSample = null;
    public final Double defArrayTypeSample = null;
    public final Object mapSecondaryTypeSample = null;
    private final TypeAdapter<Integer> integerTypeAdapter;
    private final TypeAdapter<Integer> setTypeAdapter;
    private final TypeAdapter<Integer> arrayTypeAdapter;
    private final TypeAdapter<Double> defArrayTypeAdapter;
    private final TypeAdapter<Object> mapSecondaryTypeAdapter;

    NullableAttributesTypeAdapter(Gson gson) {
      this.integerTypeAdapter = gson.getAdapter( Integer.class);
      this.setTypeAdapter = gson.getAdapter( Integer.class);
      this.arrayTypeAdapter = gson.getAdapter( Integer.class);
      this.defArrayTypeAdapter = gson.getAdapter( Double.class);
      this.mapSecondaryTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return NullableAttributes.class == type.getRawType()
          || ImmutableNullableAttributes.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, NullableAttributes value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeNullableAttributes(out, value);
      }
    }

    @Override
    public NullableAttributes read(JsonReader in) throws IOException {
      return readNullableAttributes(in);
    }

    private void writeNullableAttributes(JsonWriter out, NullableAttributes instance)
        throws IOException {
      out.beginObject();
      @Nullable Integer integerValue = instance.integer();
      if (integerValue != null) {
        out.name("integer");
        integerTypeAdapter.write(out, integerValue);
      } else if (out.getSerializeNulls()) {
        out.name("integer");
        out.nullValue();
      }
      @Nullable List<String> listElements = instance.list();
      if (listElements != null) {
        out.name("list");
        out.beginArray();
        for (String e : listElements) {
          out.value(e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("list");
        out.nullValue();
      }
      @Nullable Set<Integer> setElements = instance.set();
      if (setElements != null) {
        out.name("set");
        out.beginArray();
        for (Integer e : setElements) {
          setTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("set");
        out.nullValue();
      }
      @Nullable Integer[] arrayElements = instance.array();
      if (arrayElements != null) {
        out.name("array");
        out.beginArray();
        for (Integer e : arrayElements) {
          arrayTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("array");
        out.nullValue();
      }
      @Nullable Double[] defArrayElements = instance.defArray();
      if (defArrayElements != null) {
        out.name("defArray");
        out.beginArray();
        for (Double e : defArrayElements) {
          defArrayTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("defArray");
        out.nullValue();
      }
      @Nullable Map<String, Object> mapMapping = instance.map();
      if (mapMapping != null) {
        out.name("map");
        out.beginObject();
        for (Map.Entry<String, Object> e : mapMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          Object value = e.getValue();
          mapSecondaryTypeAdapter.write(out, value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("map");
        out.nullValue();
      }
      out.endObject();
    }

    private  NullableAttributes readNullableAttributes(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableNullableAttributes.Builder builder = ImmutableNullableAttributes.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableNullableAttributes.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("integer".equals(attributeName)) {
          readInInteger(in, builder);
          return;
        }
        break;
      case 'l':
        if ("list".equals(attributeName)) {
          readInList(in, builder);
          return;
        }
        break;
      case 's':
        if ("set".equals(attributeName)) {
          readInSet(in, builder);
          return;
        }
        break;
      case 'a':
        if ("array".equals(attributeName)) {
          readInArray(in, builder);
          return;
        }
        break;
      case 'd':
        if ("defArray".equals(attributeName)) {
          readInDefArray(in, builder);
          return;
        }
        break;
      case 'm':
        if ("map".equals(attributeName)) {
          readInMap(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInInteger(JsonReader in, ImmutableNullableAttributes.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = integerTypeAdapter.read(in);
        builder.integer(value);
      }
    }

    private void readInList(JsonReader in, ImmutableNullableAttributes.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            builder.addList(in.nextString());
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          builder.addList(in.nextString());
          empty = false;
        }
        if (empty) {
          builder.addAllList(Collections.<String>emptyList());
        }
      }
    }

    private void readInSet(JsonReader in, ImmutableNullableAttributes.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        builder.set(null);
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            builder.addSet(in.nextInt());
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          builder.addSet(in.nextInt());
          empty = false;
        }
        if (empty) {
          builder.addAllSet(Collections.<Integer>emptyList());
        }
      }
    }

    private void readInArray(JsonReader in, ImmutableNullableAttributes.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        List<Integer> elements = new ArrayList<Integer>();
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            Integer value = arrayTypeAdapter.read(in);
            elements.add(value);
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          Integer value = arrayTypeAdapter.read(in);
          elements.add(value);
        }
        builder.array(elements.toArray(new Integer[elements.size()]));
      }
    }

    private void readInDefArray(JsonReader in, ImmutableNullableAttributes.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        builder.defArray(null);
      } else {
        List<Double> elements = new ArrayList<Double>();
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            Double value = defArrayTypeAdapter.read(in);
            elements.add(value);
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          Double value = defArrayTypeAdapter.read(in);
          elements.add(value);
        }
        builder.defArray(elements.toArray(new Double[elements.size()]));
      }
    }

    private void readInMap(JsonReader in, ImmutableNullableAttributes.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          in.beginObject();
          boolean empty = true;
          while(in.hasNext()) {
            String rawKey = in.nextName();
            String key = rawKey;
            Object value = mapSecondaryTypeAdapter.read(in);
            builder.putMap(key, value);
            empty = false;
          }
          if (empty) {
            builder.putAllMap(Collections.<String, Object>emptyMap());
          }
          in.endObject();
        }
      }
    }
  }
}
