package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableDefault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableDefault.builder()}.
 */
@Generated(from = "NullableDefault", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullableDefault implements NullableDefault {
  private final @Nullable String str;
  private final @Nullable Integer intr;

  private ImmutableNullableDefault(ImmutableNullableDefault.Builder builder) {
    if (builder.strIsSet()) {
      initShim.str(builder.str);
    }
    if (builder.intrIsSet()) {
      initShim.intr(builder.intr);
    }
    this.str = initShim.str();
    this.intr = initShim.intr();
    this.initShim = null;
  }

  private ImmutableNullableDefault(@Nullable String str, @Nullable Integer intr) {
    this.str = str;
    this.intr = intr;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "NullableDefault", generator = "Immutables")
  private final class InitShim {
    private byte strBuildStage = STAGE_UNINITIALIZED;
    private String str;

    String str() {
      if (strBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (strBuildStage == STAGE_UNINITIALIZED) {
        strBuildStage = STAGE_INITIALIZING;
        this.str = strInitialize();
        strBuildStage = STAGE_INITIALIZED;
      }
      return this.str;
    }

    void str(String str) {
      this.str = str;
      strBuildStage = STAGE_INITIALIZED;
    }

    private byte intrBuildStage = STAGE_UNINITIALIZED;
    private Integer intr;

    Integer intr() {
      if (intrBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (intrBuildStage == STAGE_UNINITIALIZED) {
        intrBuildStage = STAGE_INITIALIZING;
        this.intr = intrInitialize();
        intrBuildStage = STAGE_INITIALIZED;
      }
      return this.intr;
    }

    void intr(Integer intr) {
      this.intr = intr;
      intrBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (strBuildStage == STAGE_INITIALIZING) attributes.add("str");
      if (intrBuildStage == STAGE_INITIALIZING) attributes.add("intr");
      return "Cannot build NullableDefault, attribute initializers form cycle " + attributes;
    }
  }

  private @Nullable String strInitialize() {
    return NullableDefault.super.str();
  }

  private @Nullable Integer intrInitialize() {
    return NullableDefault.super.intr();
  }

  /**
   * @return The value of the {@code str} attribute
   */
  @Override
  public @Nullable String str() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.str()
        : this.str;
  }

  /**
   * @return The value of the {@code intr} attribute
   */
  @Override
  public @Nullable Integer intr() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.intr()
        : this.intr;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullableDefault#str() str} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for str (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullableDefault withStr(@Nullable String value) {
    if (Objects.equals(this.str, value)) return this;
    return new ImmutableNullableDefault(value, this.intr);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullableDefault#intr() intr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for intr (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullableDefault withIntr(@Nullable Integer value) {
    if (Objects.equals(this.intr, value)) return this;
    return new ImmutableNullableDefault(this.str, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableDefault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableDefault
        && equalTo(0, (ImmutableNullableDefault) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableDefault another) {
    return Objects.equals(str, another.str)
        && Objects.equals(intr, another.intr);
  }

  /**
   * Computes a hash code from attributes: {@code str}, {@code intr}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(str);
    h += (h << 5) + Objects.hashCode(intr);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableDefault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableDefault")
        .omitNullValues()
        .add("str", str)
        .add("intr", intr)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NullableDefault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableDefault instance
   */
  public static ImmutableNullableDefault copyOf(NullableDefault instance) {
    if (instance instanceof ImmutableNullableDefault) {
      return (ImmutableNullableDefault) instance;
    }
    return ImmutableNullableDefault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableDefault ImmutableNullableDefault}.
   * <pre>
   * ImmutableNullableDefault.builder()
   *    .str(String | null) // nullable {@link NullableDefault#str() str}
   *    .intr(Integer | null) // nullable {@link NullableDefault#intr() intr}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableDefault builder
   */
  public static ImmutableNullableDefault.Builder builder() {
    return new ImmutableNullableDefault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableDefault ImmutableNullableDefault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableDefault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_STR = 0x1L;
    private static final long OPT_BIT_INTR = 0x2L;
    private long optBits;

    private @Nullable String str;
    private @Nullable Integer intr;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableDefault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableDefault instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String strValue = instance.str();
      if (strValue != null) {
        str(strValue);
      }
      @Nullable Integer intrValue = instance.intr();
      if (intrValue != null) {
        intr(intrValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableDefault#str() str} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NullableDefault#str() str}.</em>
     * @param str The value for str (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder str(@Nullable String str) {
      this.str = str;
      optBits |= OPT_BIT_STR;
      return this;
    }

    /**
     * Initializes the value for the {@link NullableDefault#intr() intr} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NullableDefault#intr() intr}.</em>
     * @param intr The value for intr (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder intr(@Nullable Integer intr) {
      this.intr = intr;
      optBits |= OPT_BIT_INTR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableDefault ImmutableNullableDefault}.
     * @return An immutable instance of NullableDefault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableDefault build() {
      return new ImmutableNullableDefault(this);
    }

    private boolean strIsSet() {
      return (optBits & OPT_BIT_STR) != 0;
    }

    private boolean intrIsSet() {
      return (optBits & OPT_BIT_INTR) != 0;
    }
  }
}
