package org.immutables.fixture.ordered;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SortedCollectionWrapper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSortedCollectionWrapper.builder()}.
 */
@Generated(from = "SortedCollectionWrapper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSortedCollectionWrapper
    implements SortedCollectionWrapper {
  private final ImmutableSortedSet<SortedCollectionWrapper.Elem> elemSet;
  private final ImmutableSortedSet<ImmutableElem> immutableElemSet;
  private final ImmutableSortedMultiset<SortedCollectionWrapper.Elem> elemMultiset;
  private final ImmutableSortedMultiset<ImmutableElem> immutableElemMultiset;
  private final ImmutableSortedMap<SortedCollectionWrapper.Elem, Void> elemMap;
  private final ImmutableSortedMap<ImmutableElem, Void> immutableElemMap;

  private ImmutableSortedCollectionWrapper(
      ImmutableSortedSet<SortedCollectionWrapper.Elem> elemSet,
      ImmutableSortedSet<ImmutableElem> immutableElemSet,
      ImmutableSortedMultiset<SortedCollectionWrapper.Elem> elemMultiset,
      ImmutableSortedMultiset<ImmutableElem> immutableElemMultiset,
      ImmutableSortedMap<SortedCollectionWrapper.Elem, Void> elemMap,
      ImmutableSortedMap<ImmutableElem, Void> immutableElemMap) {
    this.elemSet = elemSet;
    this.immutableElemSet = immutableElemSet;
    this.elemMultiset = elemMultiset;
    this.immutableElemMultiset = immutableElemMultiset;
    this.elemMap = elemMap;
    this.immutableElemMap = immutableElemMap;
  }

  /**
   * @return The value of the {@code elemSet} attribute
   */
  @Override
  public ImmutableSortedSet<SortedCollectionWrapper.Elem> getElemSet() {
    return elemSet;
  }

  /**
   * @return The value of the {@code immutableElemSet} attribute
   */
  @Override
  public ImmutableSortedSet<ImmutableElem> getImmutableElemSet() {
    return immutableElemSet;
  }

  /**
   * @return The value of the {@code elemMultiset} attribute
   */
  @Override
  public ImmutableSortedMultiset<SortedCollectionWrapper.Elem> getElemMultiset() {
    return elemMultiset;
  }

  /**
   * @return The value of the {@code immutableElemMultiset} attribute
   */
  @Override
  public ImmutableSortedMultiset<ImmutableElem> getImmutableElemMultiset() {
    return immutableElemMultiset;
  }

  /**
   * @return The value of the {@code elemMap} attribute
   */
  @Override
  public ImmutableSortedMap<SortedCollectionWrapper.Elem, Void> getElemMap() {
    return elemMap;
  }

  /**
   * @return The value of the {@code immutableElemMap} attribute
   */
  @Override
  public ImmutableSortedMap<ImmutableElem, Void> getImmutableElemMap() {
    return immutableElemMap;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getElemSet() elemSet}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withElemSet(SortedCollectionWrapper.Elem... elements) {
    ImmutableSortedSet<SortedCollectionWrapper.Elem> newValue = ImmutableSortedSet.copyOf(
        Ordering.<SortedCollectionWrapper.Elem>natural(),
        Arrays.asList(elements));
    return new ImmutableSortedCollectionWrapper(
        newValue,
        this.immutableElemSet,
        this.elemMultiset,
        this.immutableElemMultiset,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getElemSet() elemSet}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elemSet elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withElemSet(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
    if (this.elemSet == elements) return this;
    ImmutableSortedSet<SortedCollectionWrapper.Elem> newValue = ImmutableSortedSet.copyOf(
        Ordering.<SortedCollectionWrapper.Elem>natural(),
        elements);
    return new ImmutableSortedCollectionWrapper(
        newValue,
        this.immutableElemSet,
        this.elemMultiset,
        this.immutableElemMultiset,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getImmutableElemSet() immutableElemSet}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withImmutableElemSet(ImmutableElem... elements) {
    ImmutableSortedSet<ImmutableElem> newValue = ImmutableSortedSet.copyOf(
        Ordering.<ImmutableElem>natural(),
        Arrays.asList(elements));
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        newValue,
        this.elemMultiset,
        this.immutableElemMultiset,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getImmutableElemSet() immutableElemSet}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of immutableElemSet elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withImmutableElemSet(Iterable<? extends ImmutableElem> elements) {
    if (this.immutableElemSet == elements) return this;
    ImmutableSortedSet<ImmutableElem> newValue = ImmutableSortedSet.copyOf(
        Ordering.<ImmutableElem>natural(),
        elements);
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        newValue,
        this.elemMultiset,
        this.immutableElemMultiset,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getElemMultiset() elemMultiset}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withElemMultiset(SortedCollectionWrapper.Elem... elements) {
    ImmutableSortedMultiset<SortedCollectionWrapper.Elem> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<SortedCollectionWrapper.Elem>natural().reverse(),
        Arrays.asList(elements));
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        this.immutableElemSet,
        newValue,
        this.immutableElemMultiset,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getElemMultiset() elemMultiset}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elemMultiset elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withElemMultiset(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
    if (this.elemMultiset == elements) return this;
    ImmutableSortedMultiset<SortedCollectionWrapper.Elem> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<SortedCollectionWrapper.Elem>natural().reverse(),
        elements);
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        this.immutableElemSet,
        newValue,
        this.immutableElemMultiset,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getImmutableElemMultiset() immutableElemMultiset}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withImmutableElemMultiset(ImmutableElem... elements) {
    ImmutableSortedMultiset<ImmutableElem> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<ImmutableElem>natural().reverse(),
        Arrays.asList(elements));
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        this.immutableElemSet,
        this.elemMultiset,
        newValue,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SortedCollectionWrapper#getImmutableElemMultiset() immutableElemMultiset}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of immutableElemMultiset elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withImmutableElemMultiset(Iterable<? extends ImmutableElem> elements) {
    if (this.immutableElemMultiset == elements) return this;
    ImmutableSortedMultiset<ImmutableElem> newValue = ImmutableSortedMultiset.copyOf(
        Ordering.<ImmutableElem>natural().reverse(),
        elements);
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        this.immutableElemSet,
        this.elemMultiset,
        newValue,
        this.elemMap,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object by replacing the {@link SortedCollectionWrapper#getElemMap() elemMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the elemMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withElemMap(Map<? extends SortedCollectionWrapper.Elem, ? extends Void> entries) {
    if (this.elemMap == entries) return this;
    ImmutableSortedMap<SortedCollectionWrapper.Elem, Void> newValue = ImmutableSortedMap.copyOf(entries,
        Ordering.<SortedCollectionWrapper.Elem>natural()
    );
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        this.immutableElemSet,
        this.elemMultiset,
        this.immutableElemMultiset,
        newValue,
        this.immutableElemMap);
  }

  /**
   * Copy the current immutable object by replacing the {@link SortedCollectionWrapper#getImmutableElemMap() immutableElemMap} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the immutableElemMap map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSortedCollectionWrapper withImmutableElemMap(Map<? extends ImmutableElem, ? extends Void> entries) {
    if (this.immutableElemMap == entries) return this;
    ImmutableSortedMap<ImmutableElem, Void> newValue = ImmutableSortedMap.copyOf(entries,
        Ordering.<ImmutableElem>natural()
    );
    return new ImmutableSortedCollectionWrapper(
        this.elemSet,
        this.immutableElemSet,
        this.elemMultiset,
        this.immutableElemMultiset,
        this.elemMap,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSortedCollectionWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSortedCollectionWrapper
        && equalTo(0, (ImmutableSortedCollectionWrapper) another);
  }

  private boolean equalTo(int synthetic, ImmutableSortedCollectionWrapper another) {
    return elemSet.equals(another.elemSet)
        && immutableElemSet.equals(another.immutableElemSet)
        && elemMultiset.equals(another.elemMultiset)
        && immutableElemMultiset.equals(another.immutableElemMultiset)
        && elemMap.equals(another.elemMap)
        && immutableElemMap.equals(another.immutableElemMap);
  }

  /**
   * Computes a hash code from attributes: {@code elemSet}, {@code immutableElemSet}, {@code elemMultiset}, {@code immutableElemMultiset}, {@code elemMap}, {@code immutableElemMap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + elemSet.hashCode();
    h += (h << 5) + immutableElemSet.hashCode();
    h += (h << 5) + elemMultiset.hashCode();
    h += (h << 5) + immutableElemMultiset.hashCode();
    h += (h << 5) + elemMap.hashCode();
    h += (h << 5) + immutableElemMap.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SortedCollectionWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SortedCollectionWrapper")
        .omitNullValues()
        .add("elemSet", elemSet)
        .add("immutableElemSet", immutableElemSet)
        .add("elemMultiset", elemMultiset)
        .add("immutableElemMultiset", immutableElemMultiset)
        .add("elemMap", elemMap)
        .add("immutableElemMap", immutableElemMap)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SortedCollectionWrapper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SortedCollectionWrapper instance
   */
  public static ImmutableSortedCollectionWrapper copyOf(SortedCollectionWrapper instance) {
    if (instance instanceof ImmutableSortedCollectionWrapper) {
      return (ImmutableSortedCollectionWrapper) instance;
    }
    return ImmutableSortedCollectionWrapper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSortedCollectionWrapper ImmutableSortedCollectionWrapper}.
   * <pre>
   * ImmutableSortedCollectionWrapper.builder()
   *    .addElemSet|addAllElemSet(org.immutables.fixture.ordered.SortedCollectionWrapper.Elem) // {@link SortedCollectionWrapper#getElemSet() elemSet} elements
   *    .addImmutableElemSet|addAllImmutableElemSet(ImmutableElem) // {@link SortedCollectionWrapper#getImmutableElemSet() immutableElemSet} elements
   *    .addElemMultiset|addAllElemMultiset(org.immutables.fixture.ordered.SortedCollectionWrapper.Elem) // {@link SortedCollectionWrapper#getElemMultiset() elemMultiset} elements
   *    .addImmutableElemMultiset|addAllImmutableElemMultiset(ImmutableElem) // {@link SortedCollectionWrapper#getImmutableElemMultiset() immutableElemMultiset} elements
   *    .putElemMap|putAllElemMap(org.immutables.fixture.ordered.SortedCollectionWrapper.Elem =&gt; Void) // {@link SortedCollectionWrapper#getElemMap() elemMap} mappings
   *    .putImmutableElemMap|putAllImmutableElemMap(ImmutableElem =&gt; Void) // {@link SortedCollectionWrapper#getImmutableElemMap() immutableElemMap} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableSortedCollectionWrapper builder
   */
  public static ImmutableSortedCollectionWrapper.Builder builder() {
    return new ImmutableSortedCollectionWrapper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSortedCollectionWrapper ImmutableSortedCollectionWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SortedCollectionWrapper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableSortedSet.Builder<SortedCollectionWrapper.Elem> elemSet = ImmutableSortedSet.naturalOrder();
    private ImmutableSortedSet.Builder<ImmutableElem> immutableElemSet = ImmutableSortedSet.naturalOrder();
    private ImmutableSortedMultiset.Builder<SortedCollectionWrapper.Elem> elemMultiset = ImmutableSortedMultiset.reverseOrder();
    private ImmutableSortedMultiset.Builder<ImmutableElem> immutableElemMultiset = ImmutableSortedMultiset.reverseOrder();
    private ImmutableSortedMap.Builder<SortedCollectionWrapper.Elem, Void> elemMap = ImmutableSortedMap.naturalOrder();
    private ImmutableSortedMap.Builder<ImmutableElem, Void> immutableElemMap = ImmutableSortedMap.naturalOrder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SortedCollectionWrapper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SortedCollectionWrapper instance) {
      Objects.requireNonNull(instance, "instance");
      addAllElemSet(instance.getElemSet());
      addAllImmutableElemSet(instance.getImmutableElemSet());
      addAllElemMultiset(instance.getElemMultiset());
      addAllImmutableElemMultiset(instance.getImmutableElemMultiset());
      putAllElemMap(instance.getElemMap());
      putAllImmutableElemMap(instance.getImmutableElemMap());
      return this;
    }

    /**
     * Adds one element to {@link SortedCollectionWrapper#getElemSet() elemSet} sortedSet.
     * @param element A elemSet element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElemSet(SortedCollectionWrapper.Elem element) {
      this.elemSet.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getElemSet() elemSet} sortedSet.
     * @param elements An array of elemSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElemSet(SortedCollectionWrapper.Elem... elements) {
      this.elemSet.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SortedCollectionWrapper#getElemSet() elemSet} sortedSet.
     * @param elements An iterable of elemSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder elemSet(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
      this.elemSet = ImmutableSortedSet.naturalOrder();
      return addAllElemSet(elements);
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getElemSet() elemSet} sortedSet.
     * @param elements An iterable of elemSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllElemSet(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
      this.elemSet.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link SortedCollectionWrapper#getImmutableElemSet() immutableElemSet} sortedSet.
     * @param element A immutableElemSet element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImmutableElemSet(ImmutableElem element) {
      this.immutableElemSet.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getImmutableElemSet() immutableElemSet} sortedSet.
     * @param elements An array of immutableElemSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImmutableElemSet(ImmutableElem... elements) {
      this.immutableElemSet.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SortedCollectionWrapper#getImmutableElemSet() immutableElemSet} sortedSet.
     * @param elements An iterable of immutableElemSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder immutableElemSet(Iterable<? extends ImmutableElem> elements) {
      this.immutableElemSet = ImmutableSortedSet.naturalOrder();
      return addAllImmutableElemSet(elements);
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getImmutableElemSet() immutableElemSet} sortedSet.
     * @param elements An iterable of immutableElemSet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImmutableElemSet(Iterable<? extends ImmutableElem> elements) {
      this.immutableElemSet.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link SortedCollectionWrapper#getElemMultiset() elemMultiset} sortedMultiset.
     * @param element A elemMultiset element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElemMultiset(SortedCollectionWrapper.Elem element) {
      this.elemMultiset.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getElemMultiset() elemMultiset} sortedMultiset.
     * @param elements An array of elemMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElemMultiset(SortedCollectionWrapper.Elem... elements) {
      this.elemMultiset.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SortedCollectionWrapper#getElemMultiset() elemMultiset} sortedMultiset.
     * @param elements An iterable of elemMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder elemMultiset(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
      this.elemMultiset = ImmutableSortedMultiset.reverseOrder();
      return addAllElemMultiset(elements);
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getElemMultiset() elemMultiset} sortedMultiset.
     * @param elements An iterable of elemMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllElemMultiset(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
      this.elemMultiset.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link SortedCollectionWrapper#getImmutableElemMultiset() immutableElemMultiset} sortedMultiset.
     * @param element A immutableElemMultiset element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImmutableElemMultiset(ImmutableElem element) {
      this.immutableElemMultiset.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getImmutableElemMultiset() immutableElemMultiset} sortedMultiset.
     * @param elements An array of immutableElemMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImmutableElemMultiset(ImmutableElem... elements) {
      this.immutableElemMultiset.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SortedCollectionWrapper#getImmutableElemMultiset() immutableElemMultiset} sortedMultiset.
     * @param elements An iterable of immutableElemMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder immutableElemMultiset(Iterable<? extends ImmutableElem> elements) {
      this.immutableElemMultiset = ImmutableSortedMultiset.reverseOrder();
      return addAllImmutableElemMultiset(elements);
    }

    /**
     * Adds elements to {@link SortedCollectionWrapper#getImmutableElemMultiset() immutableElemMultiset} sortedMultiset.
     * @param elements An iterable of immutableElemMultiset elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImmutableElemMultiset(Iterable<? extends ImmutableElem> elements) {
      this.immutableElemMultiset.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link SortedCollectionWrapper#getElemMap() elemMap} map.
     * @param key The key in the elemMap map
     * @param value The associated value in the elemMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putElemMap(SortedCollectionWrapper.Elem key, Void value) {
      this.elemMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SortedCollectionWrapper#getElemMap() elemMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putElemMap(Map.Entry<? extends SortedCollectionWrapper.Elem, ? extends Void> entry) {
      this.elemMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SortedCollectionWrapper#getElemMap() elemMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the elemMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder elemMap(Map<? extends SortedCollectionWrapper.Elem, ? extends Void> entries) {
      this.elemMap = ImmutableSortedMap.naturalOrder();
      return putAllElemMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SortedCollectionWrapper#getElemMap() elemMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the elemMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllElemMap(Map<? extends SortedCollectionWrapper.Elem, ? extends Void> entries) {
      this.elemMap.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link SortedCollectionWrapper#getImmutableElemMap() immutableElemMap} map.
     * @param key The key in the immutableElemMap map
     * @param value The associated value in the immutableElemMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putImmutableElemMap(ImmutableElem key, Void value) {
      this.immutableElemMap.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SortedCollectionWrapper#getImmutableElemMap() immutableElemMap} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putImmutableElemMap(Map.Entry<? extends ImmutableElem, ? extends Void> entry) {
      this.immutableElemMap.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SortedCollectionWrapper#getImmutableElemMap() immutableElemMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the immutableElemMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder immutableElemMap(Map<? extends ImmutableElem, ? extends Void> entries) {
      this.immutableElemMap = ImmutableSortedMap.naturalOrder();
      return putAllImmutableElemMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SortedCollectionWrapper#getImmutableElemMap() immutableElemMap} map. Nulls are not permitted
     * @param entries The entries that will be added to the immutableElemMap map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllImmutableElemMap(Map<? extends ImmutableElem, ? extends Void> entries) {
      this.immutableElemMap.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSortedCollectionWrapper ImmutableSortedCollectionWrapper}.
     * @return An immutable instance of SortedCollectionWrapper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSortedCollectionWrapper build() {
      return new ImmutableSortedCollectionWrapper(
          elemSet.build(),
          immutableElemSet.build(),
          elemMultiset.build(),
          immutableElemMultiset.build(),
          elemMap.build(),
          immutableElemMap.build());
    }
  }
}
