package org.immutables.fixture.serial;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link SomeSer.OthSer OthSer} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableOthSer is not thread-safe</em>
 * @see ImmutableOthSer
 */
@Generated(from = "SomeSer.OthSer", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "SomeSer.OthSer"})
@NotThreadSafe
final class ModifiableOthSer implements SomeSer.OthSer {


  private ModifiableOthSer() {}

  /**
   * Construct a modifiable instance of {@code OthSer}.
   * @return A new modifiable instance
   */
  public static ModifiableOthSer create() {
    return new ModifiableOthSer();
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableOthSer clear() {
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link SomeSer.OthSer} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableOthSer from(SomeSer.OthSer instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableOthSer) {
      from((ModifiableOthSer) instance);
      return this;
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link SomeSer.OthSer} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableOthSer from(ModifiableOthSer instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableOthSer ImmutableOthSer}.
   * @return An immutable instance of OthSer
   */
  public final ImmutableOthSer toImmutable() {
    return ImmutableOthSer.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableOthSer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableOthSer)) return false;
    ModifiableOthSer other = (ModifiableOthSer) another;
    return equalTo(other);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ModifiableOthSer another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -893863200;
  }

  /**
   * Generates a string representation of this {@code OthSer}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableOthSer{}";
  }
}
