package org.immutables.fixture.strict;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Aar}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAar.builder()}.
 */
@Generated(from = "Aar", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAar implements Aar {
  private final boolean bl;
  private final Integer integer;

  private ImmutableAar(boolean bl, Integer integer) {
    this.bl = bl;
    this.integer = integer;
  }

  /**
   * @return The value of the {@code bl} attribute
   */
  @Override
  public boolean bl() {
    return bl;
  }

  /**
   * @return The value of the {@code integer} attribute
   */
  @Override
  public Integer integer() {
    return integer;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Aar#bl() bl} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAar withBl(boolean value) {
    if (this.bl == value) return this;
    return new ImmutableAar(value, this.integer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Aar#integer() integer} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for integer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAar withInteger(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "integer");
    if (this.integer.equals(newValue)) return this;
    return new ImmutableAar(this.bl, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAar} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAar
        && equalTo(0, (ImmutableAar) another);
  }

  private boolean equalTo(int synthetic, ImmutableAar another) {
    return bl == another.bl
        && integer.equals(another.integer);
  }

  /**
   * Computes a hash code from attributes: {@code bl}, {@code integer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(bl);
    h += (h << 5) + integer.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Aar} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Aar")
        .omitNullValues()
        .add("bl", bl)
        .add("integer", integer)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Aar} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Aar instance
   */
  public static ImmutableAar copyOf(Aar instance) {
    if (instance instanceof ImmutableAar) {
      return (ImmutableAar) instance;
    }
    return ImmutableAar.builder()
        .bl(instance.bl())
        .integer(instance.integer())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAar ImmutableAar}.
   * <pre>
   * ImmutableAar.builder()
   *    .bl(boolean) // required {@link Aar#bl() bl}
   *    .integer(Integer) // required {@link Aar#integer() integer}
   *    .build();
   * </pre>
   * @return A new ImmutableAar builder
   */
  public static ImmutableAar.Builder builder() {
    return new ImmutableAar.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAar ImmutableAar}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Aar", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BL = 0x1L;
    private static final long INIT_BIT_INTEGER = 0x2L;
    private long initBits = 0x3L;

    private boolean bl;
    private @Nullable Integer integer;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link Aar#bl() bl} attribute.
     * @param bl The value for bl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bl(boolean bl) {
      checkNotIsSet(blIsSet(), "bl");
      this.bl = bl;
      initBits &= ~INIT_BIT_BL;
      return this;
    }

    /**
     * Initializes the value for the {@link Aar#integer() integer} attribute.
     * @param integer The value for integer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder integer(Integer integer) {
      checkNotIsSet(integerIsSet(), "integer");
      this.integer = Objects.requireNonNull(integer, "integer");
      initBits &= ~INIT_BIT_INTEGER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAar ImmutableAar}.
     * @return An immutable instance of Aar
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAar build() {
      checkRequiredAttributes();
      return new ImmutableAar(bl, integer);
    }

    private boolean blIsSet() {
      return (initBits & INIT_BIT_BL) == 0;
    }

    private boolean integerIsSet() {
      return (initBits & INIT_BIT_INTEGER) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of Aar is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!blIsSet()) attributes.add("bl");
      if (!integerIsSet()) attributes.add("integer");
      return "Cannot build Aar, some of required attributes are not set " + attributes;
    }
  }
}
