package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Constr.Build}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImBuild.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code new ImBuild()}.
 */
@Generated(from = "Constr.Build", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImBuild implements Constr.Build {
  private final String date;
  private final String qualifier;

  /**
   * Construct a new immutable {@code Build} instance.
   * @param date The value for the {@code date} attribute
   * @param qualifier The value for the {@code qualifier} attribute
   */
  public ImBuild(String date, String qualifier) {
    this.date = Objects.requireNonNull(date, "date");
    this.qualifier = Objects.requireNonNull(qualifier, "qualifier");
  }

  private ImBuild(ImBuild original, String date, String qualifier) {
    this.date = date;
    this.qualifier = qualifier;
  }

  /**
   * @return The value of the {@code date} attribute
   */
  @Override
  public String date() {
    return date;
  }

  /**
   * @return The value of the {@code qualifier} attribute
   */
  @Override
  public String qualifier() {
    return qualifier;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constr.Build#date() date} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for date
   * @return A modified copy of the {@code this} object
   */
  public final ImBuild withDate(String value) {
    String newValue = Objects.requireNonNull(value, "date");
    if (this.date.equals(newValue)) return this;
    return new ImBuild(this, newValue, this.qualifier);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constr.Build#qualifier() qualifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qualifier
   * @return A modified copy of the {@code this} object
   */
  public final ImBuild withQualifier(String value) {
    String newValue = Objects.requireNonNull(value, "qualifier");
    if (this.qualifier.equals(newValue)) return this;
    return new ImBuild(this, this.date, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImBuild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImBuild
        && equalTo(0, (ImBuild) another);
  }

  private boolean equalTo(int synthetic, ImBuild another) {
    return date.equals(another.date)
        && qualifier.equals(another.qualifier);
  }

  /**
   * Computes a hash code from attributes: {@code date}, {@code qualifier}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + date.hashCode();
    h += (h << 5) + qualifier.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Build} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Build")
        .omitNullValues()
        .add("date", date)
        .add("qualifier", qualifier)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Constr.Build} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Build instance
   */
  public static ImBuild copyOf(Constr.Build instance) {
    if (instance instanceof ImBuild) {
      return (ImBuild) instance;
    }
    return ImBuild.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImBuild ImBuild}.
   * <pre>
   * ImBuild.builder()
   *    .date(String) // required {@link Constr.Build#date() date}
   *    .qualifier(String) // required {@link Constr.Build#qualifier() qualifier}
   *    .build();
   * </pre>
   * @return A new ImBuild builder
   */
  public static ImBuild.Builder builder() {
    return new ImBuild.Builder();
  }

  /**
   * Builds instances of type {@link ImBuild ImBuild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Constr.Build", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATE = 0x1L;
    private static final long INIT_BIT_QUALIFIER = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String date;
    private @Nullable String qualifier;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Build} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Constr.Build instance) {
      Objects.requireNonNull(instance, "instance");
      date(instance.date());
      qualifier(instance.qualifier());
      return this;
    }

    /**
     * Initializes the value for the {@link Constr.Build#date() date} attribute.
     * @param date The value for date 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder date(String date) {
      this.date = Objects.requireNonNull(date, "date");
      initBits &= ~INIT_BIT_DATE;
      return this;
    }

    /**
     * Initializes the value for the {@link Constr.Build#qualifier() qualifier} attribute.
     * @param qualifier The value for qualifier 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder qualifier(String qualifier) {
      this.qualifier = Objects.requireNonNull(qualifier, "qualifier");
      initBits &= ~INIT_BIT_QUALIFIER;
      return this;
    }

    /**
     * Builds a new {@link ImBuild ImBuild}.
     * @return An immutable instance of Build
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImBuild build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImBuild(null, date, qualifier);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATE) != 0) attributes.add("date");
      if ((initBits & INIT_BIT_QUALIFIER) != 0) attributes.add("qualifier");
      return "Cannot build Build, some of required attributes are not set " + attributes;
    }
  }
}
