package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IncludeTypes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImIncludeTypes.builder()}.
 */
@Generated(from = "IncludeTypes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImIncludeTypes extends IncludeTypes {

  private ImIncludeTypes(ImIncludeTypes.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImIncludeTypes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImIncludeTypes
        && equalTo(0, (ImIncludeTypes) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImIncludeTypes another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1675099291;
  }

  /**
   * Prints the immutable value {@code IncludeTypes}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IncludeTypes{}";
  }

  /**
   * Creates an immutable copy of a {@link IncludeTypes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IncludeTypes instance
   */
  public static ImIncludeTypes copyOf(IncludeTypes instance) {
    if (instance instanceof ImIncludeTypes) {
      return (ImIncludeTypes) instance;
    }
    return ImIncludeTypes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImIncludeTypes ImIncludeTypes}.
   * <pre>
   * ImIncludeTypes.builder()
   *    .build();
   * </pre>
   * @return A new ImIncludeTypes builder
   */
  public static ImIncludeTypes.Builder builder() {
    return new ImIncludeTypes.Builder();
  }

  /**
   * Builds instances of type {@link ImIncludeTypes ImIncludeTypes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IncludeTypes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IncludeTypes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IncludeTypes instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImIncludeTypes ImIncludeTypes}.
     * @return An immutable instance of IncludeTypes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImIncludeTypes build() {
      return new ImIncludeTypes(this);
    }
  }
}
