package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WeakInterningStyle.GuavaInterner}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGuavaInterner.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableGuavaInterner.of()}.
 */
@Generated(from = "WeakInterningStyle.GuavaInterner", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGuavaInterner
    implements WeakInterningStyle.GuavaInterner {
  private final int a;

  private ImmutableGuavaInterner(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WeakInterningStyle.GuavaInterner#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGuavaInterner withA(int value) {
    if (this.a == value) return this;
    return validate(new ImmutableGuavaInterner(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGuavaInterner} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGuavaInterner
        && equalTo(0, (ImmutableGuavaInterner) another);
  }

  private boolean equalTo(int synthetic, ImmutableGuavaInterner another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code GuavaInterner} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GuavaInterner")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  private static final class InternerHolder {
    static final Interner<ImmutableGuavaInterner> INTERNER = Interners.newWeakInterner();
  }

  /**
   * Construct a new immutable {@code GuavaInterner} instance.
   * @param a The value for the {@code a} attribute
   * @return An immutable GuavaInterner instance
   */
  public static ImmutableGuavaInterner of(int a) {
    return validate(new ImmutableGuavaInterner(a));
  }

  private static ImmutableGuavaInterner validate(ImmutableGuavaInterner instance) {
    return InternerHolder.INTERNER.intern(instance);
  }

  /**
   * Creates an immutable copy of a {@link WeakInterningStyle.GuavaInterner} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GuavaInterner instance
   */
  public static ImmutableGuavaInterner copyOf(WeakInterningStyle.GuavaInterner instance) {
    if (instance instanceof ImmutableGuavaInterner) {
      return (ImmutableGuavaInterner) instance;
    }
    return ImmutableGuavaInterner.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGuavaInterner ImmutableGuavaInterner}.
   * <pre>
   * ImmutableGuavaInterner.builder()
   *    .a(int) // required {@link WeakInterningStyle.GuavaInterner#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableGuavaInterner builder
   */
  public static ImmutableGuavaInterner.Builder builder() {
    return new ImmutableGuavaInterner.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGuavaInterner ImmutableGuavaInterner}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WeakInterningStyle.GuavaInterner", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GuavaInterner} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WeakInterningStyle.GuavaInterner instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link WeakInterningStyle.GuavaInterner#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGuavaInterner ImmutableGuavaInterner}.
     * @return An immutable instance of GuavaInterner
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGuavaInterner build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableGuavaInterner.validate(new ImmutableGuavaInterner(a));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build GuavaInterner, some of required attributes are not set " + attributes;
    }
  }
}
