package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UnderrideObjectMethods.InternUnderride}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInternUnderride.builder()}.
 */
@Generated(from = "UnderrideObjectMethods.InternUnderride", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInternUnderride
    implements UnderrideObjectMethods.InternUnderride {
  private final int d;

  private ImmutableInternUnderride(int d) {
    this.d = d;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public int d() {
    return d;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnderrideObjectMethods.InternUnderride#d() d} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInternUnderride withD(int value) {
    if (this.d == value) return this;
    return validate(new ImmutableInternUnderride(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInternUnderride} that have equal attribute values.
   * As instances of the {@code ImmutableInternUnderride} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(int synthetic, ImmutableInternUnderride another) {
    return UnderrideObjectMethods.InternUnderride.equalTo(this, another);
  }

  /**
   * Computes a hash code from attributes: {@code d}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + d;
    return h;
  }

  /**
   * Prints the immutable value {@code InternUnderride} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InternUnderride")
        .omitNullValues()
        .add("d", d)
        .toString();
  }

  @Generated(from = "UnderrideObjectMethods.InternUnderride", generator = "Immutables")
  private static class InternProxy {
    final ImmutableInternUnderride instance;

    InternProxy(ImmutableInternUnderride instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(0, ((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final class InternerHolder {
    static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();
  }

  private static ImmutableInternUnderride validate(ImmutableInternUnderride instance) {
    return InternerHolder.INTERNER.intern(new InternProxy(instance)).instance;
  }

  /**
   * Creates an immutable copy of a {@link UnderrideObjectMethods.InternUnderride} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InternUnderride instance
   */
  public static ImmutableInternUnderride copyOf(UnderrideObjectMethods.InternUnderride instance) {
    if (instance instanceof ImmutableInternUnderride) {
      return (ImmutableInternUnderride) instance;
    }
    return ImmutableInternUnderride.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInternUnderride ImmutableInternUnderride}.
   * <pre>
   * ImmutableInternUnderride.builder()
   *    .d(int) // required {@link UnderrideObjectMethods.InternUnderride#d() d}
   *    .build();
   * </pre>
   * @return A new ImmutableInternUnderride builder
   */
  public static ImmutableInternUnderride.Builder builder() {
    return new ImmutableInternUnderride.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInternUnderride ImmutableInternUnderride}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnderrideObjectMethods.InternUnderride", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_D = 0x1L;
    private long initBits = 0x1L;

    private int d;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InternUnderride} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnderrideObjectMethods.InternUnderride instance) {
      Objects.requireNonNull(instance, "instance");
      d(instance.d());
      return this;
    }

    /**
     * Initializes the value for the {@link UnderrideObjectMethods.InternUnderride#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(int d) {
      this.d = d;
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInternUnderride ImmutableInternUnderride}.
     * @return An immutable instance of InternUnderride
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInternUnderride build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableInternUnderride.validate(new ImmutableInternUnderride(d));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      return "Cannot build InternUnderride, some of required attributes are not set " + attributes;
    }
  }
}
