package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WeakInterningStyle.JdkInterner}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJdkInterner.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableJdkInterner.of()}.
 */
@Generated(from = "WeakInterningStyle.JdkInterner", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJdkInterner implements WeakInterningStyle.JdkInterner {
  private final int a;

  private ImmutableJdkInterner(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WeakInterningStyle.JdkInterner#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkInterner withA(int value) {
    if (this.a == value) return this;
    return validate(new ImmutableJdkInterner(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkInterner} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkInterner
        && equalTo(0, (ImmutableJdkInterner) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkInterner another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code JdkInterner} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JdkInterner{"
        + "a=" + a
        + "}";
  }

  private static final class InternerHolder {
    static final Map<ImmutableJdkInterner, WeakReference<ImmutableJdkInterner>> INTERNER =
        new WeakHashMap<>();
  }

  /**
   * Construct a new immutable {@code JdkInterner} instance.
   * @param a The value for the {@code a} attribute
   * @return An immutable JdkInterner instance
   */
  public static ImmutableJdkInterner of(int a) {
    return validate(new ImmutableJdkInterner(a));
  }

  private static ImmutableJdkInterner validate(ImmutableJdkInterner instance) {
    synchronized (InternerHolder.INTERNER) {
      @Nullable WeakReference<ImmutableJdkInterner> reference = InternerHolder.INTERNER.get(instance);
      @Nullable ImmutableJdkInterner interned = reference != null ? reference.get() : null;
      if (interned == null) {
        InternerHolder.INTERNER.put(instance, new WeakReference<>(instance));
        interned = instance;
      }
      return interned;
    }
  }

  /**
   * Creates an immutable copy of a {@link WeakInterningStyle.JdkInterner} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkInterner instance
   */
  public static ImmutableJdkInterner copyOf(WeakInterningStyle.JdkInterner instance) {
    if (instance instanceof ImmutableJdkInterner) {
      return (ImmutableJdkInterner) instance;
    }
    return ImmutableJdkInterner.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJdkInterner ImmutableJdkInterner}.
   * <pre>
   * ImmutableJdkInterner.builder()
   *    .a(int) // required {@link WeakInterningStyle.JdkInterner#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableJdkInterner builder
   */
  public static ImmutableJdkInterner.Builder builder() {
    return new ImmutableJdkInterner.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJdkInterner ImmutableJdkInterner}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WeakInterningStyle.JdkInterner", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JdkInterner} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WeakInterningStyle.JdkInterner instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link WeakInterningStyle.JdkInterner#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJdkInterner ImmutableJdkInterner}.
     * @return An immutable instance of JdkInterner
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJdkInterner build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableJdkInterner.validate(new ImmutableJdkInterner(a));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build JdkInterner, some of required attributes are not set " + attributes;
    }
  }
}
