package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NoValidation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNoValidation.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNoValidation.of()}.
 */
@Generated(from = "NoValidation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNoValidation implements NoValidation {
  private final String a;
  private final Integer b;
  private final boolean z;
  private final int i;
  private final List<String> list;
  private final Set<String> set;
  private final Map<String, Object> map;
  private final String c;

  private ImmutableNoValidation(String a, Integer b, boolean z, int i) {
    this.a = a;
    this.b = b;
    this.z = z;
    this.i = i;
    this.list = Collections.emptyList();
    this.set = Collections.emptySet();
    this.map = Collections.emptyMap();
    this.c = NoValidation.super.c();
  }

  private ImmutableNoValidation(ImmutableNoValidation.Builder builder) {
    this.a = builder.a;
    this.b = builder.b;
    this.z = builder.z;
    this.i = builder.i;
    this.list = createUnmodifiableList(true, builder.list);
    this.set = createUnmodifiableSet(builder.set);
    this.map = createUnmodifiableMap(false, false, builder.map);
    this.c = builder.cIsSet()
        ? builder.c
        : NoValidation.super.c();
  }

  private ImmutableNoValidation(
      String a,
      Integer b,
      boolean z,
      int i,
      List<String> list,
      Set<String> set,
      Map<String, Object> map,
      String c) {
    this.a = a;
    this.b = b;
    this.z = z;
    this.i = i;
    this.list = list;
    this.set = set;
    this.map = map;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public Integer b() {
    return b;
  }

  /**
   * @return The value of the {@code z} attribute
   */
  @Override
  public boolean z() {
    return z;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  public int i() {
    return i;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public List<String> list() {
    return list;
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @Override
  public Set<String> set() {
    return set;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public Map<String, Object> map() {
    return map;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public String c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoValidation#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoValidation withA(String value) {
    if (Objects.equals(this.a, value)) return this;
    return new ImmutableNoValidation(value, this.b, this.z, this.i, this.list, this.set, this.map, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoValidation#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoValidation withB(Integer value) {
    if (Objects.equals(this.b, value)) return this;
    return new ImmutableNoValidation(this.a, value, this.z, this.i, this.list, this.set, this.map, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoValidation#z() z} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for z
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoValidation withZ(boolean value) {
    if (this.z == value) return this;
    return new ImmutableNoValidation(this.a, this.b, value, this.i, this.list, this.set, this.map, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoValidation#i() i} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoValidation withI(int value) {
    if (this.i == value) return this;
    return new ImmutableNoValidation(this.a, this.b, this.z, value, this.list, this.set, this.map, this.c);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoValidation#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoValidation withList(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableNoValidation(this.a, this.b, this.z, this.i, newValue, this.set, this.map, this.c);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoValidation#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoValidation withList(Iterable<String> elements) {
    if (this.list == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableNoValidation(this.a, this.b, this.z, this.i, newValue, this.set, this.map, this.c);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoValidation#set() set}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoValidation withSet(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, newValue, this.map, this.c);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NoValidation#set() set}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoValidation withSet(Iterable<String> elements) {
    if (this.set == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, false, false));
    return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, newValue, this.map, this.c);
  }

  /**
   * Copy the current immutable object by replacing the {@link NoValidation#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNoValidation withMap(Map<String, ? extends Object> entries) {
    if (this.map == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, this.set, newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NoValidation#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNoValidation withC(String value) {
    String newValue = value;
    if (this.c.equals(newValue)) return this;
    return new ImmutableNoValidation(this.a, this.b, this.z, this.i, this.list, this.set, this.map, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNoValidation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNoValidation
        && equalTo(0, (ImmutableNoValidation) another);
  }

  private boolean equalTo(int synthetic, ImmutableNoValidation another) {
    return Objects.equals(a, another.a)
        && Objects.equals(b, another.b)
        && z == another.z
        && i == another.i
        && list.equals(another.list)
        && set.equals(another.set)
        && map.equals(another.map)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code z}, {@code i}, {@code list}, {@code set}, {@code map}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(a);
    h += (h << 5) + Objects.hashCode(b);
    h += (h << 5) + Boolean.hashCode(z);
    h += (h << 5) + i;
    h += (h << 5) + list.hashCode();
    h += (h << 5) + set.hashCode();
    h += (h << 5) + map.hashCode();
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NoValidation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NoValidation{"
        + "a=" + a
        + ", b=" + b
        + ", z=" + z
        + ", i=" + i
        + ", list=" + list
        + ", set=" + set
        + ", map=" + map
        + ", c=" + c
        + "}";
  }

  /**
   * Construct a new immutable {@code NoValidation} instance.
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param z The value for the {@code z} attribute
   * @param i The value for the {@code i} attribute
   * @return An immutable NoValidation instance
   */
  public static ImmutableNoValidation of(String a, Integer b, boolean z, int i) {
    return new ImmutableNoValidation(a, b, z, i);
  }

  /**
   * Creates an immutable copy of a {@link NoValidation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NoValidation instance
   */
  public static ImmutableNoValidation copyOf(NoValidation instance) {
    if (instance instanceof ImmutableNoValidation) {
      return (ImmutableNoValidation) instance;
    }
    return ImmutableNoValidation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNoValidation ImmutableNoValidation}.
   * <pre>
   * ImmutableNoValidation.builder()
   *    .a(String | null) // nullable {@link NoValidation#a() a}
   *    .b(Integer | null) // nullable {@link NoValidation#b() b}
   *    .z(boolean) // optional {@link NoValidation#z() z}
   *    .i(int) // optional {@link NoValidation#i() i}
   *    .addList|addAllList(String) // {@link NoValidation#list() list} elements
   *    .addSet|addAllSet(String) // {@link NoValidation#set() set} elements
   *    .putMap|putAllMap(String =&gt; Object) // {@link NoValidation#map() map} mappings
   *    .c(String) // optional {@link NoValidation#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableNoValidation builder
   */
  public static ImmutableNoValidation.Builder builder() {
    return new ImmutableNoValidation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNoValidation ImmutableNoValidation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NoValidation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_C = 0x1L;
    private long optBits;

    private @Nullable String a;
    private @Nullable Integer b;
    private boolean z;
    private int i;
    private List<String> list = new ArrayList<String>();
    private List<String> set = new ArrayList<String>();
    private Map<String, Object> map = new LinkedHashMap<String, Object>();
    private @Nullable String c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NoValidation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NoValidation instance) {
      Objects.requireNonNull(instance, "instance");
      String aValue = instance.a();
      if (aValue != null) {
        a(aValue);
      }
      Integer bValue = instance.b();
      if (bValue != null) {
        b(bValue);
      }
      z(instance.z());
      i(instance.i());
      addAllList(instance.list());
      addAllSet(instance.set());
      putAllMap(instance.map());
      c(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link NoValidation#a() a} attribute.
     * @param a The value for a (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(String a) {
      this.a = a;
      return this;
    }

    /**
     * Initializes the value for the {@link NoValidation#b() b} attribute.
     * @param b The value for b (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(Integer b) {
      this.b = b;
      return this;
    }

    /**
     * Initializes the value for the {@link NoValidation#z() z} attribute.
     * @param z The value for z 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder z(boolean z) {
      this.z = z;
      return this;
    }

    /**
     * Initializes the value for the {@link NoValidation#i() i} attribute.
     * @param i The value for i 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i(int i) {
      this.i = i;
      return this;
    }

    /**
     * Adds one element to {@link NoValidation#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(@Nullable String element) {
      this.list.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NoValidation#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(String... elements) {
      for (String element : elements) {
        this.list.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NoValidation#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder list(Iterable<String> elements) {
      this.list.clear();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link NoValidation#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllList(Iterable<String> elements) {
      for (String element : elements) {
        this.list.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link NoValidation#set() set} set.
     * @param element A set element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(@Nullable String element) {
      this.set.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NoValidation#set() set} set.
     * @param elements An array of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(String... elements) {
      for (String element : elements) {
        this.set.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NoValidation#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder set(Iterable<String> elements) {
      this.set.clear();
      return addAllSet(elements);
    }

    /**
     * Adds elements to {@link NoValidation#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSet(Iterable<String> elements) {
      for (String element : elements) {
        this.set.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link NoValidation#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(@Nullable String key, @Nullable Object value) {
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NoValidation#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.map.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NoValidation#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder map(Map<String, ? extends Object> entries) {
      this.map.clear();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NoValidation#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.map.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NoValidation#c() c} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NoValidation#c() c}.</em>
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(String c) {
      this.c = c;
      optBits |= OPT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNoValidation ImmutableNoValidation}.
     * @return An immutable instance of NoValidation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNoValidation build() {
      return new ImmutableNoValidation(this);
    }

    private boolean cIsSet() {
      return (optBits & OPT_BIT_C) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
